/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

public abstract class Log4JConfiguration {
    private static boolean isInitialized = false;

    public static void initialize() {
        if (!isInitialized) {
            try {
                Properties defaultLog4JProperties = new Properties();
                defaultLog4JProperties.setProperty("log4j.rootLogger", "info, stdout");
                defaultLog4JProperties.setProperty("log4j.appender.julAppender", "org.lsst.ccs.utilities.logging.JULAppender");
                defaultLog4JProperties.setProperty("log4j.appender.stdout", "org.lsst.ccs.utilities.logging.JULAppender");
                defaultLog4JProperties.setProperty("log4j.appender.stdout.layout", "org.apache.log4j.PatternLayout");
                defaultLog4JProperties.setProperty("log4j.appender.julAppender.layout", "org.apache.log4j.PatternLayout");
                defaultLog4JProperties.setProperty("log4j.appender.stdout.layout.ConversionPattern", "%d{ISO8601} - %m%n");
                defaultLog4JProperties.setProperty("log4j.logger.org.springframework.aop", "error");
                defaultLog4JProperties.setProperty("log4j.logger.org.springframework", "error");
                Properties externalProps = BootstrapResourceUtils.getBootstrapProperties("log4j");
                for (String string : BootstrapResourceUtils.getAllKeysInProperties(externalProps)) {
                    defaultLog4JProperties.put(string, externalProps.getProperty(string));
                }
                PropertyConfigurator.configure((Properties)defaultLog4JProperties);
                isInitialized = true;
            }
            catch (Exception e) {
                System.out.println("#### Cannot load Log4J properties file");
            }
        }
    }
}

