/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.SchedulerNode;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.Scheduler;

class PeriodicTaskComponent
implements HasLifecycle {
    private final Random randomizer = new Random();
    private PeriodicTaskWithScheduler task;
    private final Object taskLock = new Object();
    @ConfigurationParameter(category="timers")
    private long taskPeriodMillis = -1L;
    private boolean hasBeenStarted = false;
    private final String schedulerName;
    private final AgentPeriodicTask taskDefinition;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentPeriodicTaskService agentPeriodicTaskService;

    PeriodicTaskComponent(AgentPeriodicTask t, String schedulerName) {
        this.schedulerName = schedulerName;
        this.taskDefinition = t;
        this.taskPeriodMillis = t.getPeriod().toMillis();
    }

    @Override
    public void postInit() {
        SchedulerNode schedulerNode = this.agentPeriodicTaskService.getScheduler(this.schedulerName);
        if (schedulerNode == null) {
            throw new RuntimeException("Could not find scheduler " + this.schedulerName);
        }
        this.task = new PeriodicTaskWithScheduler(new PeriodicTask(schedulerNode.getScheduler(), this.taskDefinition.getRunnable(), this.taskDefinition.isIsFixedRate(), this.taskDefinition.getTaskName(), this.taskDefinition.getLogLevel(), this.taskPeriodMillis, TimeUnit.MILLISECONDS), schedulerNode.getScheduler());
        if (this.task == null) {
            throw new RuntimeException("The PeriodicTask cannot be null");
        }
        if (this.task.getPeriodicTask().getTaskName().isEmpty()) {
            throw new RuntimeException("The PeriodicTask cannot have an empty name");
        }
        schedulerNode.addTask(this.taskDefinition.getTaskName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConfigurationParameterChanger(propertyName="taskPeriodMillis")
    public void setTaskPeriodMillis(long taskPeriodMillis) {
        Object object = this.taskLock;
        synchronized (object) {
            if (this.taskPeriodMillis != taskPeriodMillis) {
                this.taskPeriodMillis = taskPeriodMillis;
                if (this.hasBeenStarted) {
                    this.task.getPeriodicTask().stop();
                    if (taskPeriodMillis > 0L) {
                        this.startTask();
                    }
                }
            }
        }
    }

    public long getTaskPeriodMillis() {
        return this.taskPeriodMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTask() {
        Object object = this.taskLock;
        synchronized (object) {
            if (this.taskPeriodMillis > 0L) {
                this.task.getPeriodicTask().setPeriod(this.taskPeriodMillis, TimeUnit.MILLISECONDS);
                long initialRandomDelay = (long)(this.randomizer.nextDouble() * (double)this.taskPeriodMillis);
                this.task.getPeriodicTask().start(initialRandomDelay, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTask() {
        Object object = this.taskLock;
        synchronized (object) {
            this.task.getPeriodicTask().stop();
        }
    }

    @Override
    public void shutdown() {
        this.stopTask();
    }

    @Override
    public void postStart() {
        if (this.hasBeenStarted) {
            return;
        }
        this.hasBeenStarted = true;
        this.startTask();
    }

    PeriodicTaskWithScheduler getTask() {
        return this.task;
    }

    static class PeriodicTaskWithScheduler {
        private final PeriodicTask task;
        private final Scheduler scheduler;

        PeriodicTaskWithScheduler(PeriodicTask task, Scheduler scheduler) {
            this.task = task;
            this.scheduler = scheduler;
        }

        PeriodicTask getPeriodicTask() {
            return this.task;
        }

        Scheduler getScheduler() {
            return this.scheduler;
        }
    }
}

