/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.drivers.auxelex.PduCommon;
import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.utilities.conv.Convert;

public class PduHV
extends PduCommon {
    public static final int CHAN_ION_PUMPS = 0;
    public static final int CHAN_UNUSED_24C = 1;
    public static final int CHAN_FES_CHANGER_C = 2;
    public static final int CHAN_BPU_MAQ20 = 3;
    public static final int CHAN_SHUTTER_1 = 4;
    public static final int CHAN_SHUTTER_2 = 5;
    public static final int CHAN_FES_CAROUSEL = 6;
    public static final int CHAN_FES_LOADER_C = 7;
    public static final int CHAN_BODY_PURGE = 8;
    public static final int CHAN_GAUGES = 9;
    public static final int CHAN_HCU_PWR_CRY = 10;
    public static final int CHAN_HCU_FES_SHU = 11;
    public static final int NUM_CHANS_24C = 12;
    public static final int CHAN_FES_LOADER_D = 0;
    public static final int CHAN_FES_CHANGER_D = 1;
    public static final int CHAN_CRYO_TURBO = 2;
    public static final int CHAN_HEX_TURBO = 3;
    public static final int CHAN_FES_CLAMPS = 4;
    public static final int CHAN_FES_BRAKES = 5;
    public static final int CHAN_SHUTTER_BRAKE = 6;
    public static final int NUM_CHANS_24D = 7;
    public static final int CHAN_FES_CAROUSEL_D = 0;
    public static final int CHAN_UNUSED_48 = 1;
    public static final int CHAN_SHUTTER_1_D = 2;
    public static final int CHAN_SHUTTER_2_D = 3;
    public static final int CHAN_PURGE_FAN = 4;
    public static final int CHAN_FES_HEATER = 5;
    public static final int NUM_CHANS_48 = 6;
    public static final int MAIN_MODEL_UNKNOWN = -1;
    public static final int MAIN_MODEL_12 = 0;
    public static final int MAIN_MODEL_28 = 1;
    public static final int MAIN_MODEL_48 = 2;
    public static final int MAIN_STATUS_OFF = 1;
    public static final int MAIN_STATUS_DSAB = 2;
    public static final int MAIN_STATUS_IOGB = 4;
    public static final int MAIN_STATUS_OTW = 8;
    public static final int MAIN_STATUS_OTP = 16;
    public static final int MAIN_STATUS_VBAD = 32;
    public static final int MAIN_STATUS_IBAD = 64;
    public static final int MAIN_STATUS_MASK = 127;
    private static final Map<String, Integer> CHANNEL_MAP_24C = new HashMap<String, Integer>();
    private static final Map<String, Integer> CHANNEL_MAP_24D;
    private static final Map<String, Integer> CHANNEL_MAP_48;
    private static final List<Srp.BoardType> VALID_TYPES;
    private static final int VALID_CHAN_MASK_24C = 4093;
    private static final int VALID_CHAN_MASK_24D = 127;
    private static final int VALID_CHAN_MASK_48 = 61;
    private static final double SHUNT_040 = 0.004;
    private static final int REG_TEMP_BASE = 79872;
    private static final int REG_BOARD_TEMP = 79872;
    private static final int REG_FPGA_TEMP = 79873;
    private static final int MAX_CHANNELS = 12;
    private static final int REG_LAMBDA_BASE = 78848;
    private static final int REG_SERIAL_NO = 78848;
    private static final int REG_FW_VERSION = 78853;
    private static final int REG_PR_VERSION = 78854;
    private static final int REG_VOLTAGE = 78855;
    private static final int REG_CURRENT = 78856;
    private static final int REG_TEMP = 78857;
    private static final int REG_STATUS = 78858;
    private static final int REG_PART_NO = 78859;
    private static final int REG_MANU_DATE = 78862;
    private static final int REG_MANU_LOCN = 78864;
    private static final int LENG_SERIAL_NO = 20;
    private static final int LENG_FW_VERSION = 4;
    private static final int LENG_PR_VERSION = 4;
    private static final int LENG_PART_NO = 12;
    private static final int LENG_MANU_DATE = 8;
    private static final int LENG_MANU_LOCN = 3;
    private static final int ADC_BAD_MASK = -1024;
    private static final Map<String, Integer> MAIN_MODEL_MAP;
    private static final double[] V_SCALES;
    private static final double[] I_SCALES;
    private static final double T_SCALE = 2.048;
    private int mainModel;
    private double vScale;
    private double iScale;

    public PduHV() {
        this.setValidBoardTypes(VALID_TYPES);
    }

    @Override
    public synchronized void open(String host, int port) throws DriverException {
        int numChans;
        super.open(host, port);
        Srp.BoardType type = this.getBoardType();
        if (type == Srp.BoardType.PDU_48V) {
            this.setValidChannels(61);
            this.setChannelMap(CHANNEL_MAP_48);
            numChans = 6;
        } else if (type == Srp.BoardType.PDU_24V_DIRTY) {
            this.setValidChannels(127);
            this.setChannelMap(CHANNEL_MAP_24D);
            numChans = 7;
        } else {
            this.setValidChannels(4093);
            this.setChannelMap(CHANNEL_MAP_24C);
            numChans = 12;
        }
        double[] currScales = new double[numChans];
        for (int j = 0; j < numChans; ++j) {
            currScales[j] = 0.00625;
        }
        this.setCurrentScales(currScales);
        this.mainModel = -1;
        try {
            String mName = this.getMainPartNo();
            if (mName.startsWith("CPFE1000FI")) {
                Integer mod = MAIN_MODEL_MAP.get(mName.substring(10));
                int n = this.mainModel = mod == null ? this.mainModel : mod;
            }
            if (this.mainModel == -1) {
                throw new DriverException("Unrecognized Lambda PS model: " + mName);
            }
            this.vScale = V_SCALES[this.mainModel];
            this.iScale = I_SCALES[this.mainModel];
        }
        catch (DriverException e) {
            this.close();
            throw e;
        }
    }

    public double readBoardTemperature() throws DriverException {
        return this.readReg(79872);
    }

    public double readFpgaTemperature() throws DriverException {
        return this.readReg(79873);
    }

    public int getMainModel() {
        return this.mainModel;
    }

    public String getMainSerialNo() throws DriverException {
        return this.readString(78848, 20);
    }

    public String getMainFwVersion() throws DriverException {
        return this.readString(78853, 4);
    }

    public String getMainPrVersion() throws DriverException {
        return this.readString(78854, 4);
    }

    public String getMainPartNo() throws DriverException {
        return this.readString(78859, 12);
    }

    public String getMainManuDate() throws DriverException {
        return this.readString(78862, 8);
    }

    public String getMainManuLocn() throws DriverException {
        return this.readString(78864, 3);
    }

    public int readMainStatus() throws DriverException {
        return this.readReg(78858) & 0x7F;
    }

    public double readMainVoltage() throws DriverException {
        return PduHV.fixValue(this.readReg(78855)) * this.vScale;
    }

    public double readMainCurrent() throws DriverException {
        return PduHV.fixValue(this.readReg(78856)) * this.iScale;
    }

    public double readMainTemperature() throws DriverException {
        return (PduHV.fixValue(this.readReg(78857)) - 610.0) / 2.048 + 25.0;
    }

    private static double fixValue(int raw) {
        return (raw & 0xFFFFFC00) == 0 ? (double)raw : Double.NaN;
    }

    private String readString(int addr, int leng) throws DriverException {
        int[] words = this.readRegs(addr, (leng + 3) / 4);
        byte[] bytes = new byte[4 * words.length];
        for (int j = 0; j < words.length; ++j) {
            Convert.intToBytesBE((int)words[j], (byte[])bytes, (int)(4 * j));
        }
        return new String(bytes, 0, leng);
    }

    static {
        CHANNEL_MAP_24C.put("bodyPurge", 8);
        CHANNEL_MAP_24C.put("fesChanger", 2);
        CHANNEL_MAP_24C.put("fesCarousel", 6);
        CHANNEL_MAP_24C.put("fesLoader", 7);
        CHANNEL_MAP_24C.put("shutter1", 4);
        CHANNEL_MAP_24C.put("shutter2", 5);
        CHANNEL_MAP_24C.put("bpuMaq20", 3);
        CHANNEL_MAP_24C.put("ionPumps", 0);
        CHANNEL_MAP_24C.put("gauges", 9);
        CHANNEL_MAP_24C.put("hcuPwrCry", 10);
        CHANNEL_MAP_24C.put("hcuFesShu", 11);
        CHANNEL_MAP_24C.put("unused", 1);
        CHANNEL_MAP_24D = new HashMap<String, Integer>();
        CHANNEL_MAP_24D.put("fesLoader", 0);
        CHANNEL_MAP_24D.put("fesChanger", 1);
        CHANNEL_MAP_24D.put("cryoTurbo", 2);
        CHANNEL_MAP_24D.put("hexTurbo", 3);
        CHANNEL_MAP_24D.put("fesClamps", 4);
        CHANNEL_MAP_24D.put("fesBrakes", 5);
        CHANNEL_MAP_24D.put("shuBrakes", 6);
        CHANNEL_MAP_48 = new HashMap<String, Integer>();
        CHANNEL_MAP_48.put("fesCarousel", 0);
        CHANNEL_MAP_48.put("fesHeater", 5);
        CHANNEL_MAP_48.put("shutter1", 2);
        CHANNEL_MAP_48.put("shutter2", 3);
        CHANNEL_MAP_48.put("purgeFan", 4);
        CHANNEL_MAP_48.put("unused", 1);
        VALID_TYPES = new ArrayList<Srp.BoardType>();
        VALID_TYPES.add(Srp.BoardType.PDU_24V_CLEAN);
        VALID_TYPES.add(Srp.BoardType.PDU_24V_DIRTY);
        VALID_TYPES.add(Srp.BoardType.PDU_48V);
        MAIN_MODEL_MAP = new HashMap<String, Integer>();
        MAIN_MODEL_MAP.put("12", 0);
        MAIN_MODEL_MAP.put("28", 1);
        MAIN_MODEL_MAP.put("48", 2);
        V_SCALES = new double[]{0.01668, 0.03973, 0.06772};
        I_SCALES = new double[]{0.0815, 0.0488, 0.0282};
    }
}

