/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling.imagedb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.imagedb.ImageDatabaseService;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.SensorLocation;

public class ImageFileDatabase
implements AutoCloseable {
    private static final int MAX_RETRIES = 1;
    private Connection conn;
    private static final Logger LOG = Logger.getLogger(ImageFileDatabase.class.getName());
    private final ImageDatabaseService imageDatabaseService;
    private final String host;
    private PreparedStatement stmt1;
    private PreparedStatement stmt2;

    public ImageFileDatabase(ImageDatabaseService imageDatabaseService) {
        String localHost;
        this.imageDatabaseService = imageDatabaseService;
        try {
            localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            localHost = "Unknown";
        }
        this.host = localHost;
    }

    private void openConnection() throws SQLException {
        this.conn = this.imageDatabaseService.openConnection();
        try (PreparedStatement stmt = this.conn.prepareStatement("create table if not exists ccs_image_file (\nfile_id int not null AUTO_INCREMENT,\ntelCode varchar(2) not null,\nseqnum integer not null,\ndayobs varchar(8) not null,\ncontroller varchar(2) not null,\nfileType varchar(24) not null,\nraft varchar(3) not null,\nsensor varchar(3) not null,\nwriteHost varchar(64) not null,\nwriteFile varchar(255) not null,\nprimary key (telCode, seqnum, dayobs, controller, fileType, raft, sensor),\nindex(file_id)\n)");){
            stmt.execute();
        }
        stmt = this.conn.prepareStatement("create table if not exists ccs_image_file_operation (\nfile_id int not null,\noperation varchar(20) not null,\noperation_return_code int,\ntime float not null,\nsuccess boolean not null,\nreason varchar(256),\nprimary key (file_id, operation)\n)");
        try {
            stmt.execute();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        this.stmt1 = this.conn.prepareStatement("insert into ccs_image_file (telcode, seqnum, dayobs, controller, fileType, raft, sensor, writeHost, writeFile) values (?, ?, ?, ?, ?,        ?, ?, ?, ?) ", 1);
        this.stmt2 = this.conn.prepareStatement("insert into ccs_image_file_operation (file_id, operation, operation_return_code, time, success, reason) values (?, ?, ?, ?, ?, ?)");
    }

    public synchronized int insertFile(ImageName obsId, SensorLocation location, String fileType, String file) throws SQLException {
        int i = 0;
        while (true) {
            if (this.conn == null || this.conn.isClosed()) {
                this.openConnection();
            }
            try {
                int auto_id;
                this.stmt1.setString(1, obsId.getSource().getCode());
                this.stmt1.setInt(2, obsId.getNumber());
                this.stmt1.setString(3, obsId.getDateString());
                this.stmt1.setString(4, obsId.getController().getCode());
                this.stmt1.setString(5, fileType);
                if (location != null) {
                    Location rebLocation = location.getRebLocation();
                    this.stmt1.setString(6, rebLocation.getRaftName());
                    this.stmt1.setString(7, rebLocation.getSensorName(location.getSensor()));
                } else {
                    this.stmt1.setString(6, "NR");
                    this.stmt1.setString(7, "NS");
                }
                this.stmt1.setString(8, this.host);
                this.stmt1.setString(9, file);
                this.stmt1.execute();
                try (ResultSet rs = this.stmt1.getGeneratedKeys();){
                    rs.next();
                    auto_id = rs.getInt(1);
                }
                this.conn.commit();
                return auto_id;
            }
            catch (SQLException x) {
                if (i < 1) {
                    LOG.log(Level.FINE, "Database update failed, retrying", x);
                    try {
                        this.close();
                    }
                    catch (SQLException sQLException) {}
                } else {
                    throw x;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public synchronized void insertFileOperations(List<Operation> operations) throws SQLException {
        int i = 0;
        while (true) {
            if (this.conn == null || this.conn.isClosed()) {
                this.openConnection();
            }
            try {
                for (Operation operation : operations) {
                    this.stmt2.setInt(1, operation.fileId);
                    this.stmt2.setString(2, operation.operation);
                    this.stmt2.setInt(3, operation.operation_return_code);
                    this.stmt2.setFloat(4, operation.time);
                    this.stmt2.setBoolean(5, operation.success);
                    this.stmt2.setString(6, operation.reason);
                    this.stmt2.addBatch();
                }
                this.stmt2.executeBatch();
                this.conn.commit();
                return;
            }
            catch (SQLException x) {
                if (i < 1) {
                    LOG.log(Level.FINE, "Database update failed, retrying", x);
                    try {
                        this.close();
                    }
                    catch (SQLException sQLException) {}
                } else {
                    throw x;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    Connection getConnection() {
        return this.conn;
    }

    @Override
    public void close() throws SQLException {
        if (this.conn != null) {
            this.imageDatabaseService.closeConnection();
            this.conn = null;
        }
    }

    public record Operation(int fileId, String operation, int operation_return_code, float time, boolean success, String reason) {
    }
}

