/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.Serializable;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.Duration;
import java.util.List;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.data.AgentAlerts;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.data.RuntimeInfo;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentMonitor;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.logging.Logger;

public final class RuntimeService
implements ServiceLifecycle,
HasLifecycle,
AgentMonitor,
AgentService {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.services");
    private final ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    private AlertState internalState = AlertState.NOMINAL;
    private final long startedTime = System.currentTimeMillis();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dataProviderDictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private List<BufferPoolMXBean> bufferPools;

    @Override
    public String getAgentServiceName() {
        return "runtimeService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return agentInfo.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0;
    }

    @Override
    public void build() {
        AgentPeriodicTask runtimeInfoPublisher = new AgentPeriodicTask("runtimeInfo", () -> {
            KeyValueDataList kvd = this.getData();
            this.agent.publishSubsystemDataOnStatusBus((KeyValueData)kvd);
        }).withPeriod(Duration.ofMinutes(1L));
        this.periodicTaskService.scheduleAgentPeriodicTask(runtimeInfoPublisher);
        this.dataProviderDictionaryService.registerClass(RuntimeInfo.class, "runtimeInfo");
        this.bufferPools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        for (BufferPoolMXBean bufferPool : this.bufferPools) {
            this.dataProviderDictionaryService.registerClass(BufferPoolData.class, "runtimeInfo/" + bufferPool.getName());
        }
    }

    @Override
    public void init() {
        this.alertService.registerAlert(AgentAlerts.RuntimeAlert.getAlert(), new ClearAlertHandler(){

            @Override
            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState state) {
                String alertId = alert.getAlertId();
                if (alertId.equals(AgentAlerts.RuntimeAlert.getAlertId())) {
                    RuntimeService.this.internalState = AlertState.NOMINAL;
                    return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
            }
        });
    }

    private KeyValueDataList getData() {
        int uptime = (int)(System.currentTimeMillis() - this.startedTime) / 1000;
        RuntimeInfo runtimeInfo = new RuntimeInfo((long)uptime);
        KeyValueDataList s = new KeyValueDataList();
        s.addData("runtimeInfo", (Serializable)runtimeInfo);
        for (BufferPoolMXBean bufferPool : this.bufferPools) {
            s.addData("runtimeInfo/" + bufferPool.getName(), (Serializable)new BufferPoolData(bufferPool));
        }
        return s;
    }

    @Override
    public String getAgentMonitorStatus(boolean useCcsBuses) {
        return this.getStatus(useCcsBuses);
    }

    @Override
    public String getAgentMonitorDescription() {
        return "Runtime Agent Monitor";
    }

    private synchronized String getStatus(boolean publish) {
        ThreadInfo[] threadInfos;
        long[] deadlockedThreadIds = this.mbean.findDeadlockedThreads();
        StringBuilder sb = new StringBuilder();
        if (deadlockedThreadIds != null && (threadInfos = this.mbean.getThreadInfo(deadlockedThreadIds)) != null) {
            for (ThreadInfo threadInfo : threadInfos) {
                if (threadInfo == null) continue;
                for (Thread thread : Thread.getAllStackTraces().keySet()) {
                    if (thread.getId() != threadInfo.getThreadId()) continue;
                    sb.append(threadInfo.toString().trim()).append("\n");
                    for (StackTraceElement ste : thread.getStackTrace()) {
                        sb.append("\t").append(ste.toString().trim()).append("\n");
                    }
                }
            }
        }
        boolean isOk = sb.toString().isEmpty();
        if (publish) {
            boolean publishStateChange = false;
            if (this.internalState != AlertState.NOMINAL && isOk) {
                this.internalState = AlertState.NOMINAL;
                publishStateChange = true;
            } else if (!isOk) {
                if (this.internalState == AlertState.NOMINAL) {
                    this.internalState = AlertState.WARNING;
                    publishStateChange = true;
                } else if (this.internalState == AlertState.WARNING) {
                    this.internalState = AlertState.ALARM;
                    publishStateChange = true;
                }
            }
            if (publishStateChange) {
                this.alertService.raiseAlert(AgentAlerts.RuntimeAlert.getAlert(null), this.internalState, sb.toString());
            }
        }
        return isOk ? "OK" : sb.toString();
    }

    public static class BufferPoolData
    implements Serializable {
        @DataAttributes(units="unitless", description="Estimated number of buffers in pool")
        final long nBuffers;
        @DataAttributes(units="bytes", description="Memory used by this buffer pool")
        final long memoryUsed;
        @DataAttributes(units="bytes", description="Total capacity for this buffer pool")
        final long totalCapacity;

        BufferPoolData(BufferPoolMXBean bean) {
            this.nBuffers = bean.getCount();
            this.memoryUsed = bean.getMemoryUsed();
            this.totalCapacity = bean.getTotalCapacity();
        }
    }
}

