/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.location;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.utilities.location.Location;

public class LocationSet
extends AbstractSet<Location>
implements Serializable {
    private static final long serialVersionUID = -4332892191028786738L;
    private static final long[] ALL_BITS = new long[]{0x7777777777737773L, 0x377737777L};
    private final BitSet locations = new BitSet();
    private static final Pattern RAFT_PATTERN = Pattern.compile("(-?)R(\\d\\d)");

    public LocationSet() {
    }

    public LocationSet(String locations) {
        this();
        if (locations != null && !locations.trim().isEmpty()) {
            LocationSet.locationsFromCommaDelimitedString(locations, this.locations);
        }
    }

    public LocationSet(Set<Location> input) {
        this();
        if (input instanceof LocationSet) {
            this.locations.or(((LocationSet)input).locations);
        } else if (input != null) {
            input.forEach(l -> this.locations.set(l.index()));
        }
    }

    public static LocationSet all() {
        return new LocationSet(BitSet.valueOf(ALL_BITS));
    }

    public static LocationSet of(String ... location) {
        BitSet locations = new BitSet();
        for (String l : location) {
            LocationSet.locationsFromCommaDelimitedString(l, locations);
        }
        return new LocationSet(locations);
    }

    private static void locationsFromCommaDelimitedString(String l, BitSet bitSet) throws NumberFormatException {
        String[] ll;
        if (l.trim().isEmpty()) {
            return;
        }
        for (String lll : ll = l.split(",")) {
            boolean negative;
            Matcher matcher = RAFT_PATTERN.matcher(lll = lll.trim());
            if (matcher.matches()) {
                int i;
                negative = "-".matches(matcher.group(1));
                int raft = Integer.parseInt(matcher.group(2));
                Location start = new Location(raft, 0);
                if (negative) {
                    if (bitSet.isEmpty()) {
                        bitSet.or(BitSet.valueOf(ALL_BITS));
                    }
                    for (i = 0; i < (start.type() == Location.LocationType.SCIENCE ? 3 : 2); ++i) {
                        bitSet.clear(start.index() + i);
                    }
                    continue;
                }
                for (i = 0; i < (start.type() == Location.LocationType.SCIENCE ? 3 : 2); ++i) {
                    bitSet.set(start.index() + i);
                }
                continue;
            }
            negative = lll.startsWith("-");
            if (negative) {
                if (bitSet.isEmpty()) {
                    bitSet.or(BitSet.valueOf(ALL_BITS));
                }
                bitSet.clear(Location.of(lll.substring(1)).index());
                continue;
            }
            bitSet.set(Location.of(lll).index());
        }
    }

    public LocationSet(BitSet bitset) {
        this();
        this.locations.or(bitset);
    }

    public BitSet getBitSet() {
        BitSet result = new BitSet();
        result.or(this.locations);
        return result;
    }

    @Override
    public boolean add(Location location) {
        int index = location.index();
        boolean wasSet = this.locations.get(index);
        this.locations.set(index);
        return wasSet;
    }

    @Override
    public void clear() {
        this.locations.clear();
    }

    @Override
    public boolean remove(Object location) {
        if (location instanceof Location) {
            int index = ((Location)location).index();
            boolean wasSet = this.locations.get(index);
            this.locations.clear(index);
            return wasSet;
        }
        return false;
    }

    boolean isSet(int i) {
        return this.locations.get(i);
    }

    @Override
    public Iterator<Location> iterator() {
        return new Iterator<Location>(){
            private int current = -1;

            @Override
            public boolean hasNext() {
                return LocationSet.this.locations.nextSetBit(this.current + 1) >= 0;
            }

            @Override
            public Location next() {
                this.current = LocationSet.this.locations.nextSetBit(this.current + 1);
                return new Location(this.current);
            }

            @Override
            public void remove() {
                LocationSet.this.locations.clear(this.current);
            }
        };
    }

    @Override
    public int size() {
        return this.locations.cardinality();
    }

    public int[] asIntArray() {
        int[] result = new int[this.locations.cardinality()];
        int i = 0;
        for (Location l : this) {
            result[i++] = l.getBay() * 4 + l.getBoard();
        }
        return result;
    }
}

