/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling.imagedb;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.imagedb.ImageDatabaseService;
import org.lsst.ccs.subsystem.imagehandling.imagedb.ImageFileDatabase;
import org.lsst.ccs.utilities.location.SensorLocation;

public class MissingOperationsTest {
    static String createConnection() {
        return "jdbc:h2:mem:test;MODE=MYSQL";
    }

    @Test
    public void missingOperationsTest() throws SQLException {
        ImageDatabaseService idbs = ImageDatabaseService.testInstance((String)MissingOperationsTest.createConnection());
        try (ImageFileDatabase ifdb = new ImageFileDatabase(idbs);){
            ImageName in = new ImageName("MC_C_20190610_001309");
            SensorLocation location = new SensorLocation(2, 2, 2);
            int file_id1 = ifdb.insertFile(in, location, "TYPE", "TEST_FILE1");
            float dummy_elapsed = 11232.1f;
            ImageFileDatabase.Operation operation = new ImageFileDatabase.Operation(file_id1, "SMOOTH", 0, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            in = new ImageName("MC_C_20190610_0013010");
            location = new SensorLocation(3, 2, 2);
            int file_id2 = ifdb.insertFile(in, location, "TYPE", "TEST_FILE2");
            dummy_elapsed = 11235.1f;
            operation = new ImageFileDatabase.Operation(file_id2, "SMOOTH", 0, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            in = new ImageName("MC_C_20190610_0013012");
            location = new SensorLocation(3, 2, 2);
            int file_id3 = ifdb.insertFile(in, location, "TYPE", "TEST_FILE3");
            dummy_elapsed = 11245.1f;
            in = new ImageName("MC_C_20190610_0013052");
            location = new SensorLocation(1, 2, 2);
            int file_id4 = ifdb.insertFile(in, location, "TYPE", "TEST_FILE4");
            dummy_elapsed = 11275.1f;
            Date dateBefore = Date.valueOf("2052-03-22");
            List missingFileNames = ifdb.missingFileNames(dateBefore);
            Assert.assertTrue((boolean)missingFileNames.contains("TEST_FILE3"));
            Assert.assertTrue((boolean)missingFileNames.contains("TEST_FILE4"));
            dateBefore = Date.valueOf("2012-03-22");
            missingFileNames.clear();
            missingFileNames = ifdb.missingFileNames(dateBefore);
            Assert.assertTrue((boolean)missingFileNames.isEmpty());
            dateBefore = Date.valueOf("2052-03-22");
            in = new ImageName("MC_C_20190610_002220");
            location = new SensorLocation(1, 2, 2);
            int file_id5 = ifdb.insertFile(in, location, "TYPE", "TEST_FILE5");
            dummy_elapsed = 11232.1f;
            operation = new ImageFileDatabase.Operation(file_id5, "SMOOTH", 1, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            in = new ImageName("MC_C_20190610_001220");
            location = new SensorLocation(1, 2, 2);
            int file_id6 = ifdb.insertFile(in, location, "TYPE", "TEST_FILE6");
            dummy_elapsed = 11236.1f;
            operation = new ImageFileDatabase.Operation(file_id6, "SMOOTH", 0, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            List failedOperationFileNames = ifdb.failedOperationFileNames(dateBefore);
            Assert.assertTrue((boolean)failedOperationFileNames.contains("TEST_FILE5"));
            Assert.assertTrue((!failedOperationFileNames.contains("TEST_FILE6") ? 1 : 0) != 0);
        }
    }

    @Test
    public void missingUSDFTest() throws SQLException {
        ImageDatabaseService idbs = ImageDatabaseService.testInstance((String)MissingOperationsTest.createConnection());
        try (ImageFileDatabase ifdb = new ImageFileDatabase(idbs);){
            ImageName in = new ImageName("MC_C_20190610_001319");
            SensorLocation location = new SensorLocation(2, 2, 2);
            int file_id1 = ifdb.insertFile(in, location, "TYPE", "TEST_FILE_USDF_SUCCESS");
            float dummy_elapsed = 11232.1f;
            ImageFileDatabase.Operation operation = new ImageFileDatabase.Operation(file_id1, "usdf_fits_copy", 0, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            dummy_elapsed = 11233.2f;
            operation = new ImageFileDatabase.Operation(file_id1, "RANDOM_OPERATION1", 0, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            PreparedStatement stmt1 = ifdb.getConnection().prepareStatement("select * from ccs_image_file where file_id = ?");
            stmt1.setInt(1, file_id1);
            ResultSet rs1 = stmt1.executeQuery();
            rs1.next();
            List missingUSDFFiles = ifdb.missingFailedUSDFFileNames(rs1.getString("dayobs"), 10);
            System.out.println(missingUSDFFiles.toString());
            Assert.assertTrue((boolean)missingUSDFFiles.isEmpty());
            in = new ImageName("MC_C_20190610_001311");
            location = new SensorLocation(1, 2, 1);
            int file_id2 = ifdb.insertFile(in, location, "TYPE2", "TEST_FILE_USDF_FAILED");
            dummy_elapsed = 11233.3f;
            operation = new ImageFileDatabase.Operation(file_id2, "RANDOM_OPERATION2", 0, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            dummy_elapsed = 11233.4f;
            operation = new ImageFileDatabase.Operation(file_id2, "RANDOM_OPERATION3", 0, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            dummy_elapsed = 11234.1f;
            operation = new ImageFileDatabase.Operation(file_id2, "usdf_fits_copy", 2, dummy_elapsed, false, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            PreparedStatement stmt2 = ifdb.getConnection().prepareStatement("select * from ccs_image_file where file_id = ?");
            stmt2.setInt(1, file_id2);
            ResultSet rs2 = stmt1.executeQuery();
            rs2.next();
            missingUSDFFiles = ifdb.missingFailedUSDFFileNames(rs2.getString("dayobs"), 10);
            System.out.println(missingUSDFFiles.toString());
            Assert.assertEquals((Object)"TEST_FILE_USDF_FAILED", (Object)((ImageFileDatabase.MissingFile)missingUSDFFiles.get(0)).file());
            in = new ImageName("MC_C_20190610_001322");
            location = new SensorLocation(1, 2, 1);
            int file_id3 = ifdb.insertFile(in, location, "TYPE2", "TEST_FILE_USDF_MISSING");
            dummy_elapsed = 11235.3f;
            operation = new ImageFileDatabase.Operation(file_id3, "RANDOM_OPERATION4", 0, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            dummy_elapsed = 11233.6f;
            operation = new ImageFileDatabase.Operation(file_id3, "RANDOM_OPERATION5", 0, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            PreparedStatement stmt3 = ifdb.getConnection().prepareStatement("select * from ccs_image_file where file_id = ?");
            stmt3.setInt(1, file_id3);
            ResultSet rs3 = stmt1.executeQuery();
            rs3.next();
            missingUSDFFiles = ifdb.missingFailedUSDFFileNames(rs3.getString("dayobs"), 10);
            System.out.println(missingUSDFFiles.toString());
            Assert.assertEquals((Object)"TEST_FILE_USDF_MISSING", (Object)((ImageFileDatabase.MissingFile)missingUSDFFiles.get(1)).file());
            Assert.assertEquals((Object)"TEST_FILE_USDF_FAILED", (Object)((ImageFileDatabase.MissingFile)missingUSDFFiles.get(0)).file());
        }
    }

    @Test
    public void updateMissingUSDFTest() throws SQLException {
        ImageDatabaseService idbs = ImageDatabaseService.testInstance((String)MissingOperationsTest.createConnection());
        try (ImageFileDatabase ifdb = new ImageFileDatabase(idbs);){
            ImageName in = new ImageName("MC_C_20190610_001319");
            SensorLocation location = new SensorLocation(2, 2, 2);
            int file_id1 = ifdb.insertFile(in, location, "TYPE1", "TEST_FILE1");
            float dummy_elapsed = 11232.1f;
            ImageFileDatabase.Operation operation = new ImageFileDatabase.Operation(file_id1, "usdf_fits_copy", 0, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            dummy_elapsed = 11233.2f;
            operation = new ImageFileDatabase.Operation(file_id1, "OPERATION1_FILE1", 0, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            in = new ImageName("MC_C_20190610_001311");
            location = new SensorLocation(1, 2, 1);
            int file_id2 = ifdb.insertFile(in, location, "TYPE2", "TEST_FILE2");
            dummy_elapsed = 11233.3f;
            operation = new ImageFileDatabase.Operation(file_id2, "OPERATION1_FILE2", 0, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            dummy_elapsed = 11234.1f;
            operation = new ImageFileDatabase.Operation(file_id2, "usdf_fits_copy", 2, dummy_elapsed, false, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            in = new ImageName("MC_C_20190610_001342");
            location = new SensorLocation(1, 2, 1);
            int file_id3 = ifdb.insertFile(in, location, "TYPE3", "TEST_FILE3");
            dummy_elapsed = 11233.3f;
            operation = new ImageFileDatabase.Operation(file_id3, "OPERATION1_FILE3", 0, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), false);
            PreparedStatement stmt1 = ifdb.getConnection().prepareStatement("select * from ccs_image_file");
            ResultSet rs1 = stmt1.executeQuery();
            rs1.next();
            List missingUSDFFiles = ifdb.missingFailedUSDFFileNames(rs1.getString("dayobs"), 10);
            String missingContent = missingUSDFFiles.toString();
            Assert.assertTrue((boolean)missingContent.contains("TEST_FILE3"));
            Assert.assertTrue((boolean)missingContent.contains("TEST_FILE2"));
            operation = new ImageFileDatabase.Operation(file_id2, "usdf_fits_copy", 0, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), true);
            operation = new ImageFileDatabase.Operation(file_id3, "usdf_fits_copy", 0, dummy_elapsed, true, "NONE");
            ifdb.insertFileOperations(Collections.singletonList(operation), true);
            PreparedStatement stmt2 = ifdb.getConnection().prepareStatement("select * from ccs_image_file");
            ResultSet rs2 = stmt2.executeQuery();
            rs2.next();
            missingUSDFFiles = ifdb.missingFailedUSDFFileNames(rs2.getString("dayobs"), 10);
            Assert.assertTrue((boolean)missingUSDFFiles.isEmpty());
        }
    }
}

