/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.guider.Config;
import org.lsst.ccs.daq.guider.GuiderListener;
import org.lsst.ccs.daq.guider.ROICommon;
import org.lsst.ccs.daq.guider.ROILocation;
import org.lsst.ccs.daq.guider.Series;
import org.lsst.ccs.daq.guider.SeriesMetaData;
import org.lsst.ccs.daq.guider.StateMetaData;
import org.lsst.ccs.daq.guider.Status;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.utilities.location.SensorLocation;

public class Guider {
    private final Store store;
    private final long guider;

    public Guider(Store store, long guider) {
        this.store = store;
        this.guider = guider;
    }

    public Status start(ROICommon common, String id, List<ROILocation> locations) throws DAQException {
        int nLocs = locations.size();
        int[] roiData = new int[nLocs * 5];
        for (int i = 0; i < nLocs; ++i) {
            int j = i * 5;
            ROILocation location = locations.get(i);
            SensorLocation sensorLocation = location.getLocation();
            roiData[j] = sensorLocation.getRebLocation().index();
            roiData[j + 1] = sensorLocation.getSensor();
            roiData[j + 2] = location.getSegment();
            roiData[j + 3] = location.getStartRow();
            roiData[j + 4] = location.getStartCol();
        }
        return this.store.startGuider(this.guider, common.getRows(), common.getCols(), common.getIntegrationTimeMillis(), id, roiData);
    }

    public void validate(ROICommon common, List<ROILocation> locations) throws DAQException {
        int nLocs = locations.size();
        int[] roiData = new int[nLocs * 5];
        for (int i = 0; i < nLocs; ++i) {
            int j = i * 5;
            ROILocation location = locations.get(i);
            SensorLocation sensorLocation = location.getLocation();
            roiData[j] = sensorLocation.getRebLocation().index();
            roiData[j + 1] = sensorLocation.getSensor();
            roiData[j + 2] = location.getSegment();
            roiData[j + 3] = location.getStartRow();
            roiData[j + 4] = location.getStartCol();
        }
        this.store.validateGuider(this.guider, common.getRows(), common.getCols(), common.getIntegrationTimeMillis(), roiData);
    }

    public Subscriber subscribe(Set<SensorLocation> locations, ByteOrder byteOrder, GuiderListener listener) throws DAQException {
        return new Subscriber(this.store, locations, byteOrder, listener);
    }

    public Status stop() throws DAQException {
        return this.store.stopGuider(this.guider);
    }

    public Status pause() throws DAQException {
        return this.store.pauseGuider(this.guider);
    }

    public Status resume() throws DAQException {
        return this.store.resumeGuider(this.guider);
    }

    public Status sleep() throws DAQException {
        return this.store.sleepGuider(this.guider);
    }

    public Status wake() throws DAQException {
        return this.store.wakeGuider(this.guider);
    }

    public Config config() throws DAQException {
        return this.store.guiderConfig(this.guider);
    }

    public Series series() throws DAQException {
        return this.store.guiderSeries(this.guider);
    }

    void detach() throws DAQException {
        this.store.detachGuider(this.guider);
    }

    public String getPartition() {
        return this.store.getPartition();
    }

    public LocationSet getConfiguredLocations() throws DAQException {
        return this.store.getConfiguredLocations();
    }

    public static class Subscriber
    implements AutoCloseable {
        private static final Logger LOG = Logger.getLogger(Subscriber.class.getName());
        private volatile long subscriber;
        private volatile Thread waitThread;
        private final Store store;
        private final GuiderListener listener;

        private Subscriber(Store store, Set<SensorLocation> locations, ByteOrder byteOrder, GuiderListener listener) throws DAQException {
            this.store = store;
            this.listener = listener;
            boolean bigEndian = byteOrder == ByteOrder.BIG_ENDIAN;
            int[] locs = new int[locations.size() * 2];
            int index = 0;
            for (SensorLocation sl : locations) {
                locs[index++] = sl.getRebLocation().index();
                locs[index++] = sl.getSensor();
            }
            this.subscriber = store.attachGuiderSubscriber(store.getPartition(), bigEndian, locs);
        }

        public void waitForGuider() throws DAQException {
            long sub = this.subscriber;
            if (sub == 0L) {
                throw new DAQException("Subscriber already closed");
            }
            this.waitThread = Thread.currentThread();
            this.store.waitForGuider(sub, this);
        }

        private void startCallback(StateMetaData state, SeriesMetaData series) {
            LOG.log(Level.INFO, "start {0} {1}", new Object[]{state, series});
            try {
                this.listener.start(state, series);
            }
            catch (Exception x) {
                LOG.log(Level.WARNING, "start callback failed", x);
            }
        }

        void stopCallback(StateMetaData state) {
            LOG.log(Level.INFO, "stop {0}", state);
            try {
                this.listener.stop(state);
            }
            catch (Exception x) {
                LOG.log(Level.WARNING, "stop callback failed", x);
            }
        }

        void pauseCallback(StateMetaData state) {
            LOG.log(Level.INFO, "pause {0}", state);
            try {
                this.listener.pause(state);
            }
            catch (Exception x) {
                LOG.log(Level.WARNING, "pause callback failed", x);
            }
        }

        void resumeCallback(StateMetaData state) {
            LOG.log(Level.INFO, "resume {0}", state);
            try {
                this.listener.resume(state);
            }
            catch (Exception x) {
                LOG.log(Level.WARNING, "resume callback failed", x);
            }
        }

        void rawStampCallback(StateMetaData state, ByteBuffer rawStamp) {
            LOG.log(Level.INFO, "rawStamp {0} {1}", new Object[]{state, rawStamp.remaining()});
            try {
                this.listener.rawStamp(state, rawStamp);
            }
            catch (Exception x) {
                LOG.log(Level.WARNING, "rawStamp callback failed", x);
            }
        }

        void stampCallback(StateMetaData state, ByteBuffer stamp) {
            LOG.log(Level.INFO, "stamp {0} {1}", new Object[]{state, stamp.remaining()});
            try {
                this.listener.stamp(state, stamp);
            }
            catch (Exception x) {
                LOG.log(Level.WARNING, "stamp callback failed", x);
            }
        }

        public String getPartition() {
            return this.store.getPartition();
        }

        @Override
        public void close() throws DAQException {
            long sub = this.subscriber;
            if (sub != 0L) {
                this.subscriber = 0L;
                this.store.abortWaitForGuider(sub);
                try {
                    this.waitThread.join();
                }
                catch (InterruptedException ex) {
                    throw new DAQException("Unexpected interrupt");
                }
                this.store.detachGuiderSubscriber(sub);
            }
        }
    }
}

