/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.location;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Location
implements Comparable<Location>,
Serializable {
    private static final long serialVersionUID = 9188620871451731827L;
    private static final int BAY_MULTIPLIER = 4;
    private static final int INVALID_INDEX = -1;
    private static final int[] BAY_TO_INDEX = new int[]{0, 1, 2, 3, 4, -1, -1, -1, -1, -1, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, -1, -1, -1, -1, -1, 15, 16, 17, 18, 19, -1, -1, -1, -1, -1, 20, 21, 22, 23, 24, -1, -1, -1, -1, -1};
    private static final int[] INDEX_TO_BAY = new int[]{0, 1, 2, 3, 4, 10, 11, 12, 13, 14, 20, 21, 22, 23, 24, 30, 31, 32, 33, 34, 40, 41, 42, 43, 44};
    private static final Pattern PATTERN = Pattern.compile("R(\\d\\d)/Reb(.)");
    private final byte bay;
    private final byte board;

    public Location(int index) {
        this.bay = (byte)INDEX_TO_BAY[index / 4];
        this.board = (byte)(index % 4);
    }

    public Location(int bay, int board) {
        if (bay < 0 || bay >= BAY_TO_INDEX.length || BAY_TO_INDEX[bay] == -1) {
            throw new IllegalArgumentException("Invalid bay: " + bay);
        }
        if (board < 0 || board > 2) {
            throw new IllegalArgumentException("Invalid board: " + board);
        }
        this.bay = (byte)bay;
        this.board = (byte)board;
    }

    public static Location of(String location) {
        int board;
        String boardName;
        Matcher matcher = PATTERN.matcher(location);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Illegal location: " + location);
        }
        int bay = Integer.parseInt(matcher.group(1));
        switch (boardName = matcher.group(2)) {
            case "W": {
                board = 0;
                break;
            }
            case "G": {
                board = 1;
                break;
            }
            default: {
                board = Integer.parseInt(boardName);
            }
        }
        return new Location(bay, board);
    }

    public LocationType type() {
        if (this.bay == 0 || this.bay == 40 || this.bay == 44 || this.bay == 4) {
            if (this.board == 0) {
                return LocationType.WAVEFRONT;
            }
            return LocationType.GUIDER;
        }
        return LocationType.SCIENCE;
    }

    public int index() {
        return 4 * BAY_TO_INDEX[this.bay] + this.board;
    }

    public byte getBay() {
        return this.bay;
    }

    public byte getBoard() {
        return this.board;
    }

    public String toString() {
        return String.format("%s/%s", this.getRaftName(), this.getBoardName());
    }

    public String getRaftName() {
        return String.format("R%02d", this.bay);
    }

    public String getBoardName() {
        return this.type().getBoardName(this.board);
    }

    public String getSensorName(int index) {
        return this.type().getSensorName(this.board, index);
    }

    @Override
    public int compareTo(Location o) {
        return this.index() - o.index();
    }

    public int hashCode() {
        return this.index();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.index() == ((Location)obj).index();
    }

    public static enum LocationType {
        WAVEFRONT(1),
        GUIDER(2),
        SCIENCE(3);

        private final int CCDCount;

        private LocationType(int CCDCount) {
            this.CCDCount = CCDCount;
        }

        public int getCCDCount() {
            return this.CCDCount;
        }

        String getBoardName(int board) {
            switch (this) {
                case SCIENCE: {
                    return String.format("Reb%d", board);
                }
                case WAVEFRONT: {
                    return String.format("RebW", new Object[0]);
                }
                case GUIDER: {
                    return String.format("RebG", new Object[0]);
                }
            }
            throw new RuntimeException("Unknown source type: " + (Object)((Object)this));
        }

        String getSensorName(int board, int sensor) {
            switch (this) {
                case SCIENCE: {
                    return String.format("S%d%d", board, sensor);
                }
                case WAVEFRONT: {
                    return String.format("SW%d", sensor);
                }
                case GUIDER: {
                    return String.format("SG%d", sensor);
                }
            }
            throw new RuntimeException("Unknown source type: " + (Object)((Object)this));
        }
    }
}

