/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.hdu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.header.Compression;
import nom.tam.fits.header.Standard;
import nom.tam.image.compression.bintable.BinaryTableTile;
import nom.tam.image.compression.bintable.BinaryTableTileCompressor;
import nom.tam.image.compression.bintable.BinaryTableTileDecompressor;
import nom.tam.image.compression.bintable.BinaryTableTileDescription;
import nom.tam.util.ColumnTable;

public class CompressedTableData
extends BinaryTable {
    private int rowsPerTile;
    private List<BinaryTableTile> tiles;
    private String[] columnCompressionAlgorithms;

    public CompressedTableData() {
    }

    public CompressedTableData(Header header) throws FitsException {
        super(header);
    }

    public void compress(Header header) throws FitsException {
        for (BinaryTableTile binaryTableTile : this.tiles) {
            binaryTableTile.execute(FitsFactory.threadPool());
        }
        for (BinaryTableTile binaryTableTile : this.tiles) {
            binaryTableTile.waitForResult();
            binaryTableTile.fillHeader(header);
        }
        this.fillHeader(header);
    }

    @Override
    public void fillHeader(Header h) throws FitsException {
        super.fillHeader(h);
        h.setNaxis(2, ((ColumnTable)this.getData()).getNRows());
        h.addValue(Compression.ZTABLE.key(), true, "this is a compressed table");
        long ztilelenValue = this.rowsPerTile > 0 ? (long)this.rowsPerTile : (long)h.getIntValue(Standard.NAXIS2);
        h.addValue(Compression.ZTILELEN.key(), ztilelenValue, "number of rows in each tile");
    }

    public void prepareUncompressedData(ColumnTable<BinaryTable.SaveState> data) throws FitsException {
        int nrows = data.getNRows();
        int ncols = data.getNCols();
        if (this.rowsPerTile <= 0) {
            this.rowsPerTile = nrows;
        }
        if (this.columnCompressionAlgorithms.length < ncols) {
            this.columnCompressionAlgorithms = Arrays.copyOfRange(this.columnCompressionAlgorithms, 0, ncols);
        }
        this.tiles = new ArrayList<BinaryTableTile>();
        for (int column = 0; column < ncols; ++column) {
            this.addByteVaryingColumn();
            int tileIndex = 1;
            for (int rowStart = 0; rowStart < nrows; rowStart += this.rowsPerTile) {
                this.addRow((Object[])new byte[ncols][0]);
                this.tiles.add(new BinaryTableTileCompressor(this, data, BinaryTableTileDescription.tile().rowStart(rowStart).rowEnd(rowStart + this.rowsPerTile).column(column).tileIndex(tileIndex++).compressionAlgorithm(this.columnCompressionAlgorithms[column])));
            }
        }
    }

    protected BinaryTable asBinaryTable(BinaryTable dataToFill, Header compressedHeader, Header targetHeader) throws FitsException {
        int nrows = targetHeader.getIntValue(Standard.NAXIS2);
        int ncols = compressedHeader.getIntValue(Standard.TFIELDS);
        this.rowsPerTile = compressedHeader.getIntValue(Compression.ZTILELEN, nrows);
        this.tiles = new ArrayList<BinaryTableTile>();
        BinaryTable.createColumnDataFor(dataToFill);
        for (int column = 0; column < ncols; ++column) {
            int tileIndex = 1;
            String compressionAlgorithm = compressedHeader.getStringValue(Compression.ZCTYPn.n(column + 1));
            for (int rowStart = 0; rowStart < nrows; rowStart += this.rowsPerTile) {
                BinaryTableTileDecompressor binaryTableTile = new BinaryTableTileDecompressor(this, (ColumnTable<?>)dataToFill.getData(), BinaryTableTileDescription.tile().rowStart(rowStart).rowEnd(rowStart + this.rowsPerTile).column(column).tileIndex(tileIndex++).compressionAlgorithm(compressionAlgorithm));
                this.tiles.add(binaryTableTile);
                binaryTableTile.execute(FitsFactory.threadPool());
            }
        }
        for (BinaryTableTile binaryTableTile : this.tiles) {
            binaryTableTile.waitForResult();
        }
        return dataToFill;
    }

    protected int getRowsPerTile() {
        return this.rowsPerTile;
    }

    protected void setColumnCompressionAlgorithms(String[] columnCompressionAlgorithms) {
        this.columnCompressionAlgorithms = columnCompressionAlgorithms;
    }

    protected CompressedTableData setRowsPerTile(int value) {
        this.rowsPerTile = value;
        return this;
    }
}

