/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageListener;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.imagehandling.ImageEventSender;
import org.lsst.ccs.subsystem.imagehandling.ImageHandler;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.RebNode;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.data.ImageReceivedEvent;

public class ImageHandlingClient
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(ImageHandlingClient.class.getName());
    private final ExecutorService executor = Executors.newCachedThreadPool();
    @LookupPath
    private String path;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageHandlingConfig imageHandlingConfig;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private List<RebNode> rebs = new ArrayList<RebNode>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;

    public void build() {
    }

    public void start() {
        LOG.log(Level.FINE, "Starting ImageHandling client {0})", this.path);
    }

    public void postStart() {
        try {
            Store store = new Store(this.imageHandlingConfig.getDaqPartition());
            store.addImageListener(new ImageListener(){

                public void imageCreated(Image image) {
                }

                public void imageComplete(Image image) {
                    KeyValueData kvd = new KeyValueData("imageReceivedEvent", (Serializable)new ImageReceivedEvent(image.getMetaData()));
                    ImageHandlingClient.this.agent.publishSubsystemDataOnStatusBus(kvd);
                    String daqFolder = ImageHandlingClient.this.imageHandlingConfig.getDaqFolder();
                    if (daqFolder != null && !"".equals(daqFolder) && !ImageHandlingClient.this.imageHandlingConfig.getDaqFolder().equals(image.getMetaData().getCreationFolderName())) {
                        return;
                    }
                    Future<FileList> future = ImageHandlingClient.this.executor.submit(new ImageHandler(image, ImageHandlingClient.this.executor, ImageHandlingClient.this.imageHandlingConfig, ImageHandlingClient.this.rebs));
                    ImageHandlingClient.this.executor.submit(new ImageEventSender(future, ImageHandlingClient.this.agent, ImageHandlingClient.this.imageHandlingConfig.getLocationsToProcess(), image.getMetaData().getName()));
                }
            });
        }
        catch (DAQException x) {
            throw new RuntimeException("Failed to connect to DAQ", x);
        }
    }

    ExecutorService getExecutorService() {
        return this.executor;
    }
}

