package org.lsst.ccs.subsystem.imagehandling;

import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.subsystem.imagehandling.data.FitsFilesWrittenEvent;

/**
 *
 * @author tonyj
 */
public class ImageEventSender implements Runnable {

    private static final Logger LOG = Logger.getLogger(ImageEventSender.class.getName());

    private final Future<FileList> futureFileList;
    private final Agent agent;
    private final String imageName;
    private final LocationSet locations;

    public ImageEventSender(Future<FileList> futureFileList, Agent agent, LocationSet locations, String imageName) {
        this.futureFileList = futureFileList;
        this.agent = agent;
        this.imageName = imageName;
        this.locations = locations;
    }

    @Override
    public void run() {
        FitsFilesWrittenEvent event = null;
        try {
            FileList fileList = futureFileList.get(30, TimeUnit.SECONDS);
            if (fileList == null) {
                LOG.log(Level.WARNING, "Timeout waiting for file list");
            } else {
                LOG.log(Level.INFO, "File list received {0}", fileList);
                event = new FitsFilesWrittenEvent(imageName, fileList, locations);
            }
        } catch (InterruptedException | ExecutionException | TimeoutException ex) {
            LOG.log(Level.SEVERE, "Unexpected exception waiting for file list", ex);
            event = new FitsFilesWrittenEvent(imageName, ex);
        } finally {
            KeyValueData kvd = new KeyValueData(FitsFilesWrittenEvent.EVENT_KEY, event);
            agent.publishSubsystemDataOnStatusBus(kvd);            
        }
    }
}
