import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.daq.utilities.FitsService
import org.lsst.ccs.subsystem.imagehandling.*;
import org.lsst.ccs.utilities.ccd.*;
import java.util.List;


CCSBuilder builder = ["image-handling"]


List rebs = buildPropertyValue("org.lsst.ccs.subsystem.imagehandling.rebs", List.class, null);
FocalPlane focalPlane = FocalPlane.createFocalPlane();

builder.
    "main" (ImageHandlingSubsystem) {
      "imageHandler" (ImageHandlingClient) {
          "ImageHandlingConfig" (ImageHandlingConfig);
      }
    
    for ( String reb : rebs ) {
        Reb r = focalPlane.getReb("$reb");
        "$reb" (RebNode, reb:r) {

            fitsService (FitsService, 
               headerFilesList:["primary","daqv4-primary:primary", "ih-primary:primary", "extended", "ih-reb_cond"],
               reb:r
            )

        }
    }
}
