/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.utilities.location.Location;

class ReadoutConfig {
    private static final Map<Location.LocationType, int[]> DATA_SEGMENT_MAP = new HashMap<Location.LocationType, int[]>();
    private static final Map<Location.LocationType, int[]> DATA_SENSOR_MAP = new HashMap<Location.LocationType, int[]>();
    private static final Map<Location.LocationType, Integer> XOR_MAP = new HashMap<Location.LocationType, Integer>();
    private static final Map<Location.LocationType, String[]> DATA_SEGMENT_NAME_MAP = new HashMap<Location.LocationType, String[]>();
    private final Location.LocationType sourceType;

    ReadoutConfig(Location.LocationType sourceType) {
        this.sourceType = sourceType;
    }

    int[] getDataSegmentMap() {
        return DATA_SEGMENT_MAP.get(this.sourceType);
    }

    int[] getDataSensorMap() {
        return DATA_SENSOR_MAP.get(this.sourceType);
    }

    String[] getDataSegmentNames() {
        return DATA_SEGMENT_NAME_MAP.get(this.sourceType);
    }

    int getXor() {
        return XOR_MAP.get(this.sourceType);
    }

    static {
        DATA_SEGMENT_NAME_MAP.put(Location.LocationType.SCIENCE, new String[]{"Segment10", "Segment11", "Segment12", "Segment13", "Segment14", "Segment15", "Segment16", "Segment17", "Segment07", "Segment06", "Segment05", "Segment04", "Segment03", "Segment02", "Segment01", "Segment00"});
        DATA_SEGMENT_NAME_MAP.put(Location.LocationType.GUIDER, new String[]{"Segment10", "Segment11", "Segment12", "Segment13", "Segment14", "Segment15", "Segment16", "Segment17", "Segment07", "Segment06", "Segment05", "Segment04", "Segment03", "Segment02", "Segment01", "Segment00"});
        DATA_SEGMENT_NAME_MAP.put(Location.LocationType.WAVEFRONT, new String[]{"Segment10", "Segment11", "Segment12", "Segment13", "Segment14", "Segment15", "Segment16", "Segment17"});
        DATA_SEGMENT_MAP.put(Location.LocationType.SCIENCE, new int[]{15, 14, 13, 12, 11, 10, 9, 8, 0, 1, 2, 3, 4, 5, 6, 7});
        DATA_SEGMENT_MAP.put(Location.LocationType.GUIDER, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15});
        DATA_SEGMENT_MAP.put(Location.LocationType.WAVEFRONT, new int[]{0, 1, 2, 3, 4, 5, 6, 7});
        DATA_SENSOR_MAP.put(Location.LocationType.SCIENCE, new int[]{2, 1, 0});
        DATA_SENSOR_MAP.put(Location.LocationType.GUIDER, new int[]{1, 0});
        DATA_SENSOR_MAP.put(Location.LocationType.WAVEFRONT, new int[]{0, 1});
        XOR_MAP.put(Location.LocationType.SCIENCE, 131071);
        XOR_MAP.put(Location.LocationType.GUIDER, 131072);
        XOR_MAP.put(Location.LocationType.WAVEFRONT, 131072);
    }
}

