/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.FitsDate;
import nom.tam.fits.FitsException;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

public class MetaDataSet {
    private static final Logger LOG = Logger.getLogger(MetaDataSet.class.getName());
    private final Map<String, Map<String, Object>> metaDataMaps = new HashMap<String, Map<String, Object>>();

    public void addProperties(String name, Properties props) {
        this.addMetaDataMap(name, this.convertToMetaData(props));
    }

    public void addMetaData(String name, String key, Object value) {
        Map<String, Object> meta = this.findOrCreateMetaData(name);
        meta.put(key, value);
    }

    public void addMetaDataMap(String name, Map<String, Object> data) {
        if (data == null) {
            return;
        }
        Map<String, Object> meta = this.findOrCreateMetaData(name);
        meta.putAll(data);
    }

    public void addMetaDataSet(MetaDataSet metaDataSet) {
        if (metaDataSet == null) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> entry : metaDataSet.metaDataMaps.entrySet()) {
            this.addMetaDataMap(entry.getKey(), entry.getValue());
        }
    }

    public Properties convertToProperties() {
        Properties p = new Properties();
        for (Map.Entry<String, Map<String, Object>> entry : this.metaDataMaps.entrySet()) {
            String mapName = entry.getKey();
            Map<String, Object> map = entry.getValue();
            for (Map.Entry<String, Object> e : map.entrySet()) {
                if (e.getValue() == null) continue;
                if (!mapName.isEmpty()) {
                    p.put(mapName + "." + e.getKey(), e.getValue());
                }
                p.put(e.getKey(), e.getValue());
            }
        }
        return p;
    }

    public Object getValue(String name) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Object obj = null;
        for (Map.Entry<String, Map<String, Object>> metaDataEntry : this.metaDataMaps.entrySet()) {
            Object result = metaDataEntry.getValue().get(name);
            if (result == null) continue;
            results.put(metaDataEntry.getKey(), result);
            obj = result;
        }
        if (results.size() <= 1) {
            return obj;
        }
        throw new RuntimeException("More than one map defines a value for " + name + " (" + results + ")");
    }

    public Object getValue(String map, String name) {
        if (map == null) {
            return this.getValue(name);
        }
        Map<String, Object> metaData = this.metaDataMaps.get(map);
        if (metaData == null) {
            return null;
        }
        return metaData.get(name);
    }

    private Map<String, Object> findOrCreateMetaData(String name) {
        Map<String, Object> result = this.metaDataMaps.get(name);
        if (result == null) {
            result = new HashMap<String, Object>();
            this.metaDataMaps.put(name, result);
        }
        return result;
    }

    private Map<String, Object> convertToMetaData(Properties props) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Object n : BootstrapResourceUtils.getAllKeysInProperties((Properties)props)) {
            String name = (String)n;
            String value = props.getProperty(name);
            if (value == null) {
                LOG.log(Level.WARNING, "NULL value for property {0}", new Object[]{name});
                continue;
            }
            result.put(name, this.convertToMetaData(value));
        }
        return result;
    }

    private Object convertToMetaData(String value) {
        try {
            return Integer.decode(value);
        }
        catch (NumberFormatException x) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException xx) {
                try {
                    return new FitsDate(value).toDate();
                }
                catch (FitsException xxx) {
                    if ("true".equalsIgnoreCase(value)) {
                        return Boolean.TRUE;
                    }
                    if ("false".equalsIgnoreCase(value)) {
                        return Boolean.FALSE;
                    }
                    return value;
                }
            }
        }
    }
}

