/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.wbxml;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.freehep.wbxml.Attributes;
import org.freehep.wbxml.AttributesImpl;
import org.freehep.wbxml.ContentHandler;
import org.freehep.wbxml.DefaultExtensionHandler;
import org.freehep.wbxml.EntityResolver;
import org.freehep.wbxml.ExtensionHandler;
import org.freehep.wbxml.MutableAttributes;
import org.freehep.wbxml.WBXML;
import org.xml.sax.SAXException;

public class WBXMLParser
implements WBXML {
    private DataInputStream in;
    private ContentHandler contentHandler;
    private ExtensionHandler extensionHandler;
    private Map stringTable;
    private int version;
    private int publicIdentifierId;
    private int charSet;
    private int tagPage;
    private int attributePage;
    private Stack stack = new Stack();
    private EntityResolver resolver;

    public WBXMLParser(ContentHandler contentHandler) {
        this(contentHandler, new DefaultExtensionHandler());
    }

    public WBXMLParser(ContentHandler contentHandler, ExtensionHandler extensionHandler) {
        this.contentHandler = contentHandler;
        this.extensionHandler = extensionHandler;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    public int getCharSet() {
        return this.charSet;
    }

    public int getVersion() {
        return this.version;
    }

    public void parse(InputStream in) throws SAXException, IOException {
        int id;
        int sLen;
        this.in = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        char[] entityBuf = new char[1];
        this.tagPage = 0;
        this.attributePage = 0;
        this.version = this.readByte();
        this.publicIdentifierId = this.readInt();
        int dtdIndex = 0;
        if (this.publicIdentifierId == 0) {
            dtdIndex = this.readInt();
        }
        this.charSet = this.readInt();
        this.stringTable = new HashMap();
        int len = this.readInt();
        for (int offset = 0; offset < len; offset += sLen + 2 + 1) {
            String s = this.in.readUTF();
            sLen = WBXMLParser.stringUTFLength(s);
            this.stringTable.put(new Integer(offset), s);
            in.read();
        }
        this.contentHandler.startDocument();
        if (this.publicIdentifierId == 0) {
            String[] dtdPair = ((String)this.stringTable.get(new Integer(dtdIndex))).split(" ", 2);
            if (this.resolver != null) {
                this.resolver.resolveEntity(dtdPair[0], null, dtdPair[1]);
            }
        }
        block10: while ((id = in.read()) != -1) {
            switch (id) {
                case 0: {
                    this.tagPage = this.readByte();
                    continue block10;
                }
                case 1: {
                    this.contentHandler.endElement((Integer)this.stack.pop());
                    continue block10;
                }
                case 2: {
                    entityBuf[0] = (char)this.readInt();
                    this.contentHandler.characters(entityBuf, 0, 1);
                    continue block10;
                }
                case 3: {
                    String s = this.readStrI();
                    this.contentHandler.characters(s.toCharArray(), 0, s.length());
                    continue block10;
                }
                case 64: 
                case 65: 
                case 66: 
                case 128: 
                case 129: 
                case 130: 
                case 192: 
                case 193: 
                case 194: 
                case 195: {
                    int tagID = (Integer)this.stack.peek();
                    this.handleExtensions(id, tagID, -1, null, null);
                    continue block10;
                }
                case 67: {
                    throw new SAXException("PI Not Supported");
                }
                case 131: {
                    String str = this.readStrT();
                    this.contentHandler.characters(str.toCharArray(), 0, str.length());
                    continue block10;
                }
            }
            this.readElement(id);
        }
        if (this.stack.size() != 0) {
            throw new SAXException("unclosed elements: " + this.stack);
        }
        this.contentHandler.endDocument();
    }

    private void handleExtensions(int id, int tagID, int attributeID, MutableAttributes atts, List value) throws SAXException, IOException {
        switch (id) {
            case 64: 
            case 65: 
            case 66: {
                this.extensionHandler.extI(id - 64, this.readStrI(), tagID, attributeID, atts, value);
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                this.extensionHandler.extT(id - 128, this.readInt(), tagID, attributeID, atts, value);
                break;
            }
            case 192: 
            case 193: 
            case 194: {
                this.extensionHandler.ext(id - 192, tagID, attributeID, atts, value);
                break;
            }
            case 195: {
                int len = this.readInt();
                this.extensionHandler.opaque(len, this.in, tagID, attributeID, atts, value);
            }
        }
    }

    private Attributes readAttr(int tagID) throws SAXException, IOException {
        AttributesImpl result = new AttributesImpl();
        int id = this.readByte();
        int attributeID = -1;
        while (id != 1) {
            while (id == 0) {
                this.attributePage = this.readByte();
                id = this.readByte();
            }
            attributeID = this.getAttributeId(id);
            ArrayList<Object> value = new ArrayList<Object>();
            id = this.readByte();
            while (id > 128 || id == 0 || id == 2 || id == 3 || id == 131 || id >= 64 && id <= 66 || id >= 128 && id <= 130) {
                switch (id) {
                    case 0: {
                        this.attributePage = this.readByte();
                        break;
                    }
                    case 2: {
                        value.add(new Character((char)this.readInt()));
                        break;
                    }
                    case 3: {
                        value.add(this.readStrI());
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: {
                        this.handleExtensions(id, tagID, attributeID, result, value);
                        break;
                    }
                    case 131: {
                        value.add(this.readStrT());
                        break;
                    }
                    default: {
                        value.add(new Integer(this.getAttributeId(id)));
                    }
                }
                id = this.readByte();
            }
            switch (value.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    Object o = value.get(0);
                    if (o instanceof Integer) {
                        result.set(attributeID, (Integer)o);
                        break;
                    }
                    if (o instanceof Character) {
                        result.set(attributeID, ((Character)o).charValue());
                        break;
                    }
                    if (o instanceof String) {
                        result.set(attributeID, (String)o);
                        break;
                    }
                    throw new IOException(this.getClass() + ": Type " + o.getClass() + " not properly handled.");
                }
                default: {
                    result.set(attributeID, value);
                }
            }
            attributeID = -1;
        }
        return result;
    }

    private int getTagId(int id) {
        return (id & 0x3F) + this.tagPage * 59 - 5;
    }

    private int getAttributeId(int id) {
        return (id & 0x3F) + this.attributePage * 59 - 5;
    }

    private void readElement(int id) throws IOException, SAXException {
        boolean empty;
        int tagID = this.getTagId(id & 0x3F);
        if ((id & 0x40) != 0) {
            this.stack.add(new Integer(tagID));
            empty = false;
        } else {
            empty = true;
        }
        this.contentHandler.startElement(tagID, (id & 0x80) != 0 ? this.readAttr(tagID) : new AttributesImpl(), empty);
    }

    protected int readByte() throws IOException, SAXException {
        int i = this.in.read();
        if (i == -1) {
            throw new SAXException("Unexpected EOF");
        }
        return i;
    }

    protected int readInt() throws SAXException, IOException {
        int i;
        int result = 0;
        do {
            i = this.readByte();
            result = result << 7 | i & 0x7F;
        } while ((i & 0x80) != 0);
        return result;
    }

    protected String readStrI() throws IOException, SAXException {
        String s = this.in.readUTF();
        this.in.read();
        return s;
    }

    protected String readStrT() throws IOException, SAXException {
        Integer pos = new Integer(this.readInt());
        return (String)this.stringTable.get(pos);
    }

    public static int stringUTFLength(String s) {
        int bytesNeeded = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) < '\u0080') {
                ++bytesNeeded;
                continue;
            }
            if (s.charAt(i) < '\u0800') {
                bytesNeeded += 2;
                continue;
            }
            if (s.charAt(i) < '\u10000') {
                bytesNeeded += 3;
                continue;
            }
            bytesNeeded += 4;
        }
        return bytesNeeded;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: WBXMLParser filename");
            System.exit(1);
        }
        ContentHandler contentHandler = new ContentHandler(){

            @Override
            public void characters(char[] chars, int start, int len) throws SAXException {
                System.err.print("'" + String.valueOf(chars) + "'");
            }

            @Override
            public void endDocument() throws SAXException {
                System.err.println("END DOCUMENT");
            }

            @Override
            public void endElement(int tagID) throws SAXException {
                System.err.println("</" + tagID + ">");
            }

            @Override
            public void startDocument() throws SAXException {
                System.err.println("START DOCUMENT");
            }

            @Override
            public void startElement(int tagID, Attributes attr, boolean empty) throws SAXException {
                System.err.println("<" + tagID);
                System.err.println(attr.getTags().length);
                if (empty) {
                    System.err.print("/");
                }
                System.err.println(">");
            }
        };
        WBXMLParser p = new WBXMLParser(contentHandler);
        p.parse(new FileInputStream(args[0]));
    }
}

