/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;

public class RouteSelectionCommandSet
extends CompositeCommandSet {
    private String selectedRoute = "";
    private final CompositeCommandSet activeRouteCommandSet = new CompositeCommandSet();
    private final Map<String, RoutingCommandSet> paths = new ConcurrentHashMap<String, RoutingCommandSet>();

    public RouteSelectionCommandSet() {
        CommandSetBuilder builder = new CommandSetBuilder();
        BuiltIns builtIns = new BuiltIns();
        CommandSet builtInCommandSet = builder.buildCommandSet(builtIns);
        this.add(builtInCommandSet);
        this.add(this.activeRouteCommandSet);
    }

    public RouteSelectionCommandSet(CompositeCommandSet parentCommandSet) {
        this();
        this.add(parentCommandSet);
    }

    private void updateActiveRoute() {
        this.activeRouteCommandSet.clear();
        if (!"".equals(this.selectedRoute)) {
            Map<String, RoutingCommandSet> routesMap = RouteSelectionCommandSet.getAvailableRoutesMap(this, false);
            for (Map.Entry<String, RoutingCommandSet> entry : routesMap.entrySet()) {
                String routeName = entry.getKey();
                if (routeName.equals(this.selectedRoute)) {
                    CommandSet c = entry.getValue().getRouteCommandSet();
                    this.activeRouteCommandSet.add(c, false);
                    continue;
                }
                if (!routeName.startsWith(this.selectedRoute + "/")) continue;
                String newRoute = routeName.replace(this.selectedRoute + "/", "");
                RoutingCommandSet c = new RoutingCommandSet(this, newRoute, entry.getValue().getPath(), entry.getValue().getRouteCommandSet());
                this.activeRouteCommandSet.add(c, false);
            }
        }
    }

    void setActiveRoute(String value) {
        if ("".equals(value)) {
            this.selectedRoute = "";
        } else {
            String fullRoute;
            Map<String, RoutingCommandSet> rs = RouteSelectionCommandSet.getAvailableRoutesMap(this, false);
            String string = fullRoute = !rs.containsKey(value) && !"".equals(this.selectedRoute) ? this.selectedRoute + "/" + value : value;
            if (!rs.containsKey(fullRoute)) {
                throw new RuntimeException("Error: could not find target \"" + value + "\".");
            }
            this.selectedRoute = fullRoute;
        }
        this.updateActiveRoute();
    }

    public String getActiveRoute() {
        return this.selectedRoute;
    }

    public void addRoutingCommandSet(String route, String path, CommandSet parent) {
        if (this.paths.containsKey(path)) {
            throw new RuntimeException("Error: Route " + path + " already exists");
        }
        RoutingCommandSet crcs = new RoutingCommandSet(this, route, path, parent);
        this.add(crcs, false);
        this.paths.put(path, crcs);
    }

    public void removeRoute(String route) {
        Iterator<Map.Entry<String, RoutingCommandSet>> it = this.paths.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, RoutingCommandSet> e = it.next();
            String routeName = e.getKey();
            if (!routeName.equals(route) && !routeName.startsWith(route + "/")) continue;
            this.remove(e.getValue());
            it.remove();
        }
    }

    public boolean containsPath(String path) {
        return this.paths.containsKey(path);
    }

    public Map<String, RoutingCommandSet> getRoutes() {
        LinkedHashMap<String, RoutingCommandSet> res = new LinkedHashMap<String, RoutingCommandSet>();
        for (Map.Entry<String, RoutingCommandSet> entry : this.paths.entrySet()) {
            res.put(entry.getValue().getRoute(), entry.getValue());
        }
        return res;
    }

    public Map<String, CommandSet> getCommandSetsForRoute(String root) {
        HashMap<String, CommandSet> res = new HashMap<String, CommandSet>();
        for (Map.Entry<String, RoutingCommandSet> entry : this.paths.entrySet()) {
            String path = entry.getKey();
            if (!path.equals(root) && !path.startsWith(root + "/")) continue;
            res.put(path, entry.getValue().getRouteCommandSet());
        }
        return res;
    }

    private static Map<String, RoutingCommandSet> getAvailableRoutesMap(CommandSet cs, boolean filterByLevel) {
        LinkedHashMap<String, RoutingCommandSet> result = new LinkedHashMap<String, RoutingCommandSet>();
        if (cs instanceof RoutingCommandSet) {
            RoutingCommandSet rcs = (RoutingCommandSet)cs;
            String fullRoute = rcs.getRoute();
            DictionaryCommand dc = ((RoutingCommandSet.RoutingDictionary)rcs.getCommandDictionary()).getRouteCommand(fullRoute);
            if (!filterByLevel || rcs.getCommandDictionary().isDictionaryCommandVisible(dc)) {
                result.put(fullRoute, (RoutingCommandSet)cs);
            }
        } else if (cs instanceof CompositeCommandSet) {
            for (CommandSet s : ((CompositeCommandSet)cs).getCommandSets()) {
                result.putAll(RouteSelectionCommandSet.getAvailableRoutesMap(s, filterByLevel));
            }
        }
        return result;
    }

    public class BuiltIns {
        @Command(description="Set the default command target", level=0, type=Command.CommandType.QUERY)
        public void set(@Argument(name="item") SetGetTargetCommands what, @Argument(name="value", defaultValue="", allowedValueProvider="getSetAllowedValues") String value) {
            switch (what) {
                case TARGET: {
                    RouteSelectionCommandSet.this.setActiveRoute(value);
                }
            }
        }

        public List<String> getSetAllowedValues() {
            RouteSelectionCommandSet.this.updateActiveRoute();
            Map<String, RoutingCommandSet> availableRouteMaps = RouteSelectionCommandSet.getAvailableRoutesMap(RouteSelectionCommandSet.this, true);
            for (CommandSet cs : RouteSelectionCommandSet.this.activeRouteCommandSet.getCommandSets()) {
                RoutingCommandSet rcs;
                if (!(cs instanceof RoutingCommandSet) || !availableRouteMaps.containsKey(RouteSelectionCommandSet.this.selectedRoute + "/" + (rcs = (RoutingCommandSet)cs).getRoute())) continue;
                availableRouteMaps.put(rcs.getRoute(), rcs);
            }
            return new ArrayList<String>(availableRouteMaps.keySet());
        }

        @Command(description="Get various settings", level=0, type=Command.CommandType.QUERY)
        public String get(@Argument(name="item") SetGetTargetCommands what) {
            switch (what) {
                case TARGET: {
                    return RouteSelectionCommandSet.this.getActiveRoute();
                }
            }
            return null;
        }
    }

    public static enum SetGetTargetCommands {
        TARGET;

    }
}

