/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentLockServiceDelegate;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class AbstractAgentLockServiceDelegate
implements AgentLockServiceDelegate,
AgentPresenceListener {
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.services.lockservice");
    protected AgentLockService svc;
    protected final List<AgentLockService.AgentLevelListener> agentLevelListeners = new CopyOnWriteArrayList<AgentLockService.AgentLevelListener>();
    protected final List<AgentLockService.AgentLockUpdateListener> agentLockUpdateListeners = new CopyOnWriteArrayList<AgentLockService.AgentLockUpdateListener>();
    protected final Map<String, Integer> agentLevels = new HashMap<String, Integer>();
    protected final Map<String, AgentLock> heldLocks = new HashMap<String, AgentLock>();
    protected final Object lockLevelUpdate = new Object();
    protected final Semaphore levelListenersSemaphore = new Semaphore(1, true);
    protected final Semaphore lockListenersSemaphore = new Semaphore(1, true);

    protected Agent getAgent() {
        return this.svc.getAgent();
    }

    protected AgentStateService getAgentStateService() {
        return this.svc.getAgentStateService();
    }

    public AbstractAgentLockServiceDelegate(AgentLockService svc) {
        this.svc = svc;
    }

    @Override
    public void preInit() {
        log.debug((Object)("AbstractAgentLockServiceDelegate preInit for " + this));
        this.getAgent().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLevelForAgent(String agentName) {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            if (this.heldLocks.get(agentName) == null) {
                return 0;
            }
            return this.agentLevels.getOrDefault(agentName, 0);
        }
    }

    @Override
    public AgentLock getLockForAgent(String agentName) {
        return this.getHeldLocks().get(agentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, AgentLock> getHeldLocks() {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            return Collections.unmodifiableMap(this.heldLocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAgentLevelListener(AgentLockService.AgentLevelListener alListener) {
        HashMap<String, Integer> agentLevelsCopy = null;
        Iterator iterator = this.lockLevelUpdate;
        synchronized (iterator) {
            agentLevelsCopy = new HashMap<String, Integer>(this.agentLevels);
        }
        try {
            this.levelListenersSemaphore.acquireUninterruptibly();
            for (Map.Entry entry : agentLevelsCopy.entrySet()) {
                alListener.onAgentLevelChange((String)entry.getKey(), (Integer)entry.getValue());
            }
            this.agentLevelListeners.add(alListener);
        }
        finally {
            this.levelListenersSemaphore.release();
        }
    }

    @Override
    public void removeAgentLevelListener(AgentLockService.AgentLevelListener alListener) {
        this.agentLevelListeners.remove(alListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAgentLockUpdateListener(AgentLockService.AgentLockUpdateListener aluListener) {
        HashMap<String, AgentLock> heldLocksCopy = null;
        Iterator iterator = this.lockLevelUpdate;
        synchronized (iterator) {
            heldLocksCopy = new HashMap<String, AgentLock>(this.heldLocks);
        }
        try {
            this.lockListenersSemaphore.acquireUninterruptibly();
            for (Map.Entry entry : heldLocksCopy.entrySet()) {
                aluListener.onAgentLockUpdate((String)entry.getKey(), (AgentLock)entry.getValue());
            }
            this.agentLockUpdateListeners.add(aluListener);
        }
        finally {
            this.lockListenersSemaphore.release();
        }
    }

    @Override
    public void removeAgentLockUpdateListener(AgentLockService.AgentLockUpdateListener aluListener) {
        this.agentLockUpdateListeners.remove(aluListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLockInternal(String agentName, AgentLock lock) throws UnauthorizedLockException, IOException {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            if (lock != null) {
                this.heldLocks.put(agentName, lock);
            } else {
                this.heldLocks.remove(agentName);
            }
        }
        this.notifyLockListeners(agentName, lock);
    }

    protected void notifyLockListeners(String agentName, AgentLock lock) {
        this.lockListenersSemaphore.acquireUninterruptibly();
        Thread t = new Thread(() -> {
            try {
                this.agentLockUpdateListeners.forEach(l -> l.onAgentLockUpdate(agentName, lock));
            }
            finally {
                this.lockListenersSemaphore.release();
            }
        });
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLevelInternal(String agentName, int level) throws UnauthorizedLevelException, IOException {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            log.fine((Object)(this.getAgent().getName() + " set a level for agent " + agentName + " to " + level));
            this.agentLevels.put(agentName, level);
        }
        this.notifyLevelListeners(agentName, level);
    }

    protected void notifyLevelListeners(String agentName, int level) {
        this.levelListenersSemaphore.acquireUninterruptibly();
        Thread t = new Thread(() -> {
            try {
                this.agentLevelListeners.forEach(l -> l.onAgentLevelChange(agentName, level));
            }
            finally {
                this.levelListenersSemaphore.release();
            }
        });
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(AgentInfo ... agents) {
        for (AgentInfo ai : agents) {
            if (ai.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) != 0) {
                return;
            }
            String name = ai.getName();
            AgentLock initialLock = null;
            int initialLevel = 0;
            Object object = this.lockLevelUpdate;
            synchronized (object) {
                initialLock = this.heldLocks.getOrDefault(name, null);
            }
            if (initialLock != null) {
                object = this.lockLevelUpdate;
                synchronized (object) {
                    initialLevel = this.agentLevels.getOrDefault(name, initialLock.getMaxLevel());
                }
            }
            try {
                this.setLevelInternal(name, initialLevel);
                this.setLockInternal(name, initialLock);
            }
            catch (IOException | UnauthorizedLevelException | UnauthorizedLockException ex) {
                log.warning((Object)"Problems trying to re-lock a connecting subsystem.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getLockableAgents() {
        ArrayList<String> result = new ArrayList<String>();
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            for (AgentInfo a : this.getAgent().getMessagingAccess().getAgentPresenceManager().listConnectedAgents()) {
                if (!a.getType().equals((Object)AgentInfo.AgentType.WORKER) || this.heldLocks.get(a.getName()) != null) continue;
                result.add(a.getName());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getLockedAgents() {
        ArrayList<String> res = new ArrayList<String>();
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            for (Map.Entry<String, AgentLock> e : this.heldLocks.entrySet()) {
                if (e.getValue() == null) continue;
                res.add(e.getKey());
            }
        }
        return res;
    }

    @Override
    public List<String> getAllWorkerAgents() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getLockableAgents());
        result.addAll(this.getLockedAgents());
        return result;
    }
}

