/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.DataProviderDictionaryService;

public class DictionaryWriter {
    private String description;
    private boolean verbose;

    public DictionaryWriter(String[] args) {
        this.parseArgsCLI(args);
    }

    public static void main(String[] args) throws Exception {
        DictionaryWriter exec = new DictionaryWriter(args);
        Subsystem subsystem = BootUtils.getSubsystemFromFile(exec.description);
        AgentCommandDictionaryService commandDictionary = subsystem.getAgentService(AgentCommandDictionaryService.class);
        DataProviderDictionaryService dataProviderDictionary = subsystem.getAgentService(DataProviderDictionaryService.class);
        ConfigurationService configurationService = subsystem.getAgentService(ConfigurationService.class);
        DictionaryWriter.writeObjectToFile(commandDictionary.getAgentCommandDictionary(), exec.description + "_commandDictionary.ser");
        DictionaryWriter.writeObjectToFile(dataProviderDictionary.getDataProviderDictionary(), exec.description + "_dataDictionary.ser");
        DictionaryWriter.writeObjectToFile(configurationService.getConfigurationInfo(), exec.description + "_configurationDictionary.ser");
        System.exit(0);
    }

    public static void writeObjectToFile(Object serObj, String fileName) {
        try {
            FileOutputStream fileOut = new FileOutputStream(fileName);
            try (ObjectOutputStream objectOut = new ObjectOutputStream(fileOut);){
                objectOut.writeObject(serObj);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private void parseArgsCLI(String[] args) {
        Options commandLineOptions = new Options();
        commandLineOptions.addOption("h", "help", false, "Print the help message");
        commandLineOptions.addOption("v", "verbose", false, "Turns on verbose statements");
        commandLineOptions.addOption("d", "description", true, "Name of Subsystem description file.");
        commandLineOptions.getOption("description").setArgName("DESCRIPTION_FILE");
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(commandLineOptions, args, false);
            if (line.hasOption("help")) {
                DictionaryWriter.usageCLI(commandLineOptions);
            } else {
                this.description = line.getOptionValue("description");
                if (this.description == null) {
                    DictionaryWriter.usageCLI(commandLineOptions);
                }
            }
        }
        catch (Exception e) {
            DictionaryWriter.usageCLI(commandLineOptions);
        }
    }

    static void usageCLI(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "WriteDictionary", "", options, "", true);
        System.exit(0);
    }
}

