/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMEmitter;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.DOMSender;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMObjectModel
implements ExternalObjectModel,
Serializable {
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$net$sf$saxon$dom$NodeOverNodeInfo;
    static /* synthetic */ Class class$org$w3c$dom$NodeList;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$HashSet;

    public boolean isRecognizedNode(Object object) {
        return object instanceof Node && !(object instanceof NodeOverNodeInfo);
    }

    public boolean isRecognizedNodeClass(Class clazz) {
        return (class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = DOMObjectModel.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node).isAssignableFrom(clazz) && !(class$net$sf$saxon$dom$NodeOverNodeInfo == null ? (class$net$sf$saxon$dom$NodeOverNodeInfo = DOMObjectModel.class$("net.sf.saxon.dom.NodeOverNodeInfo")) : class$net$sf$saxon$dom$NodeOverNodeInfo).isAssignableFrom(clazz);
    }

    public boolean isRecognizedNodeListClass(Class clazz) {
        return (class$org$w3c$dom$NodeList == null ? (class$org$w3c$dom$NodeList = DOMObjectModel.class$("org.w3c.dom.NodeList")) : class$org$w3c$dom$NodeList).isAssignableFrom(clazz);
    }

    public Receiver getDocumentBuilder(Result result) throws XPathException {
        if (result instanceof DOMResult) {
            DOMEmitter dOMEmitter = new DOMEmitter();
            Node node = ((DOMResult)result).getNode();
            if (node == null) {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.newDocument();
                    ((DOMResult)result).setNode(document);
                    dOMEmitter.setNode(document);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new DynamicError((Throwable)parserConfigurationException);
                }
            } else {
                dOMEmitter.setNode(node);
            }
            return dOMEmitter;
        }
        return null;
    }

    public boolean sendSource(Source source, Receiver receiver, PipelineConfiguration pipelineConfiguration) throws XPathException {
        if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            DOMSender dOMSender = new DOMSender();
            dOMSender.setStartNode(node);
            dOMSender.setReceiver(receiver);
            dOMSender.setPipelineConfiguration(pipelineConfiguration);
            dOMSender.setSystemId(source.getSystemId());
            dOMSender.send();
            return true;
        }
        return false;
    }

    public NodeInfo unravel(Source source, Configuration configuration) {
        Node node;
        if (source instanceof DOMSource && !((node = ((DOMSource)source).getNode()) instanceof NodeOverNodeInfo)) {
            Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            DocumentWrapper documentWrapper = new DocumentWrapper((Node)document, source.getSystemId(), configuration);
            return documentWrapper.wrap(node);
        }
        return null;
    }

    public Value convertObjectToXPathValue(Object object, Configuration configuration) throws XPathException {
        if (object instanceof NodeList && !(object instanceof Node)) {
            NodeList nodeList = (NodeList)object;
            NodeInfo[] nodeInfoArray = new NodeInfo[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NodeInfo nodeInfo;
                if (nodeList.item(i) instanceof NodeOverNodeInfo) {
                    nodeInfoArray[i] = ((NodeOverNodeInfo)nodeList.item(i)).getUnderlyingNodeInfo();
                    continue;
                }
                DocumentInfo documentInfo = this.wrapDocument(nodeList.item(i), "", configuration);
                nodeInfoArray[i] = nodeInfo = this.wrapNode(documentInfo, nodeList.item(i));
            }
            return new SequenceExtent((Item[])nodeInfoArray);
        }
        return null;
    }

    public Object convertXPathValueToObject(Value value, Class clazz, XPathContext xPathContext) throws XPathException {
        DynamicError dynamicError;
        boolean bl;
        boolean bl2 = (class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = DOMObjectModel.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node).isAssignableFrom(clazz) || clazz == (class$org$w3c$dom$NodeList == null ? (class$org$w3c$dom$NodeList = DOMObjectModel.class$("org.w3c.dom.NodeList")) : class$org$w3c$dom$NodeList) || clazz.isArray() && (class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = DOMObjectModel.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node).isAssignableFrom(clazz.getComponentType());
        boolean bl3 = clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DOMObjectModel.class$("java.lang.Object")) : class$java$lang$Object) || clazz.isAssignableFrom(class$java$util$ArrayList == null ? (class$java$util$ArrayList = DOMObjectModel.class$("java.util.ArrayList")) : class$java$util$ArrayList) || clazz.isAssignableFrom(class$java$util$HashSet == null ? (class$java$util$HashSet = DOMObjectModel.class$("java.util.HashSet")) : class$java$util$HashSet) || clazz.isArray() && clazz.getComponentType() == (class$java$lang$Object == null ? (class$java$lang$Object = DOMObjectModel.class$("java.lang.Object")) : class$java$lang$Object) ? true : (bl = false);
        if (!bl2 && !bl) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(20);
        SequenceIterator sequenceIterator = value.iterate(xPathContext);
        while ((dynamicError = sequenceIterator.next()) != null) {
            Object object;
            if (dynamicError instanceof VirtualNode) {
                object = ((VirtualNode)dynamicError).getUnderlyingNode();
                if (object instanceof Node) {
                    arrayList.add(object);
                    continue;
                }
                if (!bl2) continue;
                DynamicError dynamicError2 = new DynamicError("Extension function required class " + clazz.getName() + "; supplied value of class " + dynamicError.getClass().getName() + " could not be converted");
                throw dynamicError2;
            }
            if (bl2) {
                if (dynamicError instanceof NodeInfo) {
                    arrayList.add(NodeOverNodeInfo.wrap((NodeInfo)dynamicError));
                    continue;
                }
                object = new DynamicError("Extension function required class " + clazz.getName() + "; supplied value of class " + dynamicError.getClass().getName() + " could not be converted");
                throw object;
            }
            return null;
        }
        if (arrayList.size() == 0 && !bl2) {
            return null;
        }
        if ((class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = DOMObjectModel.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node).isAssignableFrom(clazz)) {
            if (arrayList.size() != 1) {
                dynamicError = new DynamicError("Extension function requires a single DOM Node; supplied value contains " + arrayList.size() + " nodes");
                throw dynamicError;
            }
            return arrayList.get(0);
        }
        if (clazz == (class$org$w3c$dom$NodeList == null ? (class$org$w3c$dom$NodeList = DOMObjectModel.class$("org.w3c.dom.NodeList")) : class$org$w3c$dom$NodeList)) {
            return new DOMNodeList(arrayList);
        }
        if (clazz.isArray() && clazz.getComponentType() == (class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = DOMObjectModel.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node)) {
            dynamicError = new Node[arrayList.size()];
            arrayList.toArray((T[])dynamicError);
            return dynamicError;
        }
        if (clazz.isAssignableFrom(class$java$util$ArrayList == null ? (class$java$util$ArrayList = DOMObjectModel.class$("java.util.ArrayList")) : class$java$util$ArrayList)) {
            return arrayList;
        }
        if (clazz.isAssignableFrom(class$java$util$HashSet == null ? (class$java$util$HashSet = DOMObjectModel.class$("java.util.HashSet")) : class$java$util$HashSet)) {
            return new HashSet(arrayList);
        }
        return null;
    }

    public DocumentInfo wrapDocument(Object object, String string, Configuration configuration) {
        if (object instanceof DocumentOverNodeInfo) {
            return (DocumentInfo)((DocumentOverNodeInfo)object).getUnderlyingNodeInfo();
        }
        if (object instanceof NodeOverNodeInfo) {
            return ((NodeOverNodeInfo)object).getUnderlyingNodeInfo().getDocumentRoot();
        }
        if (object instanceof Node) {
            if (((Node)object).getNodeType() == 9) {
                Document document = (Document)object;
                return new DocumentWrapper((Node)document, string, configuration);
            }
            if (((Node)object).getNodeType() == 11) {
                DocumentFragment documentFragment = (DocumentFragment)object;
                return new DocumentWrapper((Node)documentFragment, string, configuration);
            }
            Document document = ((Node)object).getOwnerDocument();
            return new DocumentWrapper((Node)document, string, configuration);
        }
        throw new IllegalArgumentException("Unknown node class " + object.getClass());
    }

    public NodeInfo wrapNode(DocumentInfo documentInfo, Object object) {
        return ((DocumentWrapper)documentInfo).wrap((Node)object);
    }

    public Object convertToNodeList(SequenceExtent sequenceExtent) {
        try {
            DOMNodeList dOMNodeList = DOMNodeList.checkAndMake(sequenceExtent);
            return dOMNodeList;
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

