/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.ConfigurationWriterProvider;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ParameterPath;

public class LocalConfigurationDAO
implements ConfigurationDAO {
    Logger log = Logger.getLogger((String)"org.lsst.ccs.config");
    public static final Comparator<ConfigurationParameterInfo> configurationParameterComparator = new Comparator<ConfigurationParameterInfo>(){

        @Override
        public int compare(ConfigurationParameterInfo o1, ConfigurationParameterInfo o2) {
            String componentName = o1.getComponentName();
            String otherComponentName = o2.getComponentName();
            if (componentName.equals("main") && !otherComponentName.equals("main")) {
                return 1;
            }
            if (otherComponentName.equals("main") && !otherComponentName.equals("main/")) {
                return -1;
            }
            if (componentName.equals(otherComponentName)) {
                return o1.getParameterName().compareTo(o2.getParameterName());
            }
            return componentName.compareTo(otherComponentName);
        }
    };
    private final ConfigurationWriterProvider agentWriterProvider;
    private final ConfigurationWriterProvider descriptionWriterProvider;
    private static final String[][] TABLE = new String[][]{{"java.lang.Integer", "integer (example : 6)"}, {"java.lang.String", "String"}, {"java.lang.Double", "double (example : 3.0)"}, {"java.lang.Float", "float (example : 3.0)"}, {"java.lang.Boolean", "boolean (example : true)"}, {"[I", "array of integers (example : [1,34,666] )"}, {"[D", "array of doubles (example : [1.0,34.0,666.66] )"}, {"[F", "array of floats (example : [1.0,34.0,666.66] )"}, {"[Ljava.lang.String;", "array of Strings (example : ['hello', 'world'] )"}};

    public LocalConfigurationDAO(String agentName, String descriptionName) {
        this.agentWriterProvider = new ConfigurationWriterProvider(agentName);
        this.descriptionWriterProvider = agentName != null && agentName.equals(descriptionName) ? null : new ConfigurationWriterProvider(descriptionName);
        this.log.debug((Object)"instanciated LocalConfigurationDAO");
    }

    public static String toPropertyString(ConfigurationParameterInfo parmInfo) {
        String currentValue = parmInfo.getCurrentValue();
        if (currentValue == null) {
            currentValue = "";
        }
        StringBuilder builder = new StringBuilder();
        String pathName = parmInfo.getPathName();
        String propName = new ParameterPath(parmInfo.getComponentName(), parmInfo.getParameterName()).toString();
        propName = propName == null || "".equals(propName.trim()) ? pathName : propName.trim().replaceAll(" ", "\\\\ ");
        builder.append(propName).append(" = ").append(currentValue);
        return builder.toString();
    }

    private static String getTypeInfo(String typeName) {
        String res = typeName;
        for (String[] keyVal : TABLE) {
            if (!keyVal[0].equals(typeName)) continue;
            return keyVal[1];
        }
        return res;
    }

    @Override
    public ConfigurationView loadConfiguration(String agentName, ConfigurationDescription configDesc) throws ConfigurationServiceException {
        ConfigurationView res = new ConfigurationView(configDesc);
        this.log.debug((Object)("local loadconfig desc tags " + configDesc.getCategoryTags().entrySet()));
        for (Map.Entry<String, String> entry : configDesc.getCategoryTags().entrySet()) {
            String cat = entry.getKey();
            String tag = entry.getValue();
            Properties configProperties = this.getConfigurationProperties(tag, cat);
            for (Map.Entry<Object, Object> prop : configProperties.entrySet()) {
                String name = (String)prop.getKey();
                String val = (String)prop.getValue();
                res.putParameterValue(name, val);
            }
        }
        return res;
    }

    public Properties getConfigurationProperties(String tag, String category) throws ConfigurationServiceException {
        block6: {
            try {
                Properties configProps = this.agentWriterProvider.getConfigurationProperties(tag, category);
                Properties descriptionConfigProps = this.descriptionWriterProvider != null ? this.descriptionWriterProvider.getConfigurationProperties(tag, category) : null;
                this.log.debug((Object)(configProps == null ? "configProps=null" : "configProps " + configProps.toString()));
                this.log.debug((Object)(descriptionConfigProps == null ? "descriptionConfigProps=null" : "descriptionConfigProps " + descriptionConfigProps.toString()));
                this.log.debug((Object)(tag + " cf :" + "" + "/" + "safe" + "."));
                if (configProps == null && descriptionConfigProps == null) {
                    if (!tag.equals("") && !tag.equals("safe")) {
                        throw new IllegalArgumentException("could not find configuration file " + tag + " for category " + (category.isEmpty() ? "default" : category));
                    }
                    break block6;
                }
                Properties mergedProps = new Properties();
                if (descriptionConfigProps != null) {
                    mergedProps.putAll((Map<?, ?>)descriptionConfigProps);
                }
                if (configProps != null) {
                    mergedProps.putAll((Map<?, ?>)configProps);
                }
                return mergedProps;
            }
            catch (IOException ex) {
                throw new ConfigurationServiceException(ex.getMessage(), ex);
            }
        }
        return new Properties();
    }

    @Override
    public ConfigurationView loadGlobalConfiguration(String agentName, String globalName, int version) {
        try {
            String fullConfigName = this.agentWriterProvider.getNamedConfiguration(globalName);
            if (fullConfigName == null) {
                throw new IllegalArgumentException("no such global configuration name : " + globalName);
            }
            ConfigurationDescription configDesc = new ConfigurationDescription();
            configDesc.parseConfigurationString(fullConfigName.split(","));
            configDesc.setName(globalName, -3);
            return this.loadConfiguration(agentName, configDesc);
        }
        catch (IOException ex) {
            throw new ConfigurationServiceException(ex.getMessage(), ex);
        }
    }

    @Override
    public Set<String> findAvailableConfigurationsForCategory(String agentName, String category) {
        HashSet<String> merge = new HashSet<String>();
        merge.addAll(this.agentWriterProvider.findMatchingConfigurations(category));
        if (this.descriptionWriterProvider != null) {
            merge.addAll(this.descriptionWriterProvider.findMatchingConfigurations(category));
        }
        return merge;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public ConfigurationDescription registerConfiguration(String agentName, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        ConfigurationDescription cd = new ConfigurationDescription(configInfo.getCategorySet());
        for (String cat : configInfo.getCategorySet()) {
            String configName = configInfo.getConfigNameForCategory(cat);
            cd.putTagForCategory(cat, configName, configInfo.getConfigVersion(configName));
        }
        return cd;
    }

    @Override
    public ConfigurationDescription saveChangesForCategoriesAs(String agentName, ConfigurationDescription configDesc, ConfigurationInfo configInfo) throws ConfigurationServiceException {
        try {
            if (configDesc.getName() != null) {
                this.agentWriterProvider.setNamedConfiguration(configDesc);
            }
            Map valuesPerCategory = ConfigurationInfo.getParameterInfoGroupByCategory((List)configInfo.getAllParameterInfo());
            for (Map.Entry<String, String> entry : configDesc.getCategoryTags().entrySet()) {
                PrintWriter writer = this.agentWriterProvider.getConfigurationWriter(entry.getValue(), entry.getKey());
                TreeSet<ConfigurationParameterInfo> modifiedParameters = new TreeSet<ConfigurationParameterInfo>(configurationParameterComparator);
                for (ConfigurationParameterInfo cpi : (List)valuesPerCategory.get(entry.getKey())) {
                    if (cpi.isFinal() || cpi.isReadOnly()) continue;
                    modifiedParameters.add(cpi);
                }
                for (ConfigurationParameterInfo parameter : modifiedParameters) {
                    writer.println(LocalConfigurationDAO.toPropertyString(parameter));
                }
                writer.flush();
                writer.close();
            }
        }
        catch (IOException ex) {
            throw new ConfigurationServiceException("could not open file", ex);
        }
        return configDesc;
    }

    public String locateConfigurations(ConfigurationInfo configInfo) {
        StringBuilder sb = new StringBuilder("current existing configurations location :");
        TreeSet categories = new TreeSet(configInfo.getCategorySet());
        for (String cat : categories) {
            String pathDesc;
            String cname = configInfo.getConfigNameForCategory(cat);
            String pathAgent = this.agentWriterProvider.locateConfiguration(cname, cat);
            if (pathAgent != null) {
                sb.append("\n").append("\"").append(cat).append("\":\"").append(cname).append("\" found in : ").append(pathAgent);
            }
            if ((pathDesc = this.descriptionWriterProvider != null ? this.descriptionWriterProvider.locateConfiguration(cname, cat) : null) == null) continue;
            if (pathAgent != null) {
                sb.append("\n\t overrides ").append(pathDesc);
                continue;
            }
            sb.append("\n").append("\"").append(cat).append("\":\"").append(cname).append("\" found in : ").append(pathDesc);
        }
        return sb.toString();
    }
}

