package org.lsst.ccs.subsystem.imagehandling.data;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.imagenaming.ImageName;

/**
 * Event published by the MCM for the main camera containing the measured shutter open time
 *
 * @author tonyj
 */
@SkipEncoding
public class MeasuredShutterTime implements Serializable {

    private final ImageName imageName;
    private final double measuredShutterOpenTime;
    public static final String EVENT_KEY = "CCSMeasuredShutterTime";

    /**
     * Constructor
     *
     * @param imageName associated image name
     * @param measuredShutterOpenTime The measured shutter time
     */
    public MeasuredShutterTime(ImageName imageName, double measuredShutterOpenTime) {

        this.imageName = imageName;
        this.measuredShutterOpenTime = measuredShutterOpenTime;
    }

    public ImageName getImageName() {
        return imageName;
    }

    public double getMeasuredShutterOpenTime() {
        return measuredShutterOpenTime;
    }

    @Override
    public String toString() {
        return "CCSMeasuredShutterOpenTime{" + "imageName=" + this.imageName.toString() + ", measuredShutterOpenTime=" + measuredShutterOpenTime + '}';
    }

}
