package org.lsst.ccs.subsystem.imagehandling.data;

import java.io.Serializable;

/**
 * This message is sent from the ocs-bridge when the enabled state of the 
 * header service changes. The intention is that the image-handler will not
 * wait for the header service if it is known to be disabled.
 * @author tonyj
 */
public class HeaderServiceEnabled implements Serializable {
    public static final String EVENT_KEY = "headerServiceEnabled";
    private final boolean enabled;

    public HeaderServiceEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return enabled;
    }
    
}
