/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.data.ECSVFile;
import org.lsst.ccs.subsystem.imagehandling.data.JsonFile;
import org.lsst.ccs.subsystem.imagehandling.data.TextFile;
import org.lsst.ccs.utilities.location.SensorLocation;

public class AdditionalFileTest {
    @Test
    public void testWriteJsonFile() throws IOException {
        TreeMap<SensorLocation, Mode> activeSensors = new TreeMap<SensorLocation, Mode>();
        activeSensors.put(SensorLocation.of((String)"R00SG0"), Mode.GUIDER);
        activeSensors.put(SensorLocation.of((String)"R22S00"), Mode.SCIENCE);
        activeSensors.put(SensorLocation.of((String)"R22S01"), Mode.SCIENCE);
        activeSensors.put(SensorLocation.of((String)"R22S02"), Mode.SCIENCE);
        Map<String, String> stringified = activeSensors.entrySet().stream().collect(Collectors.toMap(e -> ((SensorLocation)e.getKey()).toString("_"), e -> ((Mode)((Object)((Object)e.getValue()))).toString()));
        ImageName imageName = new ImageName("MC_C_20230515_000001");
        JsonFile jf = new JsonFile("activeSensors.json", "activeSensors", imageName, "activeSensors", stringified);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        jf.writeFile((OutputStream)baos);
        baos.close();
        String result = baos.toString();
        String expectedResult = "{\n  \"fileName\" : \"activeSensors.json\",\n  \"fileType\" : \"activeSensors\",\n  \"obsId\" : \"MC_C_20230515_000001\",\n  \"version\" : 1.0,\n  \"activeSensors\" : {\n    \"R22_S02\" : \"SCIENCE\",\n    \"R00_SG0\" : \"GUIDER\",\n    \"R22_S00\" : \"SCIENCE\",\n    \"R22_S01\" : \"SCIENCE\"\n  }\n}";
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test
    public void testWriteTextFile() throws IOException {
        String textData = "A,B,C\n1,2,3";
        ImageName imageName = new ImageName("MC_C_20230515_000001");
        TextFile textFile = new TextFile(textData, "test.txt", "RandomText", imageName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        textFile.writeFile((OutputStream)baos);
        baos.close();
        String result = baos.toString();
        String expectedResult = "#\n# ObsId: MC_C_20230515_000001\n# FileName: test.txt\n# FileType: RandomText\n# Version: 1.0\n#\nA,B,C\n1,2,3";
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test
    public void testWriteEcsvFile() throws IOException {
        ImageName imageName = new ImageName("MC_C_20230515_000001");
        ArrayList<ECSVFile.Column> columns = new ArrayList<ECSVFile.Column>();
        ECSVFile.Column a = new ECSVFile.Column("a", "%5g", "float64", "Column A");
        ECSVFile.Column b = new ECSVFile.Column("b", "%5g", "float64", "Column B");
        columns.add(a);
        columns.add(b);
        String data = "1,2\n";
        ECSVFile textFile = new ECSVFile(columns, data, "test.txt", "RandomText", imageName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        textFile.writeFile((OutputStream)baos);
        baos.close();
        String result = baos.toString();
        String expectedResult = "# %ECSV 1.0\n# ---\n# datatype:\n# - name: \"a\"\n#   format: \"%5g\"\n#   datatype: \"float64\"\n#   description: \"Column A\"\n#   units: \"unitless\"\n# - name: \"b\"\n#   format: \"%5g\"\n#   datatype: \"float64\"\n#   description: \"Column B\"\n#   units: \"unitless\"\n# delimiter: \",\"\n# meta:\n#   fileName: \"test.txt\"\n#   fileType: \"RandomText\"\n#   obsId: \"MC_C_20230515_000001\"\n#   version: \"1.0\"\na,b\n1,2\n";
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test
    public void testWritePhotodiodeFile() throws IOException, URISyntaxException {
        URL resource = AdditionalFileTest.class.getResource("photodiode.txt");
        String data = Files.lines(Paths.get(resource.toURI())).collect(Collectors.joining("\n"));
        ImageName imageName = new ImageName("MC_C_20230515_000001");
        ArrayList<ECSVFile.Column> columns = new ArrayList<ECSVFile.Column>();
        ECSVFile.Column a = new ECSVFile.Column("TIME", "%7g", "float64", "Measurement time (delta)", "s");
        ECSVFile.Column b = new ECSVFile.Column("CURRENT", "%7g", "float64", "Measured flux", "A");
        columns.add(a);
        columns.add(b);
        ECSVFile ecsvFile = new ECSVFile(columns, data, imageName + "_photodiode.ecsv", "photodiode", imageName);
        ecsvFile.setDelimiter(" ");
        LinkedHashMap<String, String> meta = new LinkedHashMap<String, String>();
        meta.put("CALIBCLS", "lsst.ip.isr.PhotodiodeCalib");
        meta.put("OBSTYPE", "PHOTODIODE");
        ecsvFile.addMetaData(meta);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ecsvFile.writeFile((OutputStream)baos);
        baos.close();
        String result = baos.toString();
        System.out.println(result);
    }

    public static enum Mode {
        GUIDER,
        SCIENCE;

    }
}

