package org.lsst.ccs.subsystem.imagehandling.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bus.annotations.SkipEncoding;

/**
 * A class for header keywords published by focal-plane
 * 
 * @author The LSST CCS Team
 */
@SkipEncoding
public class ImageHeaderKeywords implements Serializable {
    
    private final Map<String,Serializable> keywords = new HashMap<>();
    private final String imageName;
    
    public static final String IMAGE_HEADER_KEYWORDS = "ImageHeaderKeywords";
    
    /**
     * Construct an ImageHeaderKeywords with the Map of the header keywords
     * to be sent.
     * We copy the content of the original Map to avoid the data being cleared.
     * 
     * @param imageName The image name
     * @param keywords  The header keywords for the given image
     * 
     */
    public ImageHeaderKeywords(String imageName, Map<String,Serializable> keywords) {
        this.keywords.putAll(keywords);
        this.imageName = imageName;
    }
    
    /**
     * Get the Map of contained keywords.
     * 
     * @return The Map with the header keywords.
     */
    public Map<String,Serializable> getKeywords() {
        return keywords;
    }
    
    /**
     * Get the name of the image these keywords belong to.
     * 
     * @return 
     */
    public String getImageName() {
        return imageName;
    }

    @Override
    public String toString() {
        return "HeaderKeywords for image "+imageName+": "+keywords;
    }
}
