package org.lsst.ccs.subsystem.imagehandling.data;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.bus.annotations.DoNotTrend;
import org.lsst.ccs.bus.annotations.SkipEncoding;

/**
 * This class is sent by the ocs-bridge when it receives header service events.
 * On receipt the image handler will patch the generated FITS files with the new
 * data. This class is declared here so that we do not need to introduce a circular
 * dependency between ocs-bridge and image-handler.
 *
 * @author tonyj
 */
@SkipEncoding
@DoNotTrend
public class ImageHeaderData implements Serializable {

    public static final String EVENT_KEY = "imageHeaderData";
    private final List<Header> headers;

    public ImageHeaderData(List<Header> headers) {
        this.headers = headers;
    }

    public List<Header> getHeaders() {
        return Collections.unmodifiableList(headers);
    }

    @Override
    public String toString() {
        return "ImageHeaderData{" + headers + '}';
    }

    public static class Header implements Serializable {

        private final String keyword;
        private final Object value;
        private final String comment;
        // Version 1 had value as a String
        private static final long serialVersionUID = 2L;

        public Header(String keyword, Object value, String comment) {
            this.keyword = keyword;
            this.value = value;
            this.comment = comment;
        }

        public String getKeyword() {
            return keyword;
        }

        public Object getValue() {
            return value;
        }

        public String getComment() {
            return comment;
        }

        @Override
        public String toString() {
            return "Header{" + "keyword=" + keyword + ", value=" + value + ", comment=" + comment + '}';
        }
    }
}
