/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import org.lsst.ccs.utilities.image.DateUtils;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class HeaderWriter {
    public static void addMetaDataToHeader(File file, BasicHDU hdu, HeaderSpecification spec, MetaDataSet metaDataSet) throws HeaderCardException, IOException {
        for (HeaderSpecification.GroupLine group : spec.getGroups()) {
            Collection<HeaderSpecification.HeaderLine> headersForGroup = spec.getHeadersForGroup(group.getGroupName());
            if (!headersForGroup.isEmpty() && !group.getGroupName().isEmpty()) {
                for (String comment : group.getComments()) {
                    hdu.getHeader().insertCommentStyle("        ", comment);
                }
            }
            for (HeaderSpecification.HeaderLine header : headersForGroup) {
                Object value = header.getValue(metaDataSet);
                if (header.isRequired() && value == null) {
                    throw new FitsFileWriter.FitsIOException(file, "Could not find value for required header keyword: %s defined as: \n%s", header.getKeyword(), header.getHeaderDefinition());
                }
                try {
                    if (value == null) continue;
                    if (value.equals(HeaderSpecification.NULL)) {
                        hdu.getHeader().addLine(new HeaderCard(header.getKeyword(), null, header.getComment(), true));
                        continue;
                    }
                    switch (header.getDataType()) {
                        case Integer: {
                            hdu.addValue(header.getKeyword(), ((Number)value).intValue(), header.getComment());
                            break;
                        }
                        case Float: {
                            double data = ((Number)value).doubleValue();
                            if (!Double.isFinite(data)) {
                                throw new IllegalArgumentException("Can not store non-finite floating point in FITS file");
                            }
                            hdu.addValue(header.getKeyword(), HeaderWriter.formatDouble(data), header.getComment());
                            break;
                        }
                        case Boolean: {
                            hdu.addValue(header.getKeyword(), (Boolean)value, header.getComment());
                            break;
                        }
                        case Date: {
                            hdu.addValue(header.getKeyword(), DateUtils.convertTemporalToString(value), header.getComment());
                            break;
                        }
                        case MJD: {
                            hdu.addValue(header.getKeyword(), DateUtils.convertTemporalToMJD(value), header.getComment());
                            break;
                        }
                        default: {
                            hdu.addValue(header.getKeyword(), String.valueOf(value), header.getComment());
                        }
                    }
                }
                catch (ClassCastException x) {
                    throw new FitsFileWriter.FitsIOException(file, (Throwable)x, "Meta-data header %s with value %s(%s) cannot be converted to type %s", new Object[]{header.getKeyword(), value, value.getClass(), header.getDataType()});
                }
                catch (IllegalArgumentException | HeaderCardException x) {
                    throw new FitsFileWriter.FitsIOException(file, (Throwable)x, "Meta-data header %s with value %s(%s) cannot be written", header.getKeyword(), value, value.getClass());
                }
            }
        }
    }

    private static double formatDouble(double d) {
        String dStr = String.format("%5g", d);
        return Double.parseDouble(dStr);
    }
}

