/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandArgumentTypeException;
import org.lsst.ccs.command.CommandDictionaryBuilder;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.MethodBasedDictionaryArgument;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.RawCommand;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

public class CommandSetBuilder {
    private final InputConversionEngine engine = new InputConversionEngine();

    public CommandSet buildCommandSet(Object object) {
        Class<?> targetClass = object.getClass();
        CommandDictionaryBuilder dictionary = new CommandDictionaryBuilder(targetClass);
        CommandSetImplementation commandSet = new CommandSetImplementation(dictionary, object);
        for (DictionaryCommand dc : dictionary.getCommandDictionary()) {
            for (DictionaryArgument da : dc.getArguments()) {
                MethodBasedDictionaryArgument mbda;
                if (!(da instanceof MethodBasedDictionaryArgument) || (mbda = (MethodBasedDictionaryArgument)da).getAllowedValueMethod() == null) continue;
                mbda.setAllowedValuesProvder(() -> {
                    try {
                        return (List)mbda.getAllowedValueMethod().invoke(object, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                        return Collections.emptyList();
                    }
                });
            }
        }
        return commandSet;
    }

    private class CommandSetImplementation
    implements CommandSet {
        private final CommandDictionaryBuilder dict;
        private final Object target;

        private CommandSetImplementation(CommandDictionaryBuilder dict, Object target) {
            this.dict = dict;
            this.target = target;
        }

        @Override
        public Dictionary getCommandDictionary() {
            return this.dict.getCommandDictionary();
        }

        @Override
        public Object invoke(BasicCommand command) throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
            Method method = this.dict.getMethod(command);
            if (method == null) {
                throw new CommandInvocationException("Error: No handler found for command %s with %d arguments", command.getCommand(), command.getArgumentCount());
            }
            return this.invoke(this.target, method, command);
        }

        private Object invoke(Object target, Method method, BasicCommand command) throws CommandInvocationException, CommandArgumentTypeException {
            RawCommand raw = RawCommand.toRawCommand(command, method, CommandSetBuilder.this.engine);
            try {
                Object[] args = raw.getArguments();
                boolean hasOptions = this.hasOptions(method);
                if (hasOptions) {
                    Object[] argsWithOptions = new Object[args.length + 1];
                    argsWithOptions[0] = raw.getOptions();
                    for (int i = 0; i < args.length; ++i) {
                        argsWithOptions[i + 1] = args[i];
                    }
                    args = argsWithOptions;
                }
                return method.invoke(target, args);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                int i;
                String msg = "Error: Can't invoke command " + command.prettyToString() + "\n";
                msg = msg + "Attempted to invoke it on method " + method.getName() + " on object " + target.getClass().getCanonicalName() + " (" + target + ")\n";
                int pars = method.getParameterCount();
                msg = msg + "Method " + method.getName() + " requires " + pars + " parameters of type: \n";
                for (i = 0; i < pars; ++i) {
                    Parameter p = method.getParameters()[i];
                    msg = msg + "-" + i + "- " + p.getName() + " " + p.getType().getCanonicalName() + "\n";
                }
                msg = msg + "Command " + command.getCommand() + " has " + command.getArgumentCount() + " arguments\n";
                for (i = 0; i < command.getArgumentCount(); ++i) {
                    Object a = command.getArguments()[i];
                    msg = msg + "-" + i + "- " + a + " " + a.getClass().getCanonicalName() + "\n";
                }
                throw new CommandInvocationException(msg, ex);
            }
            catch (InvocationTargetException ex) {
                throw new CommandInvocationException(ex);
            }
        }

        private boolean hasOptions(Method m) {
            Type[] allParameterTypes = m.getGenericParameterTypes();
            return allParameterTypes.length > 0 && allParameterTypes[0] == Options.class;
        }
    }
}

