/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.TestReg;
import org.lsst.ccs.drivers.reb.sim.AddressSpace;
import org.lsst.ccs.drivers.reb.sim.DAQSimulation;
import org.lsst.ccs.drivers.reb.sim.HandleAndIdManager;
import org.lsst.ccs.drivers.reb.sim.REB3Simulation;
import org.lsst.ccs.drivers.reb.sim.SimulationException;

public class GlobalClientSimulation
implements GlobalClient.Impl {
    private final HandleAndIdManager manager;
    private List<AddressSpace> addressSpaces;
    private final DAQSimulation daq;
    private boolean initializeOnTrigger = false;
    private final boolean supportMultiMains;

    GlobalClientSimulation(HandleAndIdManager manager, DAQSimulation daq, boolean supportMultiMains) {
        this.manager = manager;
        this.daq = daq;
        this.supportMultiMains = supportMultiMains;
    }

    @Override
    public void setRegisterList(int rebType, int[] registers) {
        this.daq.setRegisterList(rebType, registers);
    }

    @Override
    public long triggerImage(String name) {
        this.initializeAddressSpaces("triggerImage");
        this.daq.setImageName(name);
        for (AddressSpace as : this.addressSpaces) {
            int state = as.read(8);
            as.write(9, state |= 4);
        }
        return 1000000L * System.currentTimeMillis();
    }

    private void initializeAddressSpaces(String name) throws SimulationException {
        if (this.addressSpaces == null) {
            if (this.initializeOnTrigger) {
                this.addressSpaces = new ArrayList<AddressSpace>();
                for (AddressSpace as : this.manager.getAllAddressSpaces()) {
                    this.addressSpaces.add(as);
                }
            } else {
                throw new SimulationException(name + " called but no ids registered");
            }
        }
    }

    @Override
    public long startSequencer(int opcode) throws REBException {
        if (this.supportMultiMains) {
            this.initializeAddressSpaces("startSequencer");
            for (AddressSpace as : this.addressSpaces) {
                if (!(as instanceof REB3Simulation)) continue;
                REB3Simulation reb = (REB3Simulation)as;
                reb.getSequencer().trigger(opcode);
            }
        }
        return 1000000L * System.currentTimeMillis();
    }

    @Override
    public long triggerImage(String name, String folder, int opcode, String annotation, int ... ids) throws REBException {
        if (!this.supportMultiMains) {
            return this.triggerImage(name);
        }
        this.initializeAddressSpaces("triggerImage");
        this.daq.setImageName(name);
        for (AddressSpace as : this.addressSpaces) {
            if (!(as instanceof REB3Simulation)) continue;
            REB3Simulation reb = (REB3Simulation)as;
            reb.getSequencer().trigger(opcode);
        }
        return 1000000L * System.currentTimeMillis();
    }

    @Override
    public void deleteGlobalClient() {
        this.addressSpaces = null;
    }

    @Override
    public void newGlobalClient(int[] ids, String[] ifc) throws REBException {
        if (this.initializeOnTrigger || this.addressSpaces != null) {
            throw new SimulationException("Unsupported repeat call to newGlobalClient");
        }
        ArrayList<AddressSpace> seqs = new ArrayList<AddressSpace>();
        for (int id : ids) {
            AddressSpace as = this.manager.getAddressSpaceForId(id);
            seqs.add(as);
        }
        this.addressSpaces = seqs;
    }

    @Override
    public void newGlobalClient(String part) throws REBException {
        if (this.initializeOnTrigger || this.addressSpaces != null) {
            throw new SimulationException("Unsupported repeat call to newGlobalClient");
        }
        this.initializeOnTrigger = true;
    }

    @Override
    public int getHwType() {
        return this.supportMultiMains ? TestReg.HdwType.DAQ4.getValue() : TestReg.HdwType.DAQ1.getValue();
    }
}

