/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.HubConnector;
import org.astrogrid.samp.client.TrackedClientSet;
import org.astrogrid.samp.gui.ClientListCellRenderer;
import org.astrogrid.samp.gui.ErrorDialog;
import org.astrogrid.samp.gui.HubView;
import org.astrogrid.samp.gui.IconBox;
import org.astrogrid.samp.gui.IconStore;
import org.astrogrid.samp.gui.SysTray;
import org.astrogrid.samp.hub.Hub;
import org.astrogrid.samp.hub.HubServiceMode;

public class GuiHubConnector
extends HubConnector {
    private final ListModel clientListModel_ = (ListModelTrackedClientSet)this.getClientSet();
    private final List connectionListenerList_ = new ArrayList();
    private final Map updateMap_ = new WeakHashMap();
    private boolean wasConnected_;
    static ConnectionUpdate ENABLE_ACTION = new ConnectionUpdate(){

        public void setConnected(Object action, boolean isConnected) {
            ((Action)action).setEnabled(isConnected);
        }
    };
    static ConnectionUpdate DISABLE_ACTION = new ConnectionUpdate(){

        public void setConnected(Object action, boolean isConnected) {
            ((Action)action).setEnabled(!isConnected);
        }
    };
    static ConnectionUpdate REPAINT_COMPONENT = new ConnectionUpdate(){

        public void setConnected(Object comp, boolean isConnected) {
            ((Component)comp).repaint();
        }
    };
    static ConnectionUpdate ENABLE_COMPONENT = new ConnectionUpdate(){

        public void setConnected(Object comp, boolean isConnected) {
            ((Component)comp).setEnabled(isConnected);
        }
    };
    static /* synthetic */ Class class$org$astrogrid$samp$gui$GuiHubConnector;

    public GuiHubConnector(ClientProfile profile) {
        super(profile, new ListModelTrackedClientSet());
        this.addConnectionListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GuiHubConnector.this.updateConnectionState();
            }
        });
        this.updateConnectionState();
    }

    protected void connectionChanged(boolean isConnected) {
        super.connectionChanged(isConnected);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChangeEvent evt = new ChangeEvent(GuiHubConnector.this);
                Iterator it = GuiHubConnector.this.connectionListenerList_.iterator();
                while (it.hasNext()) {
                    ((ChangeListener)it.next()).stateChanged(evt);
                }
            }
        });
    }

    public void addConnectionListener(ChangeListener listener) {
        this.connectionListenerList_.add(listener);
    }

    public void removeConnectionListener(ChangeListener listener) {
        this.connectionListenerList_.remove(listener);
    }

    public ListModel getClientListModel() {
        return this.clientListModel_;
    }

    public ListCellRenderer createClientListCellRenderer() {
        return new ClientListCellRenderer();
    }

    public Action createRegisterAction() {
        RegisterAction regAct = new RegisterAction(true);
        this.registerUpdater(regAct, DISABLE_ACTION);
        return regAct;
    }

    public Action createUnregisterAction() {
        RegisterAction unregAct = new RegisterAction(false);
        this.registerUpdater(unregAct, ENABLE_ACTION);
        return unregAct;
    }

    public Action createToggleRegisterAction() {
        RegisterAction toggleRegAct = new RegisterAction();
        this.registerUpdater(toggleRegAct, new ConnectionUpdate(){

            public void setConnected(Object item, boolean isConnected) {
                ((RegisterAction)item).setSense(!isConnected);
            }
        });
        return toggleRegAct;
    }

    public Action createRegisterOrHubAction(final Component parent, Action[] hubStartActions) {
        Action[] hubActs;
        if (hubStartActions != null) {
            hubActs = hubStartActions;
        } else {
            HubServiceMode internalMode = SysTray.getInstance().isSupported() ? HubServiceMode.CLIENT_GUI : HubServiceMode.NO_GUI;
            hubActs = new Action[]{this.createHubAction(false, internalMode), this.createHubAction(true, HubServiceMode.MESSAGE_GUI)};
        }
        RegisterAction regAct = new RegisterAction(){

            protected void registerFailed() {
                String[] msg = new String[]{"No SAMP hub is running.", "You may start a hub if you wish."};
                ArrayList buttList = new ArrayList();
                Object[] options = new JButton[hubActs.length + 1];
                for (int i = 0; i < hubActs.length; ++i) {
                    options[i] = new JButton(hubActs[i]);
                }
                options[hubActs.length] = new JButton("Cancel");
                final JDialog dialog = new JOptionPane(msg, 2, -1, null, options, null).createDialog(parent, "No Hub");
                ActionListener closeListener = new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        dialog.dispose();
                    }
                };
                for (int iopt = 0; iopt < options.length; ++iopt) {
                    ((AbstractButton)options[iopt]).addActionListener(closeListener);
                }
                dialog.setVisible(true);
            }
        };
        this.registerUpdater(regAct, new ConnectionUpdate(){

            public void setConnected(Object item, boolean isConnected) {
                ((RegisterAction)item).setSense(!isConnected);
            }
        });
        return regAct;
    }

    public Action createShowMonitorAction() {
        return new MonitorAction();
    }

    public Action createHubAction(boolean external, HubServiceMode hubMode) {
        return new HubAction(external, hubMode);
    }

    public JComponent createConnectionIndicator(final Icon onIcon, final Icon offIcon) {
        JLabel label = new JLabel(new Icon(){

            private Icon effIcon() {
                return GuiHubConnector.this.isConnected() ? onIcon : offIcon;
            }

            public int getIconWidth() {
                return this.effIcon().getIconWidth();
            }

            public int getIconHeight() {
                return this.effIcon().getIconHeight();
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                this.effIcon().paintIcon(c, g, x, y);
            }
        });
        this.registerUpdater(label, REPAINT_COMPONENT);
        return label;
    }

    public JComponent createConnectionIndicator() {
        return this.createConnectionIndicator(new ImageIcon(Client.class.getResource("images/connected-24.gif")), new ImageIcon(Client.class.getResource("images/disconnected-24.gif")));
    }

    public JComponent createClientBox(final boolean vertical, int iconSize) {
        final IconStore iconStore = new IconStore(IconStore.createMinimalIcon(iconSize));
        IconBox box = new IconBox(iconSize);
        box.setVertical(vertical);
        box.setBorder(GuiHubConnector.createBoxBorder());
        box.setModel(this.clientListModel_);
        box.setRenderer(new IconBox.CellRenderer(){

            public Icon getIcon(IconBox iconBox, Object value, int index) {
                return IconStore.scaleIcon(iconStore.getIcon((Client)value), iconBox.getTransverseSize(), 2.0, !vertical);
            }

            public String getToolTipText(IconBox iconBox, Object value, int index) {
                return ((Client)value).toString();
            }
        });
        Dimension boxSize = box.getPreferredSize();
        boxSize.width = 128;
        box.setPreferredSize(boxSize);
        this.registerUpdater(box, ENABLE_COMPONENT);
        return box;
    }

    public JComponent createMonitorPanel() {
        HubView view = new HubView(false);
        view.setClientListModel(this.getClientListModel());
        view.getClientList().setCellRenderer(this.createClientListCellRenderer());
        return view;
    }

    private void scheduleConnectionChange() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean isConnected = GuiHubConnector.this.isConnected();
                if (isConnected != GuiHubConnector.this.wasConnected_) {
                    GuiHubConnector.this.wasConnected_ = isConnected;
                    ChangeEvent evt = new ChangeEvent(GuiHubConnector.this);
                    Iterator it = GuiHubConnector.this.connectionListenerList_.iterator();
                    while (it.hasNext()) {
                        ((ChangeListener)it.next()).stateChanged(evt);
                    }
                }
            }
        });
    }

    private void updateConnectionState() {
        boolean isConn = this.isConnected();
        Iterator it = this.updateMap_.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object item = entry.getKey();
            ConnectionUpdate update = (ConnectionUpdate)entry.getValue();
            update.setConnected(item, isConn);
        }
    }

    static Border createBoxBorder() {
        return BorderFactory.createCompoundBorder(new JTextField().getBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    void registerUpdater(Object item, ConnectionUpdate updater) {
        updater.setConnected(item, this.isConnected());
        this.updateMap_.put(item, updater);
    }

    private class HubAction
    extends AbstractAction {
        private final boolean external_;
        private final HubServiceMode hubMode_;
        private final boolean isAvailable_;

        HubAction(boolean external, HubServiceMode hubMode) {
            this.external_ = external;
            this.hubMode_ = hubMode;
            this.putValue("Name", "Start " + (external ? "external" : "internal") + " hub");
            this.putValue("ShortDescription", "Attempts to start up a SAMP hub" + (external ? " running independently of this application" : " running within this application"));
            this.setEnabled(!GuiHubConnector.this.isConnected());
            GuiHubConnector.this.registerUpdater(this, DISABLE_ACTION);
            boolean isAvailable = true;
            if (external) {
                try {
                    Hub.checkExternalHubAvailability();
                }
                catch (Exception e) {
                    isAvailable = false;
                }
            }
            this.isAvailable_ = isAvailable;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                this.attemptRunHub();
            }
            catch (Exception e) {
                ErrorDialog.showError(null, "Hub Start Failed", e.getMessage(), e);
            }
            GuiHubConnector.this.setActive(true);
        }

        public boolean isEnabled() {
            return this.isAvailable_ && super.isEnabled();
        }

        private void attemptRunHub() throws IOException {
            if (this.external_) {
                Hub.runExternalHub(this.hubMode_);
            } else {
                Hub.runHub(this.hubMode_);
            }
            GuiHubConnector.this.setActive(true);
        }
    }

    private class MonitorAction
    extends AbstractAction {
        private JFrame monitorWindow_;

        MonitorAction() {
            super("Show Hub Status");
            this.putValue("ShortDescription", "Display a window showing client applications registered with the SAMP hub");
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.monitorWindow_ == null) {
                this.monitorWindow_ = new JFrame("SAMP Status");
                this.monitorWindow_.getContentPane().add((Component)GuiHubConnector.this.createMonitorPanel(), "Center");
                this.monitorWindow_.pack();
            }
            this.monitorWindow_.setVisible(true);
        }
    }

    private class RegisterAction
    extends AbstractAction {
        public RegisterAction() {
        }

        public RegisterAction(boolean active) {
            this();
            this.setSense(active);
        }

        public void setSense(boolean active) {
            this.putValue("ActionCommandKey", active ? "REGISTER" : "UNREGISTER");
            this.putValue("Name", active ? "Register with Hub" : "Unregister from Hub");
            this.putValue("ShortDescription", active ? "Attempt to connect to SAMP hub" : "Disconnect from SAMP hub");
        }

        public void actionPerformed(ActionEvent evt) {
            String cmd = evt.getActionCommand();
            if ("REGISTER".equals(cmd)) {
                GuiHubConnector.this.setActive(true);
                if (!GuiHubConnector.this.isConnected()) {
                    this.registerFailed();
                }
            } else if ("UNREGISTER".equals(cmd)) {
                GuiHubConnector.this.setActive(false);
            } else {
                throw new UnsupportedOperationException("Unknown action " + cmd);
            }
        }

        protected void registerFailed() {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private static class ListModelTrackedClientSet
    extends TrackedClientSet
    implements ListModel {
        private final List clientList_ = new ArrayList();
        private final List listenerList_ = new ArrayList();

        ListModelTrackedClientSet() {
        }

        public int getSize() {
            return this.clientList_.size();
        }

        public Object getElementAt(int index) {
            return this.clientList_.get(index);
        }

        public void addListDataListener(ListDataListener listener) {
            this.listenerList_.add(listener);
        }

        public void removeListDataListener(ListDataListener listener) {
            this.listenerList_.remove(listener);
        }

        public void addClient(final Client client) {
            super.addClient(client);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int index = ListModelTrackedClientSet.this.clientList_.size();
                    ListModelTrackedClientSet.this.clientList_.add(client);
                    ListDataEvent evt = new ListDataEvent(ListModelTrackedClientSet.this, 1, index, index);
                    Iterator it = ListModelTrackedClientSet.this.listenerList_.iterator();
                    while (it.hasNext()) {
                        ((ListDataListener)it.next()).intervalAdded(evt);
                    }
                }
            });
        }

        public void removeClient(final Client client) {
            super.removeClient(client);
            SwingUtilities.invokeLater(new Runnable(){
                static final /* synthetic */ boolean $assertionsDisabled;

                public void run() {
                    int index = ListModelTrackedClientSet.this.clientList_.indexOf(client);
                    if (!$assertionsDisabled && index < 0) {
                        throw new AssertionError();
                    }
                    if (index >= 0) {
                        ListModelTrackedClientSet.this.clientList_.remove(index);
                        ListDataEvent evt = new ListDataEvent(ListModelTrackedClientSet.this, 2, index, index);
                        Iterator it = ListModelTrackedClientSet.this.listenerList_.iterator();
                        while (it.hasNext()) {
                            ((ListDataListener)it.next()).intervalRemoved(evt);
                        }
                    }
                }

                static {
                    $assertionsDisabled = !(class$org$astrogrid$samp$gui$GuiHubConnector == null ? (class$org$astrogrid$samp$gui$GuiHubConnector = GuiHubConnector.class$("org.astrogrid.samp.gui.GuiHubConnector")) : class$org$astrogrid$samp$gui$GuiHubConnector).desiredAssertionStatus();
                }
            });
        }

        public void setClients(final Client[] clients) {
            super.setClients(clients);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int oldSize = ListModelTrackedClientSet.this.clientList_.size();
                    if (oldSize > 0) {
                        ListModelTrackedClientSet.this.clientList_.clear();
                        ListDataEvent removeEvt = new ListDataEvent(ListModelTrackedClientSet.this, 2, 0, oldSize - 1);
                        Iterator it = ListModelTrackedClientSet.this.listenerList_.iterator();
                        while (it.hasNext()) {
                            ((ListDataListener)it.next()).intervalRemoved(removeEvt);
                        }
                    }
                    if (clients.length > 0) {
                        ListModelTrackedClientSet.this.clientList_.addAll(Arrays.asList(clients));
                        int newSize = ListModelTrackedClientSet.this.clientList_.size();
                        ListDataEvent addEvt = new ListDataEvent(ListModelTrackedClientSet.this, 1, 0, newSize - 1);
                        Iterator it = ListModelTrackedClientSet.this.listenerList_.iterator();
                        while (it.hasNext()) {
                            ((ListDataListener)it.next()).intervalAdded(addEvt);
                        }
                    }
                }
            });
        }

        public void updateClient(final Client client, boolean metaChanged, boolean subsChanged) {
            super.updateClient(client, metaChanged, subsChanged);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int index = ListModelTrackedClientSet.this.clientList_.indexOf(client);
                    if (index >= 0) {
                        ListDataEvent evt = new ListDataEvent(ListModelTrackedClientSet.this, 0, index, index);
                        Iterator it = ListModelTrackedClientSet.this.listenerList_.iterator();
                        while (it.hasNext()) {
                            ((ListDataListener)it.next()).contentsChanged(evt);
                        }
                    }
                }
            });
        }
    }

    static interface ConnectionUpdate {
        public void setConnected(Object var1, boolean var2);
    }
}

