/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.messaging.util.Dispatcher;

public class MessageGate {
    private final Dispatcher dispatcher;
    private final Alert alert;
    private final int vetoTime;
    private final double vetoFactor;
    private final int[] thresholdsN;
    private final int[] thresholdsMB;
    private int lastValueN;
    private int lastValueMB;
    private long lastTimeN;
    private long lastTimeMB;
    private volatile int lastLevel = -1;
    private final AtomicInteger nAccumulator = new AtomicInteger();
    private final AtomicLong sizeAccumulator = new AtomicLong();
    private long periodStartTime;

    public MessageGate(Dispatcher dispatcher, String alertID, int[] thresholdsN, int[] thresholdsMB, int vetoTime, double vetoFactor) {
        this.thresholdsN = thresholdsN == null || thresholdsN.length == 0 ? null : thresholdsN;
        int[] nArray = this.thresholdsMB = thresholdsMB == null || thresholdsMB.length == 0 ? null : thresholdsMB;
        if (this.thresholdsN == null && this.thresholdsMB == null) {
            this.alert = null;
        } else {
            this.alert = new Alert(alertID, "Message rate alert.");
            dispatcher.registerAlert(this.alert);
        }
        this.dispatcher = dispatcher;
        this.vetoTime = vetoTime;
        this.vetoFactor = vetoFactor;
    }

    public MessageGate(Dispatcher dispatcher, String alertID, int[] thresholdsN, int[] thresholdsMB) {
        this(dispatcher, alertID, thresholdsN, thresholdsMB, 5000, 1.5);
    }

    protected String getMessage(int value) {
        return "High value of " + this.alert.getAlertId() + " : " + value;
    }
}

