/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.MonitoringConfig;

public class MonitorincConfigTest
extends CcsTestCaseTemplate {
    private static FocalPlaneSubsystem testSubsystem;
    private static Agent console;

    @Before
    public void createSubsystem() throws Exception {
        try {
            System.setProperty("org.lsst.ccs.transport", "mock:single");
            System.setProperty("org.lsst.ccs.run.mode", "simulation");
            System.setProperty("org.lsst.ccs.logging.StackTraceFormats.depth", "-1");
            testSubsystem = (FocalPlaneSubsystem)BootUtils.getSubsystemFromFile((String)"FocalPlane", null, (String)"focal-plane-test");
            testSubsystem.startAgent();
            console = new Agent("console", AgentInfo.AgentType.CONSOLE);
            console.startAgent();
            testSubsystem.getMessagingAccess().getAgentPresenceManager().waitForConnectedAgent(console.getName(), 30L, TimeUnit.SECONDS);
            console.getMessagingAccess().getAgentPresenceManager().waitForConnectedAgent(testSubsystem.getName(), 30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @After
    public void shutdownSubsystem() throws Exception {
        if (testSubsystem != null) {
            testSubsystem.shutdownAgent();
        }
        if (console != null) {
            console.shutdownAgent();
        }
        System.setProperty("org.lsst.ccs.run.mode", "");
        System.setProperty("org.lsst.ccs.drivers.reb.sim.REBType", "");
    }

    @Test
    public void testMonitoringConfig() throws Exception {
        MonitoringConfig monitoringConfig = (MonitoringConfig)testSubsystem.getComponentLookup().getComponentByPath("monitoringConfig");
        Assert.assertNotNull((Object)monitoringConfig);
        Assert.assertTrue((boolean)monitoringConfig.getTasksToPauseDuringReadout().isEmpty());
        Assert.assertTrue((boolean)monitoringConfig.getTasksToTriggerAfterReadout().isEmpty());
        ConfigurationService cf = (ConfigurationService)testSubsystem.getAgentService(ConfigurationService.class);
        cf.change("monitoringConfig", "readoutPauseTasks", (Object)".*");
        Assert.assertTrue((!monitoringConfig.getTasksToPauseDuringReadout().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)monitoringConfig.getTasksToTriggerAfterReadout().isEmpty());
        Assert.assertEquals((long)37L, (long)monitoringConfig.getTasksToPauseDuringReadout().size());
        cf.change("monitoringConfig", "postReadoutTriggerTasks", (Object)".*aspicTemp|.*rebTemp");
        Assert.assertEquals((long)12L, (long)monitoringConfig.getTasksToTriggerAfterReadout().size());
        cf.change("monitoringConfig", "readoutPauseTasks", (Object)"R22.*");
        Assert.assertEquals((long)18L, (long)monitoringConfig.getTasksToPauseDuringReadout().size());
    }
}

