/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;

public class CCSImageList {
    private final Path path;
    private final String dataFolder;
    private final String daqFolder;
    private final List<String> images;

    CCSImageList(Path path, String dataFolder, String daqFolder, List<String> images) {
        this.path = path;
        this.dataFolder = dataFolder;
        this.daqFolder = daqFolder;
        this.images = images;
    }

    void save() throws IOException {
        try (PrintWriter out = new PrintWriter(Files.newBufferedWriter(this.path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));){
            out.println(this.dataFolder);
            out.println(this.daqFolder);
            for (String image : this.images) {
                out.println(image);
            }
        }
    }

    int size() {
        return this.images.size();
    }

    void add(String image) {
        this.images.add(image);
    }

    static CCSImageList open(Path path) throws IOException {
        List<String> lines = Files.readAllLines(path);
        String dataFolder = lines.get(0);
        String daqFolder = lines.get(1);
        List<String> imageList = lines.subList(2, lines.size());
        return new CCSImageList(path, dataFolder, daqFolder, imageList);
    }

    static CCSImageList create(Path playListPath, String dataFolder, String daqFolder) {
        ArrayList<String> imageList = new ArrayList<String>();
        return new CCSImageList(playListPath, dataFolder, daqFolder, imageList);
    }

    String getDAQFolder() {
        return this.daqFolder;
    }

    String getName() {
        return this.path.getFileName().toString();
    }

    String get(int index) {
        return this.images.get(index);
    }

    public String getDataFolder() {
        return this.dataFolder;
    }
}

