/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.plotter;

import jas.plot.PrintHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.freehep.application.mdi.ManagedPage;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.studio.Studio;
import org.freehep.graphicsbase.util.export.ExportDialog;
import org.freehep.graphicsbase.util.export.VectorGraphicsTransferable;
import org.freehep.jas.plugin.plotter.DefaultRegion;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.swing.layout.PercentLayout;
import org.freehep.swing.popup.HasPopupItems;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.images.ImageHandler;

public class DefaultPage
extends JPanel
implements PlotPage,
HasPopupItems,
ManagedPage {
    protected static final Icon histogramIcon = ImageHandler.getIcon((String)"images/Histogram", DefaultPage.class);
    private final Studio studio;
    private final PlotFactory factory;
    private final PercentLayout layout;
    private final Commands commands = new Commands();
    private final MouseListener ml = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            DefaultRegion reg = (DefaultRegion)e.getSource();
            DefaultPage.this.setCurrentRegion(reg);
        }
    };
    protected PageContext context;
    private String title;
    private int nColumns = -1;
    private int nRows = -1;
    private int nAddedRegions = 0;
    private DefaultRegion currentRegion;

    public DefaultPage(Studio studio, PlotFactory factory, String title) {
        this.studio = studio;
        this.factory = factory;
        this.title = title;
        this.layout = new PercentLayout();
        this.setLayout((LayoutManager)this.layout);
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(600, 600));
    }

    protected void setTitle(String title) {
        this.title = title;
        if (this.context != null) {
            this.context.setTitle(title);
        }
    }

    protected String title() {
        return this.title;
    }

    protected int columns() {
        return this.nColumns;
    }

    protected int rows() {
        return this.nRows;
    }

    protected int addedRegions() {
        return this.nAddedRegions;
    }

    @Override
    public void clearRegions() {
        this.removeAll();
        this.currentRegion = null;
        this.nColumns = -1;
        this.nRows = -1;
        this.nAddedRegions = 0;
    }

    @Override
    public PlotRegion createRegion(double x, double y, double w, double h) {
        DefaultRegion result = new DefaultRegion(this.factory);
        result.addMouseListener(this.ml);
        this.add((Component)result, new PercentLayout.Constraint(x * 100.0, y * 100.0, w * 100.0, h * 100.0));
        this.setCurrentRegion(result);
        return result;
    }

    @Override
    public void createRegions(int columns, int rows) {
        this.clearRegions();
        this.nColumns = columns;
        this.nRows = rows;
        if (rows * columns != 0) {
            double pcWidth = 100 / columns;
            double pcHeight = 100 / rows;
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < columns; ++c) {
                    DefaultRegion region = new DefaultRegion(this.factory);
                    region.addMouseListener(this.ml);
                    this.add((Component)region, new PercentLayout.Constraint((double)c * pcWidth, (double)r * pcHeight, pcWidth, pcHeight));
                    if (r != 0 || c != 0) continue;
                    this.setCurrentRegion(region);
                }
            }
        }
    }

    @Override
    public PlotRegion currentRegion() {
        return this.currentRegion;
    }

    @Override
    public PlotRegion next() {
        Component[] c = this.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != this.currentRegion) continue;
            int index = (i + 1) % c.length;
            this.setCurrentRegion((PlotRegion)((Object)c[index]));
            return this.currentRegion;
        }
        return null;
    }

    @Override
    public int numberOfRegions() {
        return this.getComponentCount();
    }

    @Override
    public PlotRegion region(int index) {
        return (PlotRegion)((Object)this.getComponent(index));
    }

    @Override
    public void setCurrentRegion(PlotRegion reg) {
        if (reg != this.currentRegion) {
            if (!(reg instanceof DefaultRegion)) {
                throw new IllegalArgumentException();
            }
            if (this.currentRegion != null) {
                this.currentRegion.setSelected(false);
            }
            this.currentRegion = (DefaultRegion)reg;
            if (this.currentRegion != null) {
                this.currentRegion.setSelected(true);
            }
        }
    }

    @Override
    public void showPage() {
        if (this.context == null) {
            this.context = this.studio.getPageManager().openPage(this, this.title, histogramIcon, "Plot");
        } else {
            this.context.requestShow();
        }
    }

    @Override
    public void hidePage() {
        if (this.context != null) {
            this.context.close();
        }
    }

    @Override
    public Component viewable() {
        return this;
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        this.studio.getXMLMenuBuilder().mergePopupMenu("PlotPagePopupMenu", menu);
        return menu;
    }

    @Override
    public boolean close() {
        this.context = null;
        return true;
    }

    @Override
    public void pageClosed() {
    }

    @Override
    public void pageDeiconized() {
    }

    @Override
    public void pageIconized() {
    }

    @Override
    public void pageSelected() {
        this.studio.getCommandTargetManager().add((CommandGroup)this.commands);
    }

    @Override
    public void pageDeselected() {
        this.studio.getCommandTargetManager().remove((CommandGroup)this.commands);
    }

    @Override
    public void setPageContext(PageContext context) {
    }

    @Override
    public PlotRegion addRegion() {
        ++this.nAddedRegions;
        int n = this.getComponentCount();
        DefaultRegion result = new DefaultRegion(this.factory);
        result.addMouseListener(this.ml);
        this.add((Component)result, new PercentLayout.Constraint(0.0, 0.0, 100.0, 100.0));
        this.setCurrentRegion(result);
        if (n < 2) {
            this.setLayout(2, 1);
        } else if (n < 3) {
            this.setLayout(3, 1);
        } else if (n < 4) {
            this.setLayout(2, 2);
        } else if (n < 6) {
            this.setLayout(3, 2);
        } else if (n < 9) {
            this.setLayout(3, 3);
        } else if (n < 12) {
            this.setLayout(4, 3);
        } else if (n < 16) {
            this.setLayout(4, 4);
        } else if (n < 20) {
            this.setLayout(5, 4);
        } else if (n < 25) {
            this.setLayout(5, 5);
        } else if (n < 30) {
            this.setLayout(6, 5);
        } else if (n < 36) {
            this.setLayout(6, 6);
        } else {
            int nn = 1 + (int)Math.floor(Math.sqrt(n - 1));
            this.setLayout(nn, nn);
        }
        this.revalidate();
        this.repaint();
        return result;
    }

    private void setLayout(int columns, int rows) {
        if (rows * columns != 0) {
            double pcWidth = 100 / columns;
            double pcHeight = 100 / rows;
            Component[] comps = this.getComponents();
            int i = 0;
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < columns; ++c) {
                    if (i >= comps.length) {
                        return;
                    }
                    PercentLayout.Constraint constraint = this.layout.getConstraintFor(comps[i++]);
                    constraint.setConstraints((double)c * pcWidth, (double)r * pcHeight, pcWidth, pcHeight);
                }
            }
            this.nColumns = columns;
            this.nRows = rows;
        }
    }

    private class Commands
    extends CommandProcessor {
        private Commands() {
        }

        public void onRegions_1_1() {
            DefaultPage.this.createRegions(1, 1);
        }

        public void onRegions_2_1() {
            DefaultPage.this.createRegions(2, 1);
        }

        public void onRegions_1_2() {
            DefaultPage.this.createRegions(1, 2);
        }

        public void onRegions_2_2() {
            DefaultPage.this.createRegions(2, 2);
        }

        public void onRegions_3_1() {
            DefaultPage.this.createRegions(3, 1);
        }

        public void onRegions_1_3() {
            DefaultPage.this.createRegions(1, 3);
        }

        public void onRegions_3_2() {
            DefaultPage.this.createRegions(3, 2);
        }

        public void onRegions_2_3() {
            DefaultPage.this.createRegions(2, 3);
        }

        public void onRegions_3_3() {
            DefaultPage.this.createRegions(3, 3);
        }

        public void onRegions_4_4() {
            DefaultPage.this.createRegions(4, 4);
        }

        public void onCopy() {
            Clipboard cb = DefaultPage.this.getToolkit().getSystemClipboard();
            VectorGraphicsTransferable t = new VectorGraphicsTransferable((Component)DefaultPage.this);
            cb.setContents((Transferable)t, (ClipboardOwner)t);
        }

        public void onPrintSetup() {
            org.freehep.application.PrintHelper ph = new org.freehep.application.PrintHelper(DefaultPage.this, DefaultPage.this.studio);
            ph.showOptionsDialog(DefaultPage.this.studio);
        }

        public void onPrint() throws Exception {
            org.freehep.application.PrintHelper ph = new org.freehep.application.PrintHelper(DefaultPage.this, DefaultPage.this.studio);
            PrintHelper.instance().setPrintingThread(Thread.currentThread());
            ph.print();
            PrintHelper.instance().setPrintingThread(null);
        }

        public void onPrintPreview() throws Exception {
            org.freehep.application.PrintHelper ph = new org.freehep.application.PrintHelper(DefaultPage.this, DefaultPage.this.studio);
            PrintHelper.instance().setPrintingThread(Thread.currentThread());
            ph.printPreview(DefaultPage.this.studio);
            PrintHelper.instance().setPrintingThread(null);
        }

        public void onSaveAs() {
            Properties user = DefaultPage.this.studio.getUserProperties();
            String creator = user.getProperty("fullVersion");
            ExportDialog dlg = new ExportDialog(creator, true);
            dlg.setUserProperties(user);
            PrintHelper.instance().setPrintingThread(Thread.currentThread());
            dlg.showExportDialog((Component)DefaultPage.this.studio, "Save As...", (Component)DefaultPage.this, "plotpage");
            PrintHelper.instance().setPrintingThread(null);
        }

        public void onClearAllRegions() {
            for (int i = 0; i < DefaultPage.this.numberOfRegions(); ++i) {
                DefaultPage.this.region(i).clear();
            }
        }
    }
}

