/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending.dataselection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.gconsole.plugins.trending.dataselection.DataType;

public class PresetList
extends AbstractTableModel {
    private final String KEY = "org.lsst.trending.datatypes";
    private final Studio app;
    private ArrayList<DataType> data;

    public PresetList(Studio application) {
        this.app = application;
        this.restore();
    }

    public List<DataType> getRecent(int maxSize) {
        List<DataType> out = new ArrayList<DataType>(this.data);
        Collections.sort(out, DataType.compareByTime());
        if (maxSize < out.size()) {
            out = out.subList(0, maxSize);
        }
        Collections.sort(out, DataType.compareByName());
        return out;
    }

    public DataType get(int index) {
        return this.data.get(index);
    }

    public int indexOf(DataType type) {
        return this.data.indexOf(type);
    }

    public DataType get(String name) {
        for (DataType tw : this.data) {
            if (!name.equals(tw.toString())) continue;
            return tw;
        }
        return null;
    }

    public DataType insert(DataType type) {
        int i;
        if (type == null) {
            return null;
        }
        if (type.getRaw().booleanValue()) {
            return DataType.RAW;
        }
        if (type.getBins() == 0) {
            return DataType.DEFAULT;
        }
        String name = type.getName();
        int nElements = this.data.size();
        for (i = 0; i < nElements; ++i) {
            DataType e = this.data.get(i);
            int out = name.compareTo(e.getName());
            if (out == 0) {
                if (type.isReplaceableBy(e)) {
                    return e.touch();
                }
                this.data.set(i, type);
                break;
            }
            if (out >= 0) continue;
            this.data.add(i, type);
            break;
        }
        if (i == nElements) {
            this.data.add(type);
        }
        if (type.isPersistent()) {
            this.save();
        }
        this.fireTableStructureChanged();
        return type;
    }

    public void delete(DataType type) {
        if (this.data.remove(type) && type.isPersistent()) {
            this.save();
        }
        this.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.data.get(rowIndex).toString();
            }
            case 1: {
                return this.data.get(rowIndex).getRaw();
            }
            case 2: {
                return this.data.get(rowIndex).getBins();
            }
            case 3: {
                return this.data.get(rowIndex).isPersistent();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Raw data";
            }
            case 2: {
                return "Bins";
            }
            case 3: {
                return "Saved";
            }
        }
        throw new IllegalArgumentException();
    }

    private void save() {
        Properties prop = this.app.getUserProperties();
        if (prop != null) {
            int n = this.data.size();
            ArrayList<String> savedData = null;
            if (n != 0) {
                savedData = new ArrayList<String>(n);
                for (int i = 0; i < n; ++i) {
                    savedData.add(this.data.get(i).toCompressedString());
                }
            }
            PropertyUtilities.setStringCollection((Properties)prop, (String)"org.lsst.trending.datatypes", savedData);
        }
    }

    private void restore() {
        Properties prop = this.app.getUserProperties();
        if (prop == null) {
            this.data = new ArrayList(0);
        } else {
            String[] savedData = PropertyUtilities.getStringArray((Properties)prop, (String)"org.lsst.trending.datatypes", (String[])new String[0]);
            this.data = new ArrayList(savedData.length);
            for (String s : savedData) {
                try {
                    this.data.add(DataType.parseCompressedString(s));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            Collections.sort(this.data, DataType.compareByName());
        }
    }
}

