/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.FixedFileWrapper;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyUnicode;
import org.python.core.StdoutWrapper;
import org.python.core.Untraversable;

@Untraversable
class PrintFunction
extends PyBuiltinFunction {
    PrintFunction() {
        super("print", "print(value, ..., sep=' ', end='\\n', file=sys.stdout)\n\nPrints the values to a stream, or to sys.stdout by default.\nOptional keyword arguments:\nfile: a file-like object (stream); defaults to the current sys.stdout.\nsep:  string inserted between values, default a space.\nend:  string appended after the last value, default a newline.\n");
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] kwds) {
        int kwlen = kwds.length;
        int argslen = args.length;
        boolean useUnicode = false;
        PyObject[] values = new PyObject[argslen - kwlen];
        System.arraycopy(args, 0, values, 0, argslen - kwlen);
        PyObject[] keyValues = new PyObject[kwlen];
        System.arraycopy(args, argslen - kwlen, keyValues, 0, kwlen);
        ArgParser ap = new ArgParser("print", keyValues, kwds, new String[]{"sep", "end", "file"});
        for (PyObject keyValue : keyValues) {
            if (!(keyValue instanceof PyUnicode)) continue;
            useUnicode = true;
        }
        String sep = ap.getString(0, null);
        String end = ap.getString(1, null);
        PyObject file = ap.getPyObject(2, null);
        return PrintFunction.print(values, sep, end, file, useUnicode);
    }

    private static PyObject print(PyObject[] values, String sep, String end, PyObject file, boolean useUnicode) {
        StdoutWrapper out = file != null && file != Py.None ? new FixedFileWrapper(file) : Py.stdout;
        if (values.length == 0) {
            out.println(useUnicode);
        } else {
            PyString sepObject;
            if (!useUnicode) {
                for (PyObject value : values) {
                    if (!(value instanceof PyUnicode)) continue;
                    useUnicode = true;
                    break;
                }
            }
            if (sep == null) {
                sepObject = useUnicode ? Py.UnicodeSpace : Py.Space;
            } else {
                PyString pyString = sepObject = useUnicode ? Py.newUnicode(sep) : Py.newString(sep);
            }
            PyString endObject = end == null ? (useUnicode ? Py.UnicodeNewline : Py.Newline) : (useUnicode ? Py.newUnicode(end) : Py.newString(end));
            out.print(values, sepObject, endObject);
        }
        return Py.None;
    }
}

