/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.CarouselClampSensor;
import org.lsst.ccs.subsystems.fcs.CarouselPLCSensor;
import org.lsst.ccs.subsystems.fcs.CarouselSensor;
import org.lsst.ccs.subsystems.fcs.FcsAlerts;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHYTTC580;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHYTTC580SlipRing;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHYTTC580TemperaturesDevices;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnTTC580;
import org.lsst.ccs.subsystems.fcs.common.TTC580Interface;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.utils.TTC580Utils;

public class CanOpenTTC580
extends CanOpenDevice
implements TTC580Interface {
    public static final String LOCK_SENSOR = "lockSensor";
    public static final String FILTER_PRESENCE = "filterPresence";
    public static final String IO_MODULE_SENSOR = "ioModuleSensor";
    public static final String XMINUS = "Xminus";
    public static final String XPLUS = "Xplus";
    protected int cobid1;
    protected int cobid2;
    protected int cobid4;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Map<String, SensorPluggedOnTTC580> sensorsMap = new HashMap<String, SensorPluggedOnTTC580>();
    protected Map<String, CarouselPLCSensor> plcSensorsMap = new HashMap<String, CarouselPLCSensor>();
    protected long pdo1 = 0L;
    protected long pdo2 = 0L;
    protected long pdo4 = 0L;

    public int getCobid1() {
        return this.cobid1;
    }

    public int getCobid2() {
        return this.cobid2;
    }

    private void registerPLCData() {
        KeyValueData data = this.getSensorsData();
        this.dataProviderDictionaryService.registerData(data);
        KeyValueDataList dataList = (KeyValueDataList)data.getValue();
        String mainPath = data.getKey();
        for (KeyValueData d : dataList) {
            String path = mainPath + "/" + d.getKey();
            DataProviderInfo info = this.dataProviderDictionaryService.getDataProviderDictionary().getDataProviderInfoForPath(path);
            info.addAttribute(DataProviderInfo.Attribute.UNITS, "unitless");
            info.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, "Value of Digital Sensor " + d.getKey());
        }
    }

    @Override
    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByHYTTC580.class, this.path);
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByHYTTC580TemperaturesDevices.class, this.path + "/temperatures");
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByHYTTC580SlipRing.class, this.path);
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("PublishTTC580Temperatures", this::checkTTC580Temperatures).withIsFixedRate(true).withPeriod(Duration.ofMinutes(10L)));
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("PublishCarouselSlipRingCurrent", this::publishCarouselSlipRingCurrent).withIsFixedRate(true).withPeriod(Duration.ofSeconds(10L)));
    }

    @Override
    public void init() {
        this.cobid1 = this.nodeID + 384;
        this.cobid2 = this.nodeID + 640;
        this.cobid4 = this.nodeID + 1152;
        FCSLOG.info(this.name + " =====> initialization of my sensors map");
        if (this.sensorsMap.isEmpty()) {
            FCSLOG.severe("NO SENSORS ARE FOUND FOR " + this.name);
            return;
        }
        StringBuilder sb = new StringBuilder("\n");
        Iterator<SensorPluggedOnTTC580> it = this.sensorsMap.values().iterator();
        while (it.hasNext()) {
            SensorPluggedOnTTC580 sensor2 = it.next();
            sb.append(String.format("%30s", sensor2.getName()));
            sb.append("====>");
            if (this.name.equals(sensor2.getDeviceName())) {
                sb.append(" IS MY SENSOR ");
                sb.append(sensor2.toString());
                sb.append("#\n");
                continue;
            }
            it.remove();
        }
        FCSLOG.info(sb.toString());
        FCSLOG.info(this.name + " =====> MY SENSORS \n" + this.sensorsMap.toString());
        this.sensorsMap.values().stream().filter(sensor -> sensor instanceof CarouselPLCSensor).forEach(sensor -> this.plcSensorsMap.put(sensor.getName(), (CarouselPLCSensor)sensor));
        this.registerPLCData();
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsAlerts.CA_SENSOR_ERROR.getAlert(), alwaysClear);
    }

    @Override
    public long getPdo1() {
        return this.pdo1;
    }

    public void setPdo1(long pdoVal) {
        this.pdo1 = pdoVal;
    }

    @Override
    public long getPdo2() {
        return this.pdo2;
    }

    public void setPdo2(long pdo2) {
        this.pdo2 = pdo2;
    }

    @Override
    public long getPdo4() {
        return this.pdo4;
    }

    @Override
    public void doInitializePDOs() throws DriverException {
        this.tcpProxy.addReceivedPDO(this.cobid1);
        this.tcpProxy.addReceivedPDO(this.cobid2);
        this.tcpProxy.addReceivedPDO(this.cobid4);
        this.initialized = true;
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Disable interlock shutter. Do it only if you understand what you are doing.")
    public void interlockShutterDisable() {
        this.writeSDO(24672, 0, 1, 0L);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Enable interlock shutter. Do it only if you understand what you are doing.")
    public void interlockShutterEnable() {
        this.writeSDO(24672, 0, 1, 1L);
    }

    @Override
    public void updateFromPDO(PDOData pdo) {
        long beginTime = System.currentTimeMillis();
        FCSLOG.finer(() -> this.name + " updatingFromPDO = " + pdo);
        boolean updated = false;
        if (pdo.getPDOs().containsKey(this.cobid1)) {
            this.pdo1 = (Long)pdo.getPDOs().get(this.cobid1);
            updated = true;
            short socketID1 = this.getSocketId(this.pdo1);
            FCSLOG.finer(() -> this.name + " updatingFromPDO1 = " + this.pdo1 + " binary:" + Long.toBinaryString(this.pdo1));
            if (socketID1 == 0) {
                FCSLOG.finer(() -> this.name + " no socket in STANDBY position");
            } else if (socketID1 == 7) {
                this.raiseAlarm(FcsAlerts.CA_SENSOR_ERROR, " error reading socketID for pdo1");
            } else if (socketID1 >= 1 && socketID1 <= 5) {
                FCSLOG.finer(() -> this.name + " socket at STANDBY position:" + socketID1);
                ((CarouselSensor)this.sensorsMap.get("carousel/socket" + socketID1 + "/ioModuleSensor" + socketID1)).updateValue(1);
                this.updateSocketSensors(socketID1, this.pdo1);
            }
        }
        if (pdo.getPDOs().containsKey(this.cobid2)) {
            this.pdo2 = (Long)pdo.getPDOs().get(this.cobid2);
            updated = true;
            if (this.pdo2 == 0L) {
                this.raiseAlarm(FcsAlerts.CA_SENSOR_ERROR, " pdo2 can't be 0 " + this.toString());
            } else {
                int ioModuleStatus = TTC580Utils.getIOModuleStatus(this.pdo2);
                if (ioModuleStatus != 4) {
                    FCSLOG.finer(() -> this.name + " updatingFromPDO2 = " + this.pdo2 + " binary:" + Long.toBinaryString(this.pdo2));
                    short socketID2 = this.getSocketId(this.pdo2);
                    if (socketID2 == 0) {
                        this.raiseAlarm(FcsAlerts.CA_SENSOR_ERROR, " socketID for pdo2 can't be 0");
                    } else if (socketID2 == 7) {
                        this.raiseAlarm(FcsAlerts.CA_SENSOR_ERROR, " error reading socketID for pdo2");
                    } else if (socketID2 >= 1 && socketID2 <= 5) {
                        ((CarouselSensor)this.sensorsMap.get("carousel/socket" + socketID2 + "/ioModuleSensor" + socketID2)).updateValue(ioModuleStatus);
                        this.updateSocketSensors(socketID2, this.pdo2);
                    }
                } else {
                    FCSLOG.finer(() -> this.name + ", pdo2 " + Long.toBinaryString(this.pdo2) + ": loss of communication with the TTC30s");
                }
            }
        }
        if (pdo.getPDOs().containsKey(this.cobid4)) {
            this.pdo4 = (Long)pdo.getPDOs().get(this.cobid4);
            FCSLOG.finer(() -> this.name + " updateFromPDO pdo4 = " + this.pdo4);
            updated = true;
            if (this.pdo4 == 0L) {
                this.raiseAlarm(FcsAlerts.CA_SENSOR_ERROR, " pdo4 can't be 0 " + this.toString());
            } else {
                this.updatePLCSensors(this.pdo4);
            }
        }
        long duration = System.currentTimeMillis() - beginTime;
        FCSLOG.finer(() -> this.name + " updateFromPDO duration = " + duration);
        if (updated) {
            this.publishData();
        }
    }

    protected void updateSocketSensors(short socketID, long pdoValue) {
        FCSLOG.finer(() -> this.name + " updating socket sensors values for socketID=" + socketID);
        ((CarouselClampSensor)this.sensorsMap.get("carousel/socket" + socketID + "/clampXminus" + socketID + "/lockSensorXminus" + socketID)).updateValue(TTC580Utils.getLockXm(pdoValue));
        ((CarouselClampSensor)this.sensorsMap.get("carousel/socket" + socketID + "/clampXplus" + socketID + "/lockSensorXplus" + socketID)).updateValue(TTC580Utils.getLockXp(pdoValue));
        ((CarouselClampSensor)this.sensorsMap.get("carousel/socket" + socketID + "/clampXminus" + socketID + "/filterPresenceXminus" + socketID)).updateValue(TTC580Utils.getFilterPresenceXm(pdoValue));
        ((CarouselClampSensor)this.sensorsMap.get("carousel/socket" + socketID + "/clampXplus" + socketID + "/filterPresenceXplus" + socketID)).updateValue(TTC580Utils.getFilterPresenceXp(pdoValue));
    }

    private void updatePLCSensors(long pdoValue) {
        this.plcSensorsMap.values().stream().forEach(plcSensor -> plcSensor.updateValue(TTC580Utils.getSensorValue(pdoValue, plcSensor.getByteNumero(), plcSensor.getBitNumero())));
    }

    @Override
    public short getSocketId(long pdo) {
        return (short)(pdo >>> 61);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="read lockSensorMinLocked : lock threshold for all clamps")
    public long readLockSensorMinLocked() {
        return this.readSDO(25604, 5);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="read InternalTemperature : temperature in Celsius from hyttc580 internal thermometer ")
    public double readInternalTemperature() {
        long rawValue = this.readSDO(25604, 1);
        return (double)rawValue / 10.0;
    }

    @Override
    public double readMeanClampsTemperature() {
        long rawValue = this.readSDO(25604, 4);
        return 339.2 - 0.1 * (double)rawValue;
    }

    @Override
    public void checkTTC580Temperatures() {
        double[] socketTemperatures = new double[5];
        for (int i = 0; i < 5; ++i) {
            long rawValue = this.readSDO(12289, i + 1);
            socketTemperatures[i] = (double)rawValue / 10.0;
        }
        double averageClampsTemperature = this.readMeanClampsTemperature();
        double internalTemperature = this.readInternalTemperature();
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.path + "/temperatures", (Serializable)this.createStatusDataPublishedByTTC80TemperatureDevices(socketTemperatures, averageClampsTemperature, internalTemperature)));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="read offset1 (balluff) for clamp presence sensors")
    public long readOffset1SDO(byte socketID) {
        int subindex = Integer.parseInt(String.valueOf(socketID) + "0", 16);
        return this.readSDO(25604, subindex);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="read offset2 (baumer) for clamp lock sensors")
    public long readOffset2SDO(byte socketID) {
        int subindex = Integer.parseInt(String.valueOf(socketID) + "1", 16);
        return this.readSDO(25604, subindex);
    }

    @Override
    public int readSlipRingCurrent() {
        return (int)this.readSDO(25604, 2);
    }

    @Override
    @Deprecated
    @Command(type=Command.CommandType.QUERY, level=1, description="for test and debug")
    public long readInterlocksSDO() {
        int index = 25088;
        int subindex = 1;
        return this.readSDO(index, subindex);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="test and debug")
    public int getOffset1Xplus(byte sid) {
        return TTC580Utils.getOffset1Xplus(this.readOffset1SDO(sid));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="test and debug")
    public int getOffset1Xminus(byte sid) {
        return TTC580Utils.getOffset1Xminus(this.readOffset1SDO(sid));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="test and debug")
    public int getOffset2Xminus(byte sid) {
        return TTC580Utils.getOffset2Xminus(this.readOffset2SDO(sid));
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="test and debug")
    public int getOffset2Xplus(byte sid) {
        return TTC580Utils.getOffset2Xplus(this.readOffset2SDO(sid));
    }

    @Override
    public String displayError(int error) {
        StringBuilder sb = new StringBuilder();
        sb.append("ErrorSource=");
        sb.append(TTC580Utils.getErrorSource(error));
        sb.append("; ErrorType=");
        sb.append(TTC580Utils.getErrorType(error));
        sb.append("; ErrorCounter=");
        sb.append(TTC580Utils.getErrorCounter(error));
        sb.append("; ErrorCode=");
        sb.append(TTC580Utils.getErrorCode(error));
        return sb.toString();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return the string representation of the PDOs")
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\n/pdo1=");
        sb.append(this.pdo1);
        sb.append(", in hexa: 0x");
        sb.append(Long.toHexString(this.pdo1));
        sb.append(", in binary: ");
        sb.append(Long.toBinaryString(this.pdo1));
        sb.append("\n/pdo2=");
        sb.append(this.pdo2);
        sb.append(", in hexa: 0x");
        sb.append(Long.toHexString(this.pdo2));
        sb.append(", in binary: ");
        sb.append(Long.toBinaryString(this.pdo2));
        sb.append(this.printSensorsValues());
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="for tests and debug.")
    public String printSensorsValues() {
        StringBuilder sb = new StringBuilder("\nSensors values read from pdo1:\n");
        if (this.pdo1 == 0L) {
            sb.append("No socket at Standby");
        } else {
            sb.append("Socket at Standby==>");
            sb.append(this.printSensorsForPdo(this.pdo1));
        }
        sb.append("\nSensors values read from pdo2:\n");
        sb.append("Socket not at Standby==>");
        sb.append(this.printSensorsForPdo(this.pdo2));
        return sb.toString();
    }

    private String printSensorsForPdo(long pdo) {
        StringBuilder sb = new StringBuilder("\n");
        sb.append("socketID=");
        sb.append(this.getSocketId(pdo));
        sb.append("/lockXminus=");
        sb.append(TTC580Utils.getLockXm(pdo));
        sb.append("/filterPresenceXminus=");
        sb.append(TTC580Utils.getFilterPresenceXm(pdo));
        sb.append("/lockXplus=");
        sb.append(TTC580Utils.getLockXp(pdo));
        sb.append("/filterPresenceXplus=");
        sb.append(TTC580Utils.getFilterPresenceXp(pdo));
        return sb.toString();
    }

    public StatusDataPublishedByHYTTC580 createStatusDataPublishedByHYTTC580() {
        StatusDataPublishedByHYTTC580 status = new StatusDataPublishedByHYTTC580(this.isBooted(), this.isInitialized());
        status.setPdo1(this.pdo1);
        status.setPdo2(this.pdo2);
        status.setPdo4(this.pdo4);
        return status;
    }

    public void publishCarouselSlipRingCurrent() {
        int current = this.readSlipRingCurrent();
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)new StatusDataPublishedByHYTTC580SlipRing(current)));
    }

    public StatusDataPublishedByHYTTC580TemperaturesDevices createStatusDataPublishedByTTC80TemperatureDevices(double[] socketTemperatures, double avgClampTemperature, double internalTemperature) {
        return new StatusDataPublishedByHYTTC580TemperaturesDevices(this.isBooted(), this.isInitialized(), socketTemperatures, avgClampTemperature, internalTemperature);
    }

    private KeyValueData getSensorsData() {
        KeyValueDataList kvdl = new KeyValueDataList();
        this.plcSensorsMap.values().forEach(sensor -> kvdl.addData(sensor.getName(), (Serializable)Integer.valueOf(((CarouselPLCSensor)sensor).getValue())));
        return new KeyValueData(this.getPath() + "/plc", (Serializable)kvdl);
    }

    @Override
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.path, (Serializable)this.createStatusDataPublishedByHYTTC580()));
        this.subs.publishSubsystemDataOnStatusBus(this.getSensorsData());
    }
}

