/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsActions;
import org.lsst.ccs.subsystems.fcs.FcsAlerts;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.ForceSensor;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.LoaderHook;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderHook;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.PersistentCounter;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class LoaderClamp
extends MobileItem
implements MovedByEPOSController,
ControlledBySensors {
    private static final Logger FCSLOG = Logger.getLogger(LoaderClamp.class.getName());
    private final LoaderHook hook1;
    private final LoaderHook hook2;
    private final LoaderHook hook3;
    private final LoaderHook hook4;
    private final ForceSensor forceSensor0;
    private final ForceSensor forceSensor1;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="unclampedStatusSensor")
    private DigitalSensor unclampedStatusSensor;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="underClampedStatusSensor")
    private DigitalSensor underClampedStatusSensor;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="clampedStatusSensor")
    private DigitalSensor clampedStatusSensor;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="overClampedStatusSensor")
    private DigitalSensor overClampedStatusSensor;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final LoaderHook[] hooks;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/hooksController")
    private EPOSController hooksController;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Loader loader;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter="canbus1")
    private BridgeToHardware loaderTcpProxy;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private FcsEnumerations.LockStatus forceStatus;
    @ConfigurationParameter(range="0..50", description="Trigger to know when action clamp is completed. If force sensor voltage is over this limit then action clamp is completed.", units="0.1 Volt", category="loader")
    private volatile int minClampedVoltage = 25;
    @ConfigurationParameter(range="0..100000", description="Timeout : if closing the clamp last more than this amount of time, then the subsystem goes in ERROR.", units="millisecond", category="loader")
    private volatile int timeoutForClosingHooks = 60000;
    @ConfigurationParameter(range="0..100000", description="Timeout : if closing strongly the clamp last more than this amount of time, then the subsystem goes in ERROR.", units="millisecond", category="loader")
    private volatile int timeoutForClampingHooks = 30000;
    @ConfigurationParameter(range="0..180000", description="Timeout : if opening the clamp last more than this amount of time, then the subsystem goes in ERROR.", units="millisecond", category="loader")
    private volatile int timeoutForOpeningHooks = 60000;
    private static final int TIMEOUT_FOR_MOVING_CLAMP = 60000;
    @ConfigurationParameter(range="250000..400000", description="Target encoder absolute value in qc when hooks are CLOSED", units="unitless", category="loader")
    private volatile int absolutePositionToClose = 325000;
    @ConfigurationParameter(range="-40000..0", description="Relative position in qc to unclamp when hooks are CLAMPED", units="unitless", category="loader")
    private volatile int relativePositionToUnclamp = -25000;
    @ConfigurationParameter(range="0..1000", description="Current to clamp hooks", units="mA", category="loader")
    private volatile int currentToClamp = 445;
    @ConfigurationParameter(range="-500..0", description="Current to open hooks", units="mA", category="loader")
    private volatile int currentToOpen = -200;
    @ConfigurationParameter(range="0..500", description="Current to open hooks in homing mode", units="mA", category="loader")
    private volatile int currentThreshold = 300;
    private int positionToReach = 0;
    private volatile boolean homingDone = false;
    private int position;

    public LoaderClamp(LoaderHook hook1, LoaderHook hook2, LoaderHook hook3, LoaderHook hook4, ForceSensor forceSensor0, ForceSensor forceSensor1) {
        this.hook1 = hook1;
        this.hook2 = hook2;
        this.hook3 = hook3;
        this.hook4 = hook4;
        this.hooks = new LoaderHook[]{hook1, hook2, hook3, hook4};
        this.forceSensor0 = forceSensor0;
        this.forceSensor1 = forceSensor1;
    }

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByLoaderClamp.class, this.path);
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByLoaderHook.class, this.path + "/statusPublishedByHook1");
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByLoaderHook.class, this.path + "/statusPublishedByHook2");
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByLoaderHook.class, this.path + "/statusPublishedByHook3");
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByLoaderHook.class, this.path + "/statusPublishedByHook4");
        this.movementCounter = new EnumMap(FcsActions.MobileItemAction.class);
        for (FcsActions.MobileItemAction action : new FcsActions.MobileItemAction[]{FcsActions.MobileItemAction.CLOSE_LOADER_HOOKS, FcsActions.MobileItemAction.CLAMP_LOADER_HOOKS, FcsActions.MobileItemAction.OPEN_HOMING_LOADER_HOOKS, FcsActions.MobileItemAction.UNCLAMP_LOADER_HOOKS}) {
            action.registerDurationPerElement(this.dataProviderDictionaryService, this.path);
            this.movementCounter.put(action, PersistentCounter.newCounter(action.getCounterPath(this.path), this.subs, action.name()));
        }
    }

    public void init() {
        super.init();
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsAlerts.HARDWARE_ERROR.getAlert(), alwaysClear);
        this.alertService.registerAlert(FcsAlerts.SDO_ERROR.getAlert(this.name), alwaysClear);
        this.alertService.registerAlert(FcsAlerts.LO_SENSOR_ERROR.getAlert(), alwaysClear);
    }

    @Override
    public EPOSController getController() {
        return this.hooksController;
    }

    public int getRelativePositionToClose() {
        return this.absolutePositionToClose;
    }

    public int getRelativePositionToUnclamp() {
        return this.relativePositionToUnclamp;
    }

    public int getCurrentToClamp() {
        return this.currentToClamp;
    }

    public int getCurrentToOpen() {
        return this.currentToOpen;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Display position for end user.Do not read again controller.")
    public int getPosition() {
        return this.position;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if homing of loader clamp has been done.")
    public boolean isHomingDone() {
        return this.homingDone;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if Loader hooks are CLOSED")
    public boolean isClosed() {
        return this.lockStatus == FcsEnumerations.LockStatus.CLOSED;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if Loader hooks are OPENED")
    public boolean isOpened() {
        return this.lockStatus == FcsEnumerations.LockStatus.OPENED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the hooks are CLAMPED on filter")
    public boolean isClamped() {
        this.updateForceStatus();
        return this.forceStatus == FcsEnumerations.LockStatus.CLAMPED;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if Loader hooks are in ERROR.")
    public boolean isInError() {
        return this.lockStatus == FcsEnumerations.LockStatus.ERROR;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if Loader forces sensor are higher than minClampedVoltage.")
    public boolean hasClampEnoughForce() {
        return Math.min(this.forceSensor0.getVoltage(), this.forceSensor1.getVoltage()) >= this.minClampedVoltage;
    }

    @Override
    public boolean myDevicesReady() {
        return this.loaderTcpProxy.allDevicesBooted();
    }

    public void postStart() {
        FCSLOG.info(this.name + " postStart");
        if (this.hooksController.isBooted()) {
            this.initializeController();
        }
    }

    public void initializeController() {
        try {
            this.hooksController.initializeAndCheckHardware();
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsAlerts.HARDWARE_ERROR, " could not initialize loader clamp controller", (Exception)((Object)ex));
        }
    }

    public void checkInitialized() {
        if (!this.hooksController.isInitialized()) {
            String msg = this.getName() + ": clamp is not initialized.";
            FCSLOG.severe(msg);
            throw new RejectedCommandException(msg);
        }
    }

    public void checkClamped() {
        if (!this.isClamped()) {
            throw new RejectedCommandException(this.name + " has to be CLAMPED");
        }
    }

    public void checkUnclamped() {
        if (this.isClamped()) {
            throw new RejectedCommandException(this.name + " has to be UNCLAMPED");
        }
    }

    public void checkClosed() {
        if (!this.isClosed()) {
            throw new RejectedCommandException(this.name + " has to be CLOSED");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Open loader hooks and do homing with method Current Threshold Negative Speed.", timeout=60000)
    public void open() {
        this.loader.updateStateAndCheckSensors();
        this.loader.checkConditionsForOpeningHooks();
        this.executeAction(FcsActions.MobileItemAction.OPEN_HOMING_LOADER_HOOKS, this.timeoutForOpeningHooks);
        this.homingDone = true;
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Close loader hooks. Do a homing BEFORE the close action when at HANDOFF and autochanger holding filter.", timeout=60000)
    public void close() {
        this.loader.updateStateAndCheckSensors();
        this.loader.checkLoaderNotEmpty();
        switch (this.lockStatus) {
            case CLOSED: {
                FCSLOG.info(this.getName() + " already CLOSED. Nothing to do.");
                break;
            }
            case OPENED: 
            case INTRAVEL: 
            case UNKNOWN: {
                this.doHomingIfPossible();
                if (!this.isHomingDone()) {
                    throw new RejectedCommandException(this.getName() + " abort close action because homing could not be done.");
                }
                this.positionToReach = this.absolutePositionToClose;
                this.executeAction(FcsActions.MobileItemAction.CLOSE_LOADER_HOOKS, this.timeoutForClosingHooks);
                break;
            }
            default: {
                throw new RejectedCommandException(this.getName() + " has to be OPENED or IN_TRAVEL or UNKNOWN before a close action. Current lockStatus: " + this.lockStatus.name());
            }
        }
    }

    private void doHomingIfPossible() {
        if (this.loader.isAtHandoff() && this.loader.isAutochangerHoldingFilter()) {
            FCSLOG.info(this.name + " loader at HANDOFF; filter held by autochanger; about to do a homing before a close action.");
            this.open();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Clamp to hold tightly a filter.", timeout=60000)
    public void clamp() {
        this.loader.updateStateAndCheckSensors();
        switch (this.lockStatus) {
            case CLAMPED: {
                FCSLOG.info(this.getName() + " is already CLAMPED. Nothing to do.");
                break;
            }
            case CLOSED: {
                this.loader.checkLoaderNotEmpty();
                this.loader.checkConditionsForClampingHooks();
                this.executeAction(FcsActions.MobileItemAction.CLAMP_LOADER_HOOKS, this.timeoutForClampingHooks);
                this.afterActionClamp();
                break;
            }
            default: {
                throw new RejectedCommandException(this.getName() + " has to be CLOSED before a clamp action. Current lockStatus: " + this.lockStatus.name());
            }
        }
    }

    private void afterActionClamp() {
        if (this.overClampedStatusSensor.isOn()) {
            String msg = " force sensor value is higher than max force limit.";
            this.raiseAlarm(FcsAlerts.HARDWARE_ERROR, msg);
            throw new FcsHardwareException(this.name + msg);
        }
        this.loader.updateFCSStateToReady();
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="When the loader has a filter between ENGAGED and STORAGE and the force status of the hooks is UNCLAMPED, this recovery method should be used to get back to CLAMPED state and continue with NORMAL commands.", timeout=60000)
    public void recoveryClamp() {
        this.loader.updateStateAndCheckSensors();
        if (this.lockStatus != FcsEnumerations.LockStatus.CLOSED || this.forceStatus != FcsEnumerations.LockStatus.UNCLAMPED) {
            throw new RejectedCommandException(this.getName() + " to start the recoveryClamp the loader hooks should be CLOSED and the forceStatus UNCLAMPED. Currently lockStatus=" + this.lockStatus.name() + " forceStatus=" + this.forceStatus.name());
        }
        this.loader.checkLoaderNotEmpty();
        this.loader.checkCarrierConditionsForRecoveryClampingHooks();
        this.executeAction(FcsActions.MobileItemAction.CLAMP_LOADER_HOOKS, this.timeoutForClampingHooks);
        this.afterActionClamp();
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Unclamp filter and return to CLOSED position.", timeout=60000)
    public void unclamp() {
        this.loader.updateStateAndCheckSensors();
        switch (this.lockStatus) {
            case CLOSED: {
                FCSLOG.info(this.getName() + " is already CLOSED. Nothing to do.");
                break;
            }
            case CLAMPED: {
                this.loader.checkLoaderNotEmpty();
                this.loader.checkConditionsForUnclampingHooks();
                this.positionToReach = this.position + this.relativePositionToUnclamp;
                String msg = String.format("Loader hooks unclamping info: position=%d, relativePositionToUnclamp=%d, positionToReach=%d", this.position, this.relativePositionToUnclamp, this.positionToReach);
                FCSLOG.info(msg);
                this.executeAction(FcsActions.MobileItemAction.UNCLAMP_LOADER_HOOKS, this.timeoutForClampingHooks);
                break;
            }
            default: {
                throw new RejectedCommandException(this.getName() + " has to be CLAMPED before an unclamp action. Current lockStatus: " + this.lockStatus.name());
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="When the loader has a filter between ENGAGED and STORAGE and the force status of the hooks is UNDER_CLAMPED or OVER_CLAMPED, this recovery method should be used to get back to UNCLAMPED. It can be followed by recoveryClamp to get back to CLAMPED state.", timeout=60000)
    public void recoveryUnclamp() {
        this.loader.updateStateAndCheckSensors();
        if (this.lockStatus != FcsEnumerations.LockStatus.CLOSED || this.forceStatus == FcsEnumerations.LockStatus.UNCLAMPED) {
            throw new RejectedCommandException(this.getName() + " to start the recoveryUnclamp the loader hooks should be CLOSED and the forceStatus different from UNCLAMPED. Currently lockStatus=" + this.lockStatus.name() + " forceStatus=" + this.forceStatus.name());
        }
        this.loader.checkLoaderNotEmpty();
        this.loader.checkCarrierConditionsForRecoveryClampingHooks();
        this.positionToReach = this.position + this.relativePositionToUnclamp;
        String infomsg = String.format("Starting loader recoveryUnclamping. Loader hooks position=%d | relativePositionToUnclamp=%d | positionToReach=%d", this.position, this.relativePositionToUnclamp, this.positionToReach);
        FCSLOG.info(infomsg);
        this.executeAction(FcsActions.MobileItemAction.UNCLAMP_LOADER_HOOKS, this.timeoutForClampingHooks);
    }

    @Override
    public boolean isActionCompleted(FcsActions.MobileItemAction action) {
        boolean actionCompleted = false;
        switch (action) {
            case OPEN_HOMING_LOADER_HOOKS: {
                actionCompleted = this.hooksController.isTargetReached() && this.isOpened();
                break;
            }
            case CLOSE_LOADER_HOOKS: {
                FCSLOG.info(this.name + " position = " + this.position);
                actionCompleted = this.hooksController.isTargetReached() && this.isPositionReached(this.positionToReach) && this.isClosed();
                break;
            }
            case CLAMP_LOADER_HOOKS: {
                actionCompleted = this.clampedStatusSensor.isOn() && this.forceSensor0.getVoltage() >= this.minClampedVoltage && this.forceSensor1.getVoltage() >= this.minClampedVoltage;
                break;
            }
            case UNCLAMP_LOADER_HOOKS: {
                actionCompleted = this.isPositionReached(this.positionToReach) && !this.clampedStatusSensor.isOn() && this.hooksController.isTargetReached();
                break;
            }
        }
        return actionCompleted;
    }

    private boolean isPositionReached(int positionToReach) {
        int delta_position = 5;
        FCSLOG.finer(() -> "position=" + this.position + " positionToReach=" + positionToReach);
        return positionToReach - delta_position <= this.position && this.position <= positionToReach + delta_position;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.hooksController.checkFault();
            this.loader.updateStateWithSensors();
        }
        catch (SDORequestException ex) {
            this.raiseWarning(FcsAlerts.SDO_ERROR, "error in updateStateWithSensorsToCheckIfActionIsCompleted: ", this.name, (Exception)((Object)ex));
        }
    }

    @Override
    public void startAction(FcsActions.MobileItemAction action) {
        this.hooksController.checkFault();
        switch (action) {
            case OPEN_HOMING_LOADER_HOOKS: {
                this.hooksController.changeMode(EPOSEnumerations.EposMode.HOMING);
                this.hooksController.writeParameter(EPOSEnumerations.EposParameter.CurrentThresholdHomingMode, this.currentThreshold);
                this.hooksController.writeParameter(EPOSEnumerations.EposParameter.HomingMethod, -4);
                this.hooksController.goToOperationEnable();
                this.hooksController.writeControlWord(EPOSEnumerations.ControlWord.ABSOLUTE_POSITION);
                break;
            }
            case CLOSE_LOADER_HOOKS: {
                this.hooksController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                this.hooksController.enableAndWriteAbsolutePosition(this.absolutePositionToClose);
                break;
            }
            case CLAMP_LOADER_HOOKS: {
                this.hooksController.changeMode(EPOSEnumerations.EposMode.CURRENT);
                this.hooksController.enableAndWriteCurrent((short)this.currentToClamp);
                break;
            }
            case UNCLAMP_LOADER_HOOKS: {
                this.hooksController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
                this.hooksController.enableAndWriteRelativePosition(this.relativePositionToUnclamp);
                break;
            }
        }
    }

    @Override
    public void abortAction(FcsActions.MobileItemAction action, long delay) {
        FCSLOG.finer(() -> this.name + " is ABORTING action " + action.toString() + " within delay " + delay);
        this.hooksController.quickStop();
        this.hooksController.goToSwitchOnDisabled();
    }

    @Override
    public void endAction(FcsActions.MobileItemAction action) {
        FCSLOG.finer(() -> this.name + " is ENDING action " + action.toString());
        this.hooksController.goToSwitchOnDisabled();
        this.publishData();
        this.loader.updateFCSStateToReady();
    }

    @Override
    public void quickStopAction(FcsActions.MobileItemAction action, long delay) {
        FCSLOG.finer(() -> this.name + " is STOPPING action " + action.toString() + " within delay " + delay);
        this.hooksController.quickStop();
    }

    public void updateStateAndCheckSensors() {
        this.loader.updateStateWithSensors();
        this.checkSensors(FcsAlerts.LO_SENSOR_ERROR, this.name);
    }

    void updateState() {
        this.updatePosition();
        this.updateForceStatus();
        this.updateLockStatus();
        this.publishData();
    }

    private boolean oneHookInError() {
        return Arrays.stream(this.hooks).anyMatch(hook -> hook.getLockStatus() == FcsEnumerations.LockStatus.ERROR);
    }

    private boolean allHooksInState(FcsEnumerations.LockStatus status) {
        return Arrays.stream(this.hooks).allMatch(hook -> hook.getLockStatus() == status);
    }

    private void updateLockStatus() {
        for (LoaderHook hook : this.hooks) {
            hook.updateState();
        }
        if (this.oneHookInError()) {
            this.lockStatus = FcsEnumerations.LockStatus.ERROR;
        } else if (this.allHooksInState(FcsEnumerations.LockStatus.OPENED)) {
            this.computeStatusHooksOpened();
        } else {
            this.lockStatus = this.allHooksInState(FcsEnumerations.LockStatus.CLOSED) ? (this.clampedStatusSensor.isOn() ? FcsEnumerations.LockStatus.CLAMPED : FcsEnumerations.LockStatus.CLOSED) : (this.allHooksInState(FcsEnumerations.LockStatus.INTRAVEL) ? FcsEnumerations.LockStatus.INTRAVEL : FcsEnumerations.LockStatus.UNKNOWN);
        }
    }

    private void updateForceStatus() {
        this.forceStatus = this.unclampedStatusSensor.isOn() ? FcsEnumerations.LockStatus.UNCLAMPED : (this.underClampedStatusSensor.isOn() ? FcsEnumerations.LockStatus.UNDER_CLAMPED : (this.overClampedStatusSensor.isOn() ? FcsEnumerations.LockStatus.OVER_CLAMPED : (this.clampedStatusSensor.isOn() ? FcsEnumerations.LockStatus.CLAMPED : FcsEnumerations.LockStatus.ERROR)));
    }

    private void computeStatusHooksOpened() {
        switch (this.forceStatus) {
            case UNCLAMPED: {
                this.lockStatus = FcsEnumerations.LockStatus.OPENED;
                break;
            }
            case CLAMPED: 
            case OVER_CLAMPED: {
                this.lockStatus = FcsEnumerations.LockStatus.ERROR;
                break;
            }
            default: {
                this.lockStatus = this.forceStatus;
            }
        }
    }

    public void updatePosition() {
        try {
            this.position = this.hooksController.readPosition();
        }
        catch (SDORequestException ex) {
            FCSLOG.log(Level.WARNING, this.name + "=> ERROR IN READING CONTROLLER:", ex);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Update and display clamp position from the controller.")
    public int readPosition() {
        this.updatePosition();
        return this.position;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return a printed list of hardware with initialization information.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.name);
        if (this.homingDone) {
            sb.append(" homing is DONE.");
        } else {
            sb.append(" homing is NOT DONE.");
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="List and display Loader clamp information.")
    public synchronized String toString() {
        this.updateState();
        this.updatePosition();
        StringBuilder sb = new StringBuilder("= " + this.name + " =");
        sb.append("Position: ").append(this.position).append("\n");
        sb.append("Homing done: ").append(this.homingDone).append("\n");
        sb.append("LockStatus: ").append(this.lockStatus.name()).append("\n");
        sb.append("+ hook1: ").append(this.hook1.getLockStatus().name()).append("\n");
        sb.append("+ hook2: ").append(this.hook2.getLockStatus().name()).append("\n");
        sb.append("+ hook3: ").append(this.hook3.getLockStatus().name()).append("\n");
        sb.append("+ hook4: ").append(this.hook4.getLockStatus().name()).append("\n");
        sb.append("~~~").append("\n");
        sb.append("ForceStatus: ").append(this.forceStatus.name()).append("\n");
        sb.append("+ force sensor 0 (mv): ").append(this.forceSensor0.getVoltage()).append("\n");
        sb.append("+ force sensor 1 (mv): ").append(this.forceSensor1.getVoltage()).append("\n");
        sb.append("~~~").append("\n");
        return sb.toString();
    }

    public StatusDataPublishedByLoaderClamp createStatusDataPublishedByLoaderClamp() {
        StatusDataPublishedByLoaderClamp status = new StatusDataPublishedByLoaderClamp();
        status.setClampState(this.lockStatus);
        status.setForceSensorVoltage0(this.forceSensor0.getVoltage());
        status.setForceSensorVoltage1(this.forceSensor1.getVoltage());
        status.setForceClampedStatus(this.clampedStatusSensor.isOn());
        status.setForceUnclampedStatus(this.unclampedStatusSensor.isOn());
        status.setForceUnderClampedStatus(this.underClampedStatusSensor.isOn());
        status.setForceOverClampedStatus(this.overClampedStatusSensor.isOn());
        status.setAllHooksInStateCLOSED(this.allHooksInState(FcsEnumerations.LockStatus.CLOSED));
        status.setForceStatus(this.forceStatus);
        status.setHomingDone(this.homingDone);
        status.setControllerInError(this.hooksController.isInError());
        status.setStatusPublishedByHook1(this.hook1.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook2(this.hook2.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook3(this.hook3.createStatusDataPublishedByLoaderHook());
        status.setStatusPublishedByHook4(this.hook4.createStatusDataPublishedByLoaderHook());
        return status;
    }

    @Override
    public void publishData() {
        KeyValueData kvd = new KeyValueData(this.path, (Serializable)this.createStatusDataPublishedByLoaderClamp());
        this.subs.publishSubsystemDataOnStatusBus(kvd);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.hooksController.isBooted()) {
            this.hooksController.goToSwitchOnDisabled();
        }
        FCSLOG.info(this.name + " is shutdown.");
    }
}

