/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.AutochangerThreeOnlineClamps;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FcsActions;
import org.lsst.ccs.subsystems.fcs.FcsAlerts;
import org.lsst.ccs.subsystems.fcs.FilterIdentificator;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerSeneca;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.PersistentCounter;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSeneca4RTD;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.states.AutochangerInclinationState;
import org.lsst.ccs.subsystems.fcs.states.AutochangerTrucksState;
import org.lsst.ccs.subsystems.fcs.states.ObservatoryFilterState;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class Autochanger
implements FilterHolder,
AlertRaiser,
HasLifecycle {
    private static final Logger FCSLOG = Logger.getLogger(Autochanger.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configurationService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected DataProviderDictionaryService dataProviderDictionaryService;
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="canbus0")
    private BridgeToHardware tcpProxy;
    private final PlutoGatewayInterface plutoGateway;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="filterManager")
    private FilterManager filterManager;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter="filterIdentificator")
    protected FilterIdentificator filterIdentificator;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="autochangerTrucks")
    private AutochangerTwoTrucks autochangerTrucks;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="latches")
    protected AutochangerTwoLatches latches;
    @LookupField(strategy=LookupField.Strategy.CHILDREN, pathFilter="onlineClamps")
    private AutochangerThreeOnlineClamps onlineClamps;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule main;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/tempSensorsDevice1")
    private CanOpenSeneca4RTD tempSensorsDevice1;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/tempSensorsDevice2")
    private CanOpenSeneca4RTD tempSensorsDevice2;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter=".*carousel")
    private FilterHolder carousel;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS, pathFilter=".*loader")
    private FilterHolder loader;
    @ConfigurationParameter(range="0..5000", description="Time to wait until protection system signals are updated", units="millisecond", category="autochanger")
    public volatile long timeToUpdateProtectionSystem = 2000L;
    @ConfigurationParameter(range="0..100", description="Time to wait between activateBrake and disableOperation for online clamps", units="millisecond", category="autochanger")
    private volatile int waitTimeForBrakeOC = 20;
    @ConfigurationParameter(range="0..100", description="Time to wait between activateBrake and disableOperation for linear rails", units="millisecond", category="autochanger")
    private volatile int waitTimeForBrakeLR = 20;
    @Persist
    protected volatile int filterOnTrucksID;
    @Persist
    private volatile boolean available = true;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS, pathFilter=".*\\/carouselStoppedAtStandbySensors")
    private ComplementarySensors carouselStoppedAtStandbySensors;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS, pathFilter=".*\\/loaderPresenceSensors")
    private ComplementarySensors loaderPresenceSensors;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS, pathFilter=".*\\/lpmLinearRail1Status")
    private DigitalSensor lpmLinearRail1Status;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS, pathFilter=".*\\/lpmLinearRail2Status")
    private DigitalSensor lpmLinearRail2Status;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS, pathFilter=".*\\/lpmOnlineClampsStatus")
    private DigitalSensor lpmOnlineClampsStatus;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS, pathFilter=".*\\/lpmLatchesStatus")
    private DigitalSensor lpmLatchesStatus;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS, pathFilter=".*\\/OUT_AIN")
    private DigitalSensor AIN;
    private PersistentCounter grabFilterAtStandbyCounter;
    private PersistentCounter moveAndClampFilterOnlineCounter;
    private String subsystemIdentifier = "";
    private double[] temperatures = new double[8];
    private AtomicLong lastUpdateStateWithSensors = new AtomicLong(0L);

    public Autochanger(PlutoGatewayInterface plutoGateway) {
        this.plutoGateway = plutoGateway;
    }

    @Override
    public Subsystem getSubsystem() {
        return this.subs;
    }

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    public BridgeToHardware getTcpProxy() {
        return this.tcpProxy;
    }

    public int getWaitTimeForBrakeOC() {
        return this.waitTimeForBrakeOC;
    }

    public int getWaitTimeForBrakeLR() {
        return this.waitTimeForBrakeLR;
    }

    public AutochangerInclinationState getAutochangerInclinationState() {
        if (this.AIN.isOn()) {
            return AutochangerInclinationState.STRAIGHT;
        }
        return AutochangerInclinationState.TILTED;
    }

    public AutochangerTrucksState getAutochangerTrucksState() {
        if (this.isAtHandoff()) {
            return AutochangerTrucksState.HANDOFF;
        }
        if (this.isAtOnline()) {
            return AutochangerTrucksState.ONLINE;
        }
        if (this.isAtStandby()) {
            return AutochangerTrucksState.STANDBY;
        }
        return AutochangerTrucksState.IN_TRAVEL;
    }

    public int getOnlineProximityDistance() {
        return this.autochangerTrucks.getOnlineProximityDistance();
    }

    public void build() {
        this.dataProviderDictionaryService.registerClass(StatusDataPublishedByAutochangerSeneca.class, this.name + "/temperatures");
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("PublishAutochangerTemperatures", this::publishSenecaTemperatures).withIsFixedRate(true).withPeriod(Duration.ofMinutes(10L)));
        this.plutoGateway.registerSubsystemIdentifier(this.name);
        this.grabFilterAtStandbyCounter = PersistentCounter.newCounter(FcsActions.GeneralAction.GRAB_FILTER_AT_STANDBY.getCounterPath(), this.getSubsystem(), FcsActions.GeneralAction.GRAB_FILTER_AT_STANDBY.name());
        this.moveAndClampFilterOnlineCounter = PersistentCounter.newCounter(FcsActions.GeneralAction.MOVE_AND_CLAMP_FILTER_ONLINE.getCounterPath(), this.getSubsystem(), FcsActions.GeneralAction.MOVE_AND_CLAMP_FILTER_ONLINE.name());
        FcsActions.GeneralAction.GRAB_FILTER_AT_STANDBY.registerDurationTopLevel(this.dataProviderDictionaryService);
        FcsActions.GeneralAction.MOVE_AND_CLAMP_FILTER_ONLINE.registerDurationTopLevel(this.dataProviderDictionaryService);
    }

    public void init() {
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(FcsAlerts.HARDWARE_ERROR.getAlert(), alwaysClear);
        this.alertService.registerAlert(FcsAlerts.HARDWARE_ERROR.getAlert(this.plutoGateway.getName()), alwaysClear);
        this.alertService.registerAlert(FcsAlerts.AC_SENSOR_ERROR.getAlert(), alwaysClear);
        this.alertService.registerAlert(FcsAlerts.AC_SENSOR_ERROR.getAlert(this.name), alwaysClear);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if an error has been detected on sensors.")
    public boolean isSensorsInError() {
        return this.latches.isInError() || this.onlineClamps.isInError() || this.autochangerTrucks.isPositionSensorsInError();
    }

    public AutochangerTwoTrucks getAutochangerTrucks() {
        return this.autochangerTrucks;
    }

    public AutochangerThreeOnlineClamps getOnlineClamps() {
        return this.onlineClamps;
    }

    public AutochangerTwoLatches getLatches() {
        return this.latches;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return the subsystem identifier autochanger1, 2 or PROTO")
    public String getIdentifier() {
        return this.subsystemIdentifier;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="If autochanger holds a filter, return filterID, else return 0.")
    public int getFilterID() {
        return this.filterOnTrucksID;
    }

    public void setFilterOnTrucksID(int filterOnTrucksID) {
        int formerFilterOnTrucksID = this.filterOnTrucksID;
        if (formerFilterOnTrucksID != filterOnTrucksID) {
            this.filterOnTrucksID = filterOnTrucksID;
            this.subs.getAgentPersistenceService().persistNow();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return true if filter with filterID is on autochanger")
    public boolean isFilterOnTrucks(int filterID) {
        return this.filterOnTrucksID == filterID && this.filterOnTrucksID != 0;
    }

    public boolean isFilterOnline() {
        return this.isAtOnline() && this.isHoldingFilter();
    }

    public boolean isFilterOnline(int filterID) {
        return this.isFilterOnline() && this.isFilterOnTrucks(filterID);
    }

    public boolean isFilterClampedOnline() {
        return this.isFilterOnline() && this.onlineClamps.isLocked();
    }

    public boolean isFilterClampedOnline(int filterID) {
        return this.isFilterOnline(filterID) && this.onlineClamps.isLocked();
    }

    public boolean isEmptyOnline() {
        return this.isEmpty() && this.isAtOnline();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Name of filter in autochanger, or NONE if no filter")
    public String getFilterOnTrucksName() {
        return this.filterManager.getFilterNameByID(this.filterOnTrucksID);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Name of filter in autochanger, or NONE if no filter")
    public String getFilterOnTrucksObservatoryName() {
        return this.filterManager.getObservatoryNameByID(this.filterOnTrucksID);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Delta autochanger standby position, or 0 if no filter")
    public int getFilterOnTrucksDeltaAutochangerStandbyPosition() {
        return this.filterManager.getFilterByID(this.filterOnTrucksID).getDeltaAutochangerStandbyPosition();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected to the camera. This command doesn't read again the sensors.")
    public boolean isLoaderConnected() {
        return this.loaderPresenceSensors.isOn() && !this.loaderPresenceSensors.isInError();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carousel is holding the filter at STANDBY position.")
    public boolean isCarouselHoldingFilterAtStandby() {
        return this.carousel.isAtStandby() && this.carousel.isHoldingFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if loader is holding a filter. This command doesn't read again the sensors.")
    public boolean isLoaderHoldingFilterAtHandoff() {
        return this.loader.isHoldingFilter();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all autochanger CANopen devices are booted, identified and initialized.")
    public boolean isCANDevicesReady() {
        return this.tcpProxy.allDevicesBooted();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all autochanger CANopen devices are booted, identified and initialized and homing of the controllers is done.")
    public boolean isHardwareReady() {
        return this.tcpProxy.allDevicesBooted() && this.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the autochanger is ready to use or false if not.")
    public boolean isAvailable() {
        return this.available;
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Flag autochanger as unavailable if false or available if true. If available is false, this command should be used to return to 'available' only after FES engineers have been consulted.")
    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Flag the autochanger as NOT READY TO USE. This cancels all possible filter changes until further notice and will freeze the FES in its current state, either with a filter ONLINE or no filters at all. All filters but one should therefore disappear from the list of available filters. This is a protective command that can do no harm but will give some time to FES experts to review the status of the autochanger before deciding to reactivate it.")
    public void setUnavailable() {
        this.setAvailable(false);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if all autochanger hardware is initialized.")
    public boolean isInitialized() {
        return this.plutoGateway.isInitialized() && this.autochangerTrucks.isInitialized() && this.latches.isInitialized() && this.onlineClamps.isInitialized();
    }

    public boolean isLinearRailMotionAllowed() {
        return this.lpmLinearRail1Status.isOn() && this.lpmLinearRail2Status.isOn();
    }

    public void waitForProtectionSystemUpdate() {
        this.waitForRailMotionAllowed(this.timeToUpdateProtectionSystem);
    }

    private void waitForRailMotionAllowed(long timeout) {
        String methodName = "waitForRailMotionAllowed";
        String className = Autochanger.class.getName();
        FCSLOG.entering(className, "waitForRailMotionAllowed", timeout);
        FcsUtils.waitCondition(() -> this.isLinearRailMotionAllowed(), () -> this.plutoGateway.updateValues(), className, timeout);
        FcsUtils.sleep(10, className);
        if (!this.isLinearRailMotionAllowed()) {
            FCSLOG.finer("Attention: isLinearRailMotionAllowed glitch 10ms , waiting again");
        }
        FcsUtils.sleep(50, className);
        if (!this.isLinearRailMotionAllowed()) {
            FCSLOG.finer("Attention: isLinearRailMotionAllowed glitch 60ms, waiting again");
        }
        FcsUtils.waitCondition(() -> this.isLinearRailMotionAllowed(), () -> this.plutoGateway.updateValues(), "waitForRailMotionAllowed", timeout);
        FCSLOG.exiting(Autochanger.class.getName(), "waitForRailMotionAllowed");
    }

    public void postStart() {
        String methodName = "postStart";
        FCSLOG.entering(Autochanger.class.getName(), "postStart");
        if (this.plutoGateway.isBooted()) {
            this.initializeGateway();
            try {
                this.updateStateWithSensors();
            }
            catch (Exception ex) {
                this.raiseAlarm(FcsAlerts.HARDWARE_ERROR, this.name + " couldn't updateStateWithSensors in postStart ", ex);
            }
        } else {
            this.plutoGateway.raiseAlarmIfMissing();
        }
        this.subsystemIdentifier = this.plutoGateway.getSubsystemIdentifier();
        this.plutoGateway.publishSubsystemIdentifier();
        if (this.tempSensorsDevice1.isBooted()) {
            if (this.subsystemIdentifier == "autochanger1" || this.subsystemIdentifier == "autochanger2") {
                this.tempSensorsDevice2.patchPT100(2);
            }
            this.checkSenecaTemperatures();
        }
        FCSLOG.exiting(Autochanger.class.getName(), "postStart");
    }

    private void initializeGateway() {
        try {
            this.plutoGateway.initializeAndCheckHardware();
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsAlerts.HARDWARE_ERROR, this.name + " couldn't initialize gateway", this.plutoGateway.getName(), (Exception)((Object)ex));
        }
    }

    @Command(type=Command.CommandType.QUERY, level=2, description="For end users, for tests and in engineering mode. This command can be used to recover after a missing hardware during fcs startup. For example, when fcs was started before hardware power up. Check all hardware and publish data.", timeout=5000)
    public void initializeHardware() {
        FCSLOG.info(this.name + " BEGIN initializeHardware");
        this.tcpProxy.bootProcess();
        try {
            this.postStart();
            this.autochangerTrucks.postStart();
            this.onlineClamps.postStart();
            this.latches.postStart();
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsAlerts.HARDWARE_ERROR, " couldn't initialize autochanger", (Exception)((Object)ex));
        }
        FCSLOG.info(this.name + " END initializeHardware");
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if Local Protection Module allows linear rails motion.")
    public void checkLinearRailMotionAllowed() {
        FcsUtils.checkAndWaitCondition(() -> this.lpmLinearRail1Status.isOn() && this.lpmLinearRail2Status.isOn(), () -> this.plutoGateway.updateValues(), "checkLinearRailMotionAllowed", this.name + ": linear rails motion NOT allowed by Local Protection Module.");
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if Local Protection Module allows latches motion.")
    public void checkLatchMotionAllowed() {
        FcsUtils.checkAndWaitCondition(() -> this.lpmLatchesStatus.isOn(), () -> this.plutoGateway.updateValues(), "checkLatchMotionAllowed", this.name + ": latches open or close NOT allowed by Local Protection Module.");
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if Local Protection Module allows online clamps motion.")
    public void checkOnlineClampMotionAllowed() {
        FcsUtils.checkAndWaitCondition(() -> this.lpmOnlineClampsStatus.isOn(), () -> this.plutoGateway.updateValues(), "checkOnlineClampMotionAllowed", this.name + ": Online clamps open or close NOT allowed by Local Protection Module.");
    }

    public void checkConditionsForOpeningLatches(boolean bypassSensorError) {
        FCSLOG.info(this.name + " checking pre-conditions for opening latches");
        this.updateStateWithSensors();
        this.checkLatchesInitialized();
        if (this.latches.isInError() && !bypassSensorError) {
            throw new FcsHardwareException(this.name + ": latches are in ERROR state - can't open latches.");
        }
        if (this.isEmpty()) {
            throw new RejectedCommandException(this.name + ": no filter in autochanger - can't open latches.");
        }
        if (!this.autochangerTrucks.isAtStandby() && !this.autochangerTrucks.isAtHandoff()) {
            throw new RejectedCommandException(this.name + ": autochanger is loaded with a filter but is not at handoff position neither at standby - can't open latches.");
        }
        if (this.autochangerTrucks.isAtStandby()) {
            this.checkConditionsForOpeningLatchesAtStandby();
        } else if (this.autochangerTrucks.isAtHandoff()) {
            this.checkConditionsForOpeningLatchesAtHandoff();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the latches can be opened.")
    public void checkConditionsForOpeningLatches() {
        this.checkConditionsForOpeningLatches(false);
    }

    private void checkLatchesInitialized() {
        if (!this.latches.isInitialized()) {
            throw new RejectedCommandException(this.name + ": latches are not initialized. Please initialize hardware first.");
        }
    }

    private void checkConditionsForOpeningLatchesAtStandby() {
        if (!this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(this.name + ": autochanger is loaded with a filter and is  at STANDBY position but carousel doesn't hold the filter - can't open latches.");
        }
        FCSLOG.info(() -> this.name + " carousel is holding filter at STANDBY => latches can be open safely.");
    }

    private void checkConditionsForOpeningLatchesAtHandoff() {
        if (!this.isLoaderHoldingFilterAtHandoff()) {
            throw new RejectedCommandException(this.name + ": autochanger is loaded with a filter and is  at HANDOFF position but loader doesn't hold the filter - can't open latches.");
        }
        FCSLOG.info(() -> this.name + " loader is holding filter at HANDOFF => latches can be open safely.");
    }

    public void checkConditionsForClosingLatches(boolean bypassSensorError) {
        FCSLOG.info(() -> this.name + " checking conditions for closing latches.");
        this.updateStateWithSensors();
        this.checkLatchesInitialized();
        if (this.latches.isInError() && !bypassSensorError) {
            throw new RejectedCommandException(this.name + ": latches are in ERROR state - can't close latches.");
        }
        if (this.isEmpty()) {
            throw new RejectedCommandException(this.name + ": no filter in autochanger - can't close latches.");
        }
        if (!this.autochangerTrucks.isAtStandby() && !this.autochangerTrucks.isAtHandoff()) {
            throw new RejectedCommandException(this.name + ": autochanger is not at handoff position neither at standby - can't close latches.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if Autochanger latches can be closed.")
    public void checkConditionsForClosingLatches() {
        this.checkConditionsForClosingLatches(false);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Check and log if actions on online clamps are allowed,throws an exception otherwise.")
    public void checkConditionsForActioningOnlineClamps() {
        if (!this.isAtOnline()) {
            throw new RejectedCommandException(this.name + " actions not allowed on ONLINE clamps when trucks are not at ONLINE.");
        }
        if (this.isEmpty()) {
            throw new RejectedCommandException(this.name + " actions not allowed on ONLINE clamps when no filter on trucks.");
        }
        FCSLOG.info(() -> this.name + " autochangerTrucks are at ONLINE, a filter is there : actions are allowed.");
    }

    public void checkConditionsForTrucksMotionWithFilter() {
        FCSLOG.info(this.name + " Checking pre-conditions for moving the trucks with a filter");
        this.updateStateWithSensors();
        if (this.autochangerTrucks.isPositionSensorsInError()) {
            this.handleSensorsError();
        }
        if (!this.isHoldingFilter()) {
            throw new RejectedCommandException(this.name + " This command requires the autochanger to already hold a filter.");
        }
        if (this.isAtStandby() || this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(this.name + " This command cannot be executed when the filter is held at STANDBY by the carousel. First use the disengageFilterFromCarousel command.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if its safe for filters to move autochanger trucks.")
    public void checkFilterSafetyBeforeMotion() {
        String msg = this.name + " can't move trucks because ";
        this.updateStateWithSensors();
        if (this.isSensorsInError()) {
            this.handleSensorsError();
        } else if (this.isEmpty()) {
            FCSLOG.info(() -> this.name + " trucks are empty - can move");
        } else {
            if (!this.onlineClamps.isOpened()) {
                throw new RejectedCommandException(this.name + " : a filter is in trucks and ONLINE clamps are NOT OPENED.");
            }
            if (this.isAtStandby()) {
                this.checkFilterSafetyAtStandby(msg);
            } else if (this.autochangerTrucks.isAtHandoff()) {
                FCSLOG.info(() -> this.name + " : trucks are AT HANDOFF ");
                this.checkFilterSafetyAtHandoff(msg);
            } else if (this.autochangerTrucks.isAtOnline()) {
                FCSLOG.info(() -> this.name + " : trucks are at ONLINE ");
                this.checkFilterSafetyAtOnline(msg);
            } else if (!this.latches.isHoldingFilter() && !this.carousel.isHoldingFilter()) {
                throw new RejectedCommandException(msg + " neither autochanger neither carousel is holding filter. Close latches or carousel clamps.");
            }
        }
    }

    private void checkFilterSafetyAtStandby(String message) {
        if (this.isHoldingFilter() && this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(message + "both carousel and autochanger are holding filter at STANDBY");
        }
        if (!this.isHoldingFilter() && !this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(message + "neither carousel nor autochanger are holding filter at STANDBY");
        }
        if (!this.latches.isClosed() && !this.latches.isOpened()) {
            throw new RejectedCommandException(message + " latches must be opened or closed.");
        }
        FCSLOG.info(() -> this.name + " filter safe at STANDBY - can move");
    }

    private void checkFilterSafetyAtHandoff(String message) {
        if (this.isHoldingFilter() && this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(message + "autochanger is holding filter at HANDOFF but another filter is at STANDBY - can't move trucks");
        }
        if (this.isHoldingFilter() && this.isLoaderHoldingFilterAtHandoff()) {
            throw new RejectedCommandException(message + "both loader and autochanger are holding filter at HANDOFF");
        }
        if (!this.isHoldingFilter() && !this.isLoaderHoldingFilterAtHandoff()) {
            throw new RejectedCommandException(message + "neither loader nor autochanger are holding filter at HANDOFF");
        }
        FCSLOG.info(() -> this.name + " filter safe at HANDOFF - can move");
    }

    private void checkFilterSafetyAtOnline(String message) {
        if (this.isHoldingFilter() && this.isCarouselHoldingFilterAtStandby()) {
            throw new RejectedCommandException(message + "autochanger is holding filter at ONLINE but another filter is at STANDBY - can't move trucks");
        }
        if (this.isHoldingFilter() && !this.onlineClamps.isOpened()) {
            throw new RejectedCommandException(message + "onlineClamps have to be opened on filter at ONLINE - can't move trucks.");
        }
        if (!this.isHoldingFilter() && !this.onlineClamps.isLocked()) {
            throw new RejectedCommandException(message + "neither latches nor onlineClamps are holding filter at ONLINE");
        }
        FCSLOG.info(() -> this.name + " filter safe at ONLINE - can move");
    }

    public void checkCarouselDeltaPosition() {
        if (this.carousel instanceof Carousel) {
            ((Carousel)this.carousel).checkDeltaPosition();
        }
    }

    public void carouselUpdateStandbyState() {
        if (this.carousel instanceof Carousel) {
            ((Carousel)this.carousel).updateSocketAtStandbyState();
        }
    }

    private void handleSensorsError() {
        boolean transientError = false;
        String msg = this.name + " error detected in sensors :";
        if (this.autochangerTrucks.isPositionSensorsInError()) {
            msg = msg + " trucks position sensors";
            transientError = this.autochangerTrucks.isPositionSensorErrorsTransient();
        }
        if (this.latches.isFilterEngagedInError()) {
            boolean bl = transientError = transientError || this.isLatchesErrorTransient();
        }
        if (this.latches.isInError()) {
            msg = msg + " latches sensors";
        }
        if (this.onlineClamps.isInError()) {
            msg = msg + " onlineClamps sensors";
        }
        if (!transientError) {
            this.raiseAlarm(FcsAlerts.AC_SENSOR_ERROR, msg);
            throw new FcsHardwareException(msg);
        }
        this.raiseWarning(FcsAlerts.AC_SENSOR_ERROR, msg + " - can be a transient error. ", this.name);
    }

    private boolean isLatchesErrorTransient() {
        return Math.abs(this.autochangerTrucks.getPosition() - 984000) < 5000;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Update clamp state in reading sensors.")
    public synchronized void updateStateWithSensors() {
        long beginTime = System.currentTimeMillis();
        if (!FcsUtils.isSimu() && beginTime - this.lastUpdateStateWithSensors.get() < 100L) {
            return;
        }
        this.lastUpdateStateWithSensors.set(beginTime);
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateStateWithSensors-ac");){
            this.plutoGateway.checkInitialized();
            this.plutoGateway.updateValues();
            this.tcpProxy.updatePDOData();
            this.updateState();
            this.updateFilterOnTrucksID();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="update filterOnTrucksID.")
    public void updateFilterOnTrucksID() {
        if (!this.latches.isEmpty()) {
            this.setFilterOnTrucksID(this.filterIdentificator.getFilterId());
        } else {
            this.setFilterOnTrucksID(0);
        }
    }

    private void updateState() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("updateState-ac");){
            this.filterIdentificator.retrieveFilterId();
            this.autochangerTrucks.updateState();
            this.latches.updateState();
            this.onlineClamps.updateState();
            if (this.isAtStandby() && this.carouselStoppedAtStandbySensors.isOn()) {
                this.carousel.updateStateWithSensors();
            }
            this.main.updateAgentState(this.getAutochangerInclinationState());
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Force FCS state and FCS readiness state to be ready and publishes on the status bus. TO BE USED ONLY IN EXTREME CASES.")
    public void updateFCSStateToReady() {
        if (this.isCANDevicesReady() && this.latches.isInitialized() && this.autochangerTrucks.isInitialized() && this.onlineClamps.isInitialized()) {
            this.main.updateFCSStateToReady();
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if a filter is in trucks and latches are CLOSED.")
    public boolean isHoldingFilter() {
        return this.latches.isHoldingFilter();
    }

    @Override
    public boolean isNotHoldingFilter() {
        return this.latches.isOpened();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if autochanger trucks are at HANDOFF. This command doesn't read again the sensors.")
    public boolean isAtHandoff() {
        return this.autochangerTrucks.isAtHandoff();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if autochanger trucks are at STANDBY. This command doesn't read again the sensors.")
    public boolean isAtStandby() {
        return this.autochangerTrucks.isAtStandby();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if autochanger trucks are at ONLINE. This command doesn't read again the sensors.")
    public boolean isAtOnline() {
        return this.autochangerTrucks.isAtOnline();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if autochanger trucks position is around approachStandbyPosition. This command doesn't read again the sensors.")
    public boolean isAtApproachStandbyPosition() {
        return Math.abs(this.autochangerTrucks.getPosition() - this.autochangerTrucks.getApproachStandbyPosition()) < 1000;
    }

    public boolean isAtHandoffForLoader() {
        return this.autochangerTrucks.isAtHandoffForLoader();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Handoff position.")
    public void goToHandOff() {
        this.autochangerTrucks.goToHandOff();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Handoff position to prepare an exchange with the loader. The position accuracy requirement is tighter than for command goToHandoff (see positionRangeAtHandoffForLoader and positionRangeAtHandoff).")
    public void goToHandOffForLoader() {
        this.autochangerTrucks.goToHandOffForLoader();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Online position.")
    public void goToOnline() {
        if (this.isAtOnline()) {
            FCSLOG.info(this.name + " filter already at ONLINE.");
            this.main.updateAgentState(ObservatoryFilterState.LOADED);
            return;
        }
        if (this.isHoldingFilter()) {
            this.checkConditionsForTrucksMotionWithFilter();
            this.autochangerTrucks.moveFilterOnlineNoClamping();
            this.main.updateAgentState(ObservatoryFilterState.UNLOADED);
        } else {
            this.main.updateAgentState(ObservatoryFilterState.LOADING);
            this.autochangerTrucks.goToOnline();
            this.main.updateAgentState(ObservatoryFilterState.LOADED);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Standby position.")
    public void goToStandby() {
        this.checkCarouselDeltaPosition();
        this.main.updateAgentState(ObservatoryFilterState.UNLOADED);
        this.autochangerTrucks.goToStandby();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Approach Standby position. Move fast if position > approachStandbyPosition, slow otherwise.")
    public void moveToApproachStandby() {
        this.checkCarouselDeltaPosition();
        if (this.autochangerTrucks.getPosition() > this.autochangerTrucks.getApproachStandbyPosition()) {
            this.autochangerTrucks.moveToApproachStandbyPositionWithLowVelocity();
        } else {
            this.autochangerTrucks.moveToApproachStandbyPositionWithHighVelocity();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, autoAck=false, timeout=20000, description="Move a filter already on autochanger to ONLINE and lock clamps. Cannot start from STANDBY position.")
    public void moveAndClampFilterOnline() {
        if (this.isAtOnline() && this.onlineClamps.isLocked()) {
            FCSLOG.info(this.name + " filter already locked ONLINE.");
            this.main.updateAgentState(ObservatoryFilterState.LOADED);
            return;
        }
        this.checkConditionsForTrucksMotionWithFilter();
        this.moveAndClampFilterOnlineCounter.increment();
        long beginTime = System.currentTimeMillis();
        this.main.updateAgentState(ObservatoryFilterState.LOADING);
        this.autochangerTrucks.moveAndClampFilterOnline();
        FcsActions.GeneralAction.MOVE_AND_CLAMP_FILTER_ONLINE.publishDurationTopLevel(this.subs, System.currentTimeMillis() - beginTime);
        this.main.updateAgentState(ObservatoryFilterState.LOADED);
    }

    @Command(type=Command.CommandType.ACTION, level=1, autoAck=false, timeout=20000, description="Move the autochanger trucks to ONLINE to get ready to take a science image. If a filter is on the trucks, it will be clamped online. Cannot start from STANDBY position.")
    public void moveOnlineForScience() {
        if (this.isAtOnline()) {
            FCSLOG.info(this.name + " filter already at ONLINE.");
            this.main.updateAgentState(ObservatoryFilterState.LOADED);
            return;
        }
        if (this.isHoldingFilter()) {
            if (this.carousel.isHoldingFilter()) {
                String msg = this.name + " movement of the trucks to ONLINE cannot proceed if the filter is held by the carousel";
                msg = msg + "\nFirst disengage the filter from the carousel before trying again.";
                throw new RejectedCommandException(msg);
            }
            this.moveAndClampFilterOnline();
        } else {
            this.goToOnline();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="unlock and open clamps in doing homing if needed, then move slowly to approach online position, then move fast to handoff", autoAck=false, timeout=20000)
    public void unclampAndMoveFilterToHandoff() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("unclampAndMoveFilterToHandoff");){
            this.main.updateAgentState(ObservatoryFilterState.UNLOADED);
            this.autochangerTrucks.unclampAndMoveFilterToHandoff();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="go slowly to approachStandbyPosition ")
    public void moveToApproachStandbyPositionWithLowVelocity() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveToApproachStandbyPositionWithLowVelocity");){
            this.autochangerTrucks.moveToApproachStandbyPositionWithLowVelocity();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="go fast to approachStandbyPosition ")
    public void moveToApproachStandbyPositionWithHighVelocity() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveToApproachStandbyPositionWithHighVelocity");){
            this.autochangerTrucks.moveToApproachStandbyPositionWithHighVelocity();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="go fast to approachOnlinePosition ")
    public void moveToApproachOnlinePositionWithHighVelocity() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveToApproachOnlinePositionWithHighVelocity");){
            this.autochangerTrucks.moveToApproachOnlinePositionWithHighVelocity();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="go slowly to slow motion position ")
    public void moveToSlowMotionPositionWithLowVelocity() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveToSlowMotionPositionWithLowVelocity");){
            this.autochangerTrucks.moveToSlowMotionPositionWithLowVelocity();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="go fast to slow motion position ")
    public void moveToSlowMotionPositionWithHighVelocity() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveToSlowMotionPositionWithHighVelocity");){
            this.autochangerTrucks.moveToSlowMotionPositionWithHighVelocity();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="go slowly to approachOnlinePosition ")
    public void moveToApproachOnlinePositionWithLowVelocity() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveToApproachOnlinePositionWithLowVelocity");){
            this.autochangerTrucks.moveToApproachOnlinePositionWithLowVelocity();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="align follower and move empty from approachStandby to Handoff")
    public void alignFollowerAndMoveEmptyFromApproachToHandoff() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("alignFollowerAndMoveEmptyFromApproachToHandoff");){
            this.autochangerTrucks.alignFollowerAndMoveEmptyFromApproachToHandoff();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="move slowly to standby position")
    public void moveToStandbyWithLowVelocity() {
        if (this.carousel instanceof Carousel) {
            ((Carousel)this.carousel).checkDeltaPosition();
        }
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveToStandbyWithLowVelocity");){
            this.autochangerTrucks.moveToStandbyWithLowVelocity();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="move fast to handoff position")
    public void moveToHandoffWithHighVelocity() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveToHandoffWithHighVelocity");){
            this.autochangerTrucks.moveToHandoffWithHighVelocity();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="move filter to approachPosition with high speed and move to STANDBY with lowSpeed.", autoAck=false, timeout=30000)
    public void moveFilterToStandby() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveFilterToStandby");){
            this.carousel.checkDeltaPosition();
            this.waitForProtectionSystemUpdate();
            this.main.updateAgentState(ObservatoryFilterState.UNLOADING);
            this.autochangerTrucks.moveFilterToStandby();
            this.main.updateAgentState(ObservatoryFilterState.UNLOADED);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="move filter to approachPosition with high speed and move to STANDBY + deltaStandbyPosition with lowSpeed.", autoAck=false, timeout=30000)
    public void moveFilterToStandbyPlusDelta(int deltaStandbyPosition) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveFilterToStandbyPlusDelta");){
            this.carousel.checkDeltaPosition();
            this.waitForProtectionSystemUpdate();
            this.autochangerTrucks.moveFilterToStandbyPlusDelta(deltaStandbyPosition);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move filter to HANDOFF for loader", autoAck=false, timeout=30000)
    public void moveFilterToHandoff() {
        if (this.carousel.isHoldingFilter()) {
            throw new RejectedCommandException(this.name + " this method should never be used when the filter is held by the carousel");
        }
        if (this.isAtHandoffForLoader()) {
            return;
        }
        if (this.isAtHandoff()) {
            this.autochangerTrucks.moveToApproachOnlinePositionWithHighVelocity();
            this.autochangerTrucks.slowProfile();
            this.autochangerTrucks.goToHandOffForLoader();
        } else if (this.isAtOnline()) {
            this.autochangerTrucks.unclampAndMoveFilterToHandoff();
        } else {
            this.autochangerTrucks.fastProfile();
            this.autochangerTrucks.goToHandOffForLoader();
        }
        this.main.updateAgentState(ObservatoryFilterState.UNLOADED);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Align follower controller position to driver controller position.", timeout=20000)
    public void alignFollower() {
        this.autochangerTrucks.alignFollowerStrict();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Align follower controller position to driver controller position to prepare interaction with loader (see configuration parameter in category autochanger : deltaPositionForAlignStrictLoader).", timeout=20000)
    public void alignFollowerForLoader() {
        this.autochangerTrucks.alignFollowerForLoader();
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="change ProfileVelocity parameter to lowSpeed and slowProfileAcceleration and slowProfileDeceleration")
    public void slowTrucksProfile() {
        this.autochangerTrucks.slowProfile();
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="change ProfileVelocity and ProfileAcceleration and ProfileDeceleration parameters to highSpeed")
    public void fastTrucksProfile() {
        this.autochangerTrucks.fastProfile();
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Do homing for both controllers.")
    public void homingTrucks() {
        this.autochangerTrucks.homing();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="move to approach position with high velocity then move to STANDBY with low velocity")
    public void dockingAtStandbyPositionWithoutFilter() {
        try (AutochangerTwoTrucks.ReleaseAutochangerBrakes g = new AutochangerTwoTrucks.ReleaseAutochangerBrakes(this.autochangerTrucks);){
            this.autochangerTrucks.moveToApproachStandbyPositionWithHighVelocity();
            this.autochangerTrucks.moveToStandbyWithLowVelocity();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Open autochanger latches.")
    public void openLatches() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("openLatches");){
            this.latches.open();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Close autochanger latches.")
    public void closeLatches() {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("closeLatches");){
            this.latches.close();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Opens the 3 online clamps in mode PROFILE_POSITION.", timeout=15000)
    public void openClamps() {
        this.onlineClamps.openClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=2, description=" close clamps in mode PROFILE_POSITION for AC1 and AC2", timeout=6000)
    public void closeClamps() {
        this.onlineClamps.closeClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Locks clamps : closed with a strong pressure (high current).", timeout=6000)
    public void lockClamps() {
        this.onlineClamps.lockClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="unlocks clamps : decreases current in controller to decrease pressure.", timeout=15000)
    public void unlockClamps() {
        this.onlineClamps.unlockClamps();
    }

    @Command(type=Command.CommandType.ACTION, level=2, description="Perform homing of the three autochanger online clamps: open and homing from the controller", timeout=6000)
    public void homingClamps() {
        this.onlineClamps.homing();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if there is no filter in the autochanger. This command doesn't read again the sensors.")
    public boolean isEmpty() {
        return this.latches.isEmpty();
    }

    @Command(type=Command.CommandType.ACTION, level=1, alias="grabFilter", description="Move autochanger trucks to STANDBY position, close latches and stay at STANDBY")
    public void grabFilterAtStandby() {
        this.updateState();
        if (!this.latches.isOpened()) {
            throw new RejectedCommandException(this.name + " latches must be open to execute grabFilterAtStandby");
        }
        if (!this.carousel.isHoldingFilterAtStandby()) {
            throw new RejectedCommandException(this.name + " a filter must be at STANDBY on the carousel to execute grabFilterAtStandby");
        }
        this.grabFilterAtStandbyCounter.increment();
        long beginTime = System.currentTimeMillis();
        this.main.updateAgentState(ObservatoryFilterState.UNLOADED);
        this.carousel.checkDeltaPosition();
        this.waitForProtectionSystemUpdate();
        try (AutochangerTwoTrucks.ReleaseAutochangerBrakes g = new AutochangerTwoTrucks.ReleaseAutochangerBrakes(this.autochangerTrucks);){
            FCSLOG.info(this.name + " === About to move empty to standby position ===");
            this.autochangerTrucks.moveToApproachStandbyPositionWithHighVelocity();
            this.autochangerTrucks.alignFollowerStrict();
            this.autochangerTrucks.moveEmptyToStandbyWithLowVelocity();
        }
        FCSLOG.info(this.name + " ===> filter on autochanger after moveToStandbyEmptyWithLowVelocity =" + this.filterOnTrucksID + " should be != 0");
        this.updateFilterOnTrucksID();
        this.latches.close();
        FcsActions.GeneralAction.GRAB_FILTER_AT_STANDBY.publishDurationTopLevel(this.subs, System.currentTimeMillis() - beginTime);
        FCSLOG.info(this.name + ": filter " + this.filterOnTrucksID + " is now on autochanger");
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="open latches then go to approachStandbyPosition with low speed and move to HANDOFF with highSpeed.", timeout=20000, autoAck=false)
    public void moveEmptyFromStandbyToHandoff() {
        this.moveEmptyFromStandbyToHandoff(false);
    }

    public void moveEmptyFromStandbyToHandoff(boolean withPrecision) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("moveEmptyFromStandbyToHandoff");){
            if (!this.isCarouselHoldingFilterAtStandby()) {
                throw new RejectedCommandException(this.name + "%s : can't open latches if carousel is not holding it.");
            }
            if (this.latches.isClosed()) {
                this.latches.open();
            }
            this.waitForProtectionSystemUpdate();
            try (AutochangerTwoTrucks.ReleaseAutochangerBrakes g = new AutochangerTwoTrucks.ReleaseAutochangerBrakes(this.autochangerTrucks);){
                this.autochangerTrucks.moveToApproachStandbyPositionWithLowVelocity();
                this.autochangerTrucks.alignFollowerAndMoveEmptyFromApproachToHandoff(withPrecision);
            }
            this.updateFilterOnTrucksID();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="set a new value for the acquisition frequency of linear rail controllers current in milliseconds.")
    public void setFastAcqRateLinearRails(int rate) {
        this.configurationService.change("acTruckXminus-monitorCurrent", "taskPeriodMillis", (Object)rate);
        this.configurationService.change("acTruckXplus-monitorCurrent", "taskPeriodMillis", (Object)rate);
        this.configurationService.saveChangesForCategories(new String[]{"timers:fastRails"});
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="set a new value for the acquisition frequency of ONLINE clamps controllers current, in milliseconds.")
    public void setFastAcqRateOnlineClamps(int rate) {
        this.configurationService.change("onlineClampXminus-monitorCurrent", "taskPeriodMillis", (Object)rate);
        this.configurationService.change("onlineClampXplus-monitorCurrent", "taskPeriodMillis", (Object)rate);
        this.configurationService.change("onlineClampYminus-monitorCurrent", "taskPeriodMillis", (Object)rate);
        this.configurationService.saveChangesForCategories(new String[]{"timers:fast"});
    }

    @Deprecated
    @Command(type=Command.CommandType.QUERY, level=1, description="speed up online clamps current monitoring for the 3 clamps")
    public void increaseCurrentMonitoring() {
        this.configurationService.loadCategories(new String[]{"timers:fast"});
    }

    @Deprecated
    @Command(type=Command.CommandType.QUERY, level=1, description="slow down online clamps current monitoring for the 3 clamps")
    public void decreaseCurrentMonitoring() {
        this.configurationService.loadCategories(new String[]{"timers:slow"});
    }

    public void increaseLinearRailsCurrentMonitoring() {
        this.configurationService.loadCategories(new String[]{"timers:fastRails"});
    }

    public void decreaseLinearRailsCurrentMonitoring() {
        this.configurationService.loadCategories(new String[]{"timers:slowRails"});
    }

    public void lockFilterAtOnline() {
        if (!this.isAtOnline()) {
            throw new FcsHardwareException(this.name + "is not at ONLINE");
        }
        if (this.isEmpty()) {
            throw new FcsHardwareException(this.name + " must be loaded with a filter");
        }
        this.onlineClamps.lockFilterAtOnline();
    }

    private double[] readSenecaTemperatures() {
        double[] temp = new double[8];
        for (int i = 0; i < 4; ++i) {
            temp[i] = this.tempSensorsDevice1.readChannel(i + 1);
            temp[i + 4] = this.tempSensorsDevice2.readChannel(i + 1);
            FcsUtils.sleep(50, this.name);
        }
        return temp;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Print the eight temperatures of the autochanger")
    public String printTemperatures() {
        this.checkSenecaTemperatures();
        String fmt = "%-21s = %6.1f\u00baC\n";
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(fmt, "LinearRailMotorXplus", this.temperatures[0]));
        sb.append(String.format(fmt, "LinearRailMotorXminus", this.temperatures[1]));
        sb.append(String.format(fmt, "ClampMotorXplus", this.temperatures[2]));
        sb.append(String.format(fmt, "ClampMotorYminus", this.temperatures[3]));
        sb.append(String.format(fmt, "ClampMotorXminus", this.temperatures[4]));
        sb.append(String.format(fmt, "FrontBox", this.temperatures[5]));
        sb.append(String.format(fmt, "RearBox", this.temperatures[6]));
        sb.append(String.format(fmt, "CellXminus", this.temperatures[7]));
        return sb.toString();
    }

    public void checkSenecaTemperatures() {
        try {
            this.temperatures = this.readSenecaTemperatures();
        }
        catch (Exception ex) {
            this.raiseWarning(FcsAlerts.SDO_ERROR, "Autochanger temperature controller unreachable on the Canbus. When powered on for a long time, the autochanger temperature sensor controllers (Seneca) may shutdown the communication on the canbus, making them unable to receive a SDO request. Since these modules are powered from the safety power (same as PLC) they cannot be reset and the solution is to send an NMT Reset Communication signal on the Canbus so it starts responding again.", ex);
            this.tcpProxy.resetCommunication(this.tempSensorsDevice1.getNodeID());
            this.tcpProxy.resetCommunication(this.tempSensorsDevice2.getNodeID());
        }
    }

    private void publishSenecaTemperatures() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name + "/temperatures", (Serializable)this.createStatusDataPublishedBySeneca()));
    }

    public StatusDataPublishedByAutochangerSeneca createStatusDataPublishedBySeneca() {
        this.checkSenecaTemperatures();
        return new StatusDataPublishedByAutochangerSeneca(this.temperatures);
    }
}

