package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;

/**
 * Interface for can devices that handle emergency messages.
 * 
 * @author emarin
 */
public interface EmergencyMessageListener {

    /**
     * Callback when an emergency message is received.
     * 
     * @param em
     */
    void onEmergencyMessage(EmergencyMessage em);

    default void onFaultReset() {

    }

    default void onFault() {

    }

}
