/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.guider;

import java.time.Instant;
import java.util.List;
import org.lsst.ccs.daq.guider.Status;
import org.lsst.ccs.utilities.location.SensorLocation;

public class Series {
    private final Status status;
    private final Instant begin;
    private final int sequence;
    private final int stamps;
    private final List<SensorLocation> configured;
    private final List<SensorLocation> remaining;

    private Series(Status status, long timestampNanos, int sequence, int stamps, List<SensorLocation> configured, List<SensorLocation> remaining) {
        this.status = status;
        this.begin = Instant.ofEpochSecond(timestampNanos / 1000000000L, timestampNanos % 1000000000L);
        this.sequence = sequence;
        this.stamps = stamps;
        this.configured = configured;
        this.remaining = remaining;
    }

    public Status getStatus() {
        return this.status;
    }

    public Instant getBegin() {
        return this.begin;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getStamps() {
        return this.stamps;
    }

    public List<SensorLocation> getConfigured() {
        return this.configured;
    }

    public List<SensorLocation> getRemaining() {
        return this.remaining;
    }

    public String toString() {
        return "Series{status=" + this.status + ", begin=" + this.begin + ", sequence=" + this.sequence + ", stamps=" + this.stamps + ", configured=" + this.configured + ", remaining=" + this.remaining + '}';
    }
}

