/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.kafka.avro;

import java.util.ArrayList;
import org.apache.avro.Schema;
import org.lsst.ccs.camera.kafka.avro.Topic;

abstract class AvroSchemaUtils {
    AvroSchemaUtils() {
    }

    static Schema generateSchemaForTopic(Topic t) {
        Schema avroSchema = Schema.createRecord((String)t.getName(), null, (String)t.getNameSpace(), (boolean)false);
        Schema.Type nullType = Schema.Type.NULL;
        ArrayList<Schema.Field> schemaFields = new ArrayList<Schema.Field>();
        for (Topic.TopicField f : t.getFields()) {
            Schema schemaType = Schema.create((Schema.Type)Schema.Type.valueOf((String)f.getType().toUpperCase()));
            Object defaultValue = null;
            if (!f.getName().equals("timestamp")) {
                schemaType = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)nullType), schemaType});
                defaultValue = Schema.Field.NULL_DEFAULT_VALUE;
            }
            Schema.Field schemaField = new Schema.Field(f.getName(), schemaType, null, defaultValue);
            schemaField.addProp("description", f.getDescription());
            schemaField.addProp("units", f.getUnits());
            schemaFields.add(schemaField);
        }
        for (String tag : t.getTags()) {
            Schema.Field schemaField = new Schema.Field(tag, Schema.create((Schema.Type)Schema.Type.STRING), null);
            schemaField.addProp("description", "This is a tag");
            schemaFields.add(schemaField);
        }
        avroSchema.setFields(schemaFields);
        return avroSchema;
    }
}

