/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;

public class SimuEPOSController
extends CanOpenEPOS {
    private static final Logger FCSLOG = Logger.getLogger(SimuEPOSController.class.getName());
    protected int targetPosition;
    protected int ssiPosition;
    protected int targetCurrent;
    protected int actualCurrent;

    public SimuEPOSController() {
        this.position = 0;
        this.mode = EPOSEnumerations.EposMode.PROFILE_POSITION;
        this.simuEnabled = false;
        this.statusWord = 64;
        this.eposState = EPOSEnumerations.EposState.SWITCH_ON_DISABLED;
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="For simulator only : Update position with a position given as argument.")
    public void setPosition(int actualPosition) {
        this.position = actualPosition;
    }

    @Override
    public boolean isTargetReached() {
        return this.position == this.targetPosition || this.actualCurrent == this.targetCurrent;
    }

    @Override
    public void enable() {
        this.goToOperationEnable();
        this.simuEnabled = true;
    }

    @Override
    public void goToOperationEnable() {
        super.goToOperationEnable();
        this.simuEnabled = true;
    }

    @Override
    public void goToSwitchOnDisabled() {
        this.disableVoltage();
        this.simuEnabled = false;
    }

    @Override
    public boolean isEnabled() {
        return this.simuEnabled;
    }

    @Override
    public boolean isParametersOK() {
        return true;
    }

    @Override
    public void defineAbsolutePosition(int position) {
        this.position = position;
    }

    @Override
    public void writeParameters(EPOSEnumerations.EposMode mode) {
    }

    @Override
    public void writeTargetPosition(int position) {
        this.position = position;
    }

    @Override
    public void writeParameters(Map<String, Integer> paramMap) {
    }

    @Override
    public void writeCurrent(int aValue) {
        this.actualCurrent = aValue;
    }

    @Override
    public void stopAction() {
    }

    @Override
    public long readParameter(EPOSEnumerations.EposParameter parameter) {
        switch (parameter) {
            case ProfileVelocity: {
                return this.getProfileVelocity();
            }
            case ProfileAcceleration: {
                return this.getProfileAcceleration();
            }
            case ProfileDeceleration: {
                return this.getProfileDeceleration();
            }
        }
        return 0L;
    }

    @Override
    public int readPosition() {
        return this.position;
    }

    @Override
    public int readSSIPosition() {
        return this.ssiPosition;
    }

    @Override
    public int readCurrent() {
        return this.actualCurrent;
    }

    @Override
    public EPOSEnumerations.EposMode readMode() {
        return this.mode;
    }

    @Override
    public int readStatusWord() {
        return this.statusWord;
    }

    @Override
    public void quickStop() {
        FCSLOG.finest(() -> this.name + " quickStop done.");
    }

    @Override
    public int getErrorHistoryNB() {
        return 0;
    }

    @Override
    public int readErrorRegister() {
        return 0;
    }

    @Override
    public void updateErrorHistory() {
        this.errorHistory = new int[0];
    }

    @Override
    public String updateAndDisplayErrorHistory() {
        this.updateErrorHistory();
        return "No ERROR";
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the Controller is in fault.")
    public void checkFault() {
    }

    @Override
    public void checkFault(boolean withPublication) {
    }

    @Override
    public long readProfileVelocity() {
        return 0L;
    }

    @Override
    public String readParametersForMode(EPOSEnumerations.EposMode mode) {
        return this.getName() + ":no parameter to read.";
    }

    @Override
    public void checkParameters(EPOSEnumerations.EposMode aMode) {
    }

    @Override
    public void writeControlWord(int w) {
        FCSLOG.finer(this.name + " writeControlWord : 0x" + Integer.toHexString(w) + " (in decimal:" + w + ")");
        switch (w) {
            case 7: {
                this.statusWord = 35;
                break;
            }
            case 0: {
                this.statusWord = 64;
                break;
            }
            case 6: {
                this.statusWord = 33;
                break;
            }
            case 15: {
                this.statusWord = 39;
                break;
            }
            default: {
                this.statusWord = w;
            }
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Enable controller and go to relative position. Doesn't check condition. DANGER !!!! ")
    public void enableAndWriteRelativePosition(int pos) {
        this.enable();
        this.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.writeTargetPosition(this.position + pos);
        this.writeControlWord(EPOSEnumerations.ControlWord.RELATIVE_POSITION_AND_MOVE);
    }

    public void postStart() {
        FCSLOG.info(this.name + " BEGIN postStart");
        FCSLOG.info(this.name + " END postStart");
    }
}

