/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.NamedComponent;
import org.lsst.ccs.subsystems.fcs.common.PersistentCounter;
import org.lsst.ccs.subsystems.fcs.errors.ActionTimeoutException;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public abstract class MobileItem
implements NamedComponent,
AlertRaiser,
SignalHandler,
HasLifecycle {
    private static final Logger FCSLOG = Logger.getLogger(MobileItem.class.getName());
    @LookupName
    protected String name;
    @LookupPath
    protected String path;
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Subsystem subs;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected DataProviderDictionaryService dataProviderDictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    protected volatile boolean hasToWaitForEndOfAction = false;
    protected volatile FcsEnumerations.MobileItemAction currentAction;
    protected long commandDuration = 0L;
    protected long beginTime;
    protected boolean timeoutExceeded;
    protected volatile boolean moving = false;
    protected final Lock lock = new ReentrantLock();
    private final Condition motionCompleted = this.lock.newCondition();
    @ConfigurationParameter(range="0..10000", description="Time interval between two consecutive sensor readouts", units="millisecond", category="readRate")
    private volatile int readSensorsRate = 250;
    protected ScheduledFuture<?> readSensorsHandle;
    protected final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(2);
    private final AtomicBoolean haltRequired = new AtomicBoolean(false);
    private final AtomicBoolean stopRequired = new AtomicBoolean(false);
    protected Map<FcsEnumerations.MobileItemAction, PersistentCounter> movementCounter;

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Subsystem getSubsystem() {
        return this.subs;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public AtomicBoolean getHaltRequired() {
        return this.haltRequired;
    }

    protected void cancelReadingSensors() {
        this.lock.lock();
        try {
            FCSLOG.fine(() -> this.name + " => stop reading sensors");
            this.motionCompleted.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.readSensorsHandle.cancel(true);
        FCSLOG.fine(() -> this.name + " => readingSensors canceled");
    }

    public abstract boolean myDevicesReady();

    public abstract boolean isActionCompleted(FcsEnumerations.MobileItemAction var1);

    public abstract void updateStateWithSensorsToCheckIfActionIsCompleted();

    public abstract void startAction(FcsEnumerations.MobileItemAction var1);

    public abstract void abortAction(FcsEnumerations.MobileItemAction var1, long var2);

    public abstract void endAction(FcsEnumerations.MobileItemAction var1);

    public abstract void quickStopAction(FcsEnumerations.MobileItemAction var1, long var2);

    public abstract void publishData();

    public void checkReadyForAction() {
        if (!this.myDevicesReady()) {
            throw new FcsHardwareException(this.name + ": hardware is not ready to execute ACTION commands.");
        }
        if (this.agentStateService.isInState((Enum)AlertState.ALARM)) {
            throw new FcsHardwareException(this.name + ": can't execute ACTION commands when subsystem is in ALARM state.");
        }
    }

    protected void executeAction(FcsEnumerations.MobileItemAction action, long timeoutForAction) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("MobileItemAction execute " + action.toString());){
            this.checkReadyForAction();
            this.beginTime = System.currentTimeMillis();
            this.lock.lock();
            try {
                this.movementCounter.get(action).increment();
                this.hasToWaitForEndOfAction = true;
                this.currentAction = action;
                this.commandDuration = 0L;
                this.timeoutExceeded = false;
                this.moving = true;
                this.startAction(action);
                this.readSensorsUntilActionIsCompleted(action, timeoutForAction);
                this.waitForEndOfAction(action);
                if (this.haltRequired.get()) {
                    this.abortAction(action, 0L);
                    String msg = this.name + "=> Received an ABORT command for action :" + action.toString();
                    FCSLOG.info(msg);
                    throw new FailedCommandException(msg);
                }
                if (this.stopRequired.get()) {
                    this.quickStopAction(action, 0L);
                    FCSLOG.info(() -> this.name + "=> Received a STOP command for action :" + action.toString());
                } else if (this.isActionCompleted(action)) {
                    FCSLOG.info(() -> this.name + " ===> ACTION COMPLETED : " + action.doneString());
                }
                if (this.timeoutExceeded) {
                    FCSLOG.severe(() -> this.name + " ===> ACTION NOT COMPLETED : " + action.getFailureMsg());
                    String msg = String.format("%s: %s action exceeded %d ms timeout ", this.name, action.toString(), timeoutForAction);
                    FCSLOG.severe(msg);
                    throw new ActionTimeoutException(this.name, action.toString(), timeoutForAction);
                }
            }
            catch (ActionTimeoutException ex) {
                throw ex;
            }
            catch (Exception ex) {
                String msg = this.name + " ===> ERROR during ACTION : " + action.toString() + ex.getMessage();
                FCSLOG.severe(() -> msg + ex.getMessage());
                FCSLOG.severe(() -> action.getFailureMsg());
                throw new FailedCommandException(msg, (Throwable)ex);
            }
            finally {
                FCSLOG.fine(() -> this.name + ": finally in executeAction.");
                this.moving = false;
                this.hasToWaitForEndOfAction = false;
                this.motionCompleted.signalAll();
                this.haltRequired.set(false);
                this.stopRequired.set(false);
                this.lock.unlock();
                this.endAction(action);
                this.commandDuration = System.currentTimeMillis() - this.beginTime;
                this.publishData();
                action.publishDurationPerElement(this.subs, this.commandDuration, this.path);
            }
        }
    }

    public void readSensorsUntilActionIsCompleted(FcsEnumerations.MobileItemAction action, long timeout) {
        Runnable readSensors = () -> {
            try {
                this.commandDuration = System.currentTimeMillis() - this.beginTime;
                this.updateStateWithSensorsToCheckIfActionIsCompleted();
                boolean actionCompleted = this.isActionCompleted(action);
                if (this.haltRequired.get() || this.stopRequired.get()) {
                    this.hasToWaitForEndOfAction = false;
                    FCSLOG.info(() -> this.name + ": " + action.toString() + " ABORT or STOP REQUESTED FOR ACTION BY ABORT or STOP COMMAND");
                    this.cancelReadingSensors();
                } else if (actionCompleted) {
                    this.hasToWaitForEndOfAction = false;
                    FCSLOG.info(() -> this.name + ": " + action.toString() + " ACTION COMPLETED");
                    this.cancelReadingSensors();
                } else if (this.commandDuration >= timeout) {
                    this.hasToWaitForEndOfAction = false;
                    this.timeoutExceeded = true;
                    FCSLOG.info(() -> this.name + ": " + action.toString() + " ACTION NOT COMPLETED during allocated time = " + timeout);
                    this.cancelReadingSensors();
                } else {
                    FCSLOG.info(() -> this.name + ": " + action.name() + " not completed... / duration=" + this.commandDuration);
                }
            }
            catch (Exception ex) {
                this.hasToWaitForEndOfAction = false;
                this.cancelReadingSensors();
                FCSLOG.severe(() -> this.name + ": ERROR in reading sensors during action " + action.name());
                throw new FcsHardwareException(this.name + ": ERROR in reading sensors during action " + action.name(), (Throwable)ex);
            }
        };
        this.readSensorsHandle = this.scheduler.scheduleWithFixedDelay(readSensors, this.readSensorsRate, this.readSensorsRate, TimeUnit.MILLISECONDS);
    }

    protected void waitForEndOfAction(FcsEnumerations.MobileItemAction action) {
        try (FcsUtils.AutoTimed at = new FcsUtils.AutoTimed("waitForEndOfAction-MobileItem");){
            while (this.hasToWaitForEndOfAction) {
                try {
                    FCSLOG.info(() -> this.name + " waiting for end of " + action.toString());
                    this.motionCompleted.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.info(() -> this.name + ": InterruptedException received=" + ex);
                    break;
                }
            }
            FCSLOG.info(() -> this.name + " STOP WAITING FOR END OF ACTION");
        }
    }

    private void halt(FcsEnumerations.MobileItemAction action, long delay) {
        if (action == null) {
            FCSLOG.warning(() -> this.name + ": no current action running => nothing to abort.");
            return;
        }
        FCSLOG.finer(() -> this.name + ": ABORTING ACTION " + action.toString() + "within delay=" + delay);
        this.abortAction(action, delay);
        this.moving = false;
    }

    private void quickStop(FcsEnumerations.MobileItemAction action, long delay) {
        if (action == null) {
            FCSLOG.warning(() -> this.name + ": no current action running => nothing to stop.");
            return;
        }
        FCSLOG.info(() -> this.name + ": QUICKSTOP for" + action.toString() + "within delay=" + delay);
        this.quickStopAction(action, delay);
        this.moving = false;
    }

    public void shutdown() {
        FCSLOG.info(() -> this.name + " is shutting down.");
        this.scheduler.shutdown();
    }

    public TreeWalkerDiag signal(Signal signal) {
        SignalLevel sl = signal.getLevel();
        FCSLOG.info(() -> sl.toString());
        if (!this.moving) {
            FCSLOG.warning(() -> this.name + " is not moving; nothing to stop.");
        } else {
            switch (signal.getLevel()) {
                case HALT: {
                    FCSLOG.info(() -> this.name + " HALT required");
                    this.haltRequired.set(true);
                    this.halt(this.currentAction, signal.getTimeHint());
                    break;
                }
                case STOP: {
                    FCSLOG.info(() -> this.name + " STOP required");
                    this.stopRequired.set(true);
                    this.quickStop(this.currentAction, signal.getTimeHint());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }
}

