###############################################################
#Script to test the real hardware of autochanger online clamps
#on CPPM testbench executed in september 2015
###############################################################
from org.lsst.ccs.scripting import CCS
from org.lsst.ccs.command import *
from time import sleep
import java.time

 
timeoutFiveMillis = java.time.Duration.ofMillis(5)
timeoutTenSec = java.time.Duration.ofSeconds(10)


CCS.setThrowExceptions(True)


cppm = CCS.attachSubsystem("testbenchCPPM")

print "Connected to testbenchCPPM=> ", cppm

ccsVersion= cppm.sendSynchCommand(timeoutFiveMillis,"getCCSVersions")
print "TESTS of autochanger trucks motion with CCS version number"
print ccsVersion.getResult()

#print "Date=", date

tcpProxy = CCS.attachSubsystem("testbenchCPPM/tcpProxy")

result = tcpProxy.sendSynchCommand(timeoutFiveMillis,"isCANDevicesReady")

print "isCANDevicesReady=", result.getResult()

clamp = CCS.attachSubsystem("testbenchCPPM/onlineClampXminus")
##################################INITIALIZATION


waitTime = int(1)



#Read the onlineController mode and check if it's in CURRENT mode.
ctl = CCS.attachSubsystem("testbenchCPPM/onlineClampController")
mode = ctl.sendSynchCommand(timeoutFiveMillis,"readMode")
print "Controller Mode=", mode.getResult()

if str(mode.getResult()) != 'CURRENT' :
   #  raise Exception("ERROR on Controller mode")
   print "ERROR on Controller mode - have to change it."
   result = ctl.sendSynchCommand(timeoutFiveMillis,"changeMode CURRENT")
else:
   print "controller is in mode", mode.getResult()


#loop to lock and unlock the online clamp
#

for i in range(5):
   print "begin ITERATION number", i
   print "LOCKING"
   resultMvt=clamp.sendSynchCommand(timeoutTenSec,"testLock")
   #TODO test if execution is correct
   print "Sleeping", waitTime, "s....."
   sleep(waitTime)
   print "UNLOCKING"
   resultMvt=clamp.sendSynchCommand(timeoutTenSec,"testUnlock")
   print "Sleeping", waitTime, "s....."
   sleep(waitTime)
   print "end ITERATION number", i

print "END LOOP"
