package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;

public class CanOpenEPOSAutochangerLatch extends CanOpenEPOS {

    /**
     * Define cobid to be able to read values from PDO data
     */
    private int cobid1 = this.nodeID + 0x180;

    /**
     * PDO1 represents :
     * velocity: 4 bytes
     * current: 2 bytes
     * statusWord: 2 bytes
     */
    private long pdo1 = 0L;

    /**
     * @return the cobid
     */
    public int getCobid1() {
        return cobid1;
    }

    /**
     * @param cobid the cobid to set
     */
    public void setCobid1(int cobid) {
        this.cobid1 = cobid;
    }

    /**
     * @return the pdo1
     */
    public long getPdo1() {
        return pdo1;
    }

    /**
     * @param pdo the pdo1 to set
     */
    public void setPdo1(long pdo) {
        this.pdo1 = pdo;
    }

    @Override
    public void doInitializePDOs() throws DriverException {
        tcpProxy.addReceivedPDO(cobid1);
    }

    @Override
    public void updateFromPDO(PDOData pdo) {
        // TODO: fill in the method after Patrick's reply
    }
}
