/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import nom.tam.fits.AsciiTable;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.RandomGroupsData;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.fits.UndefinedData;
import nom.tam.fits.UndefinedHDU;
import nom.tam.fits.header.hierarch.IHierarchKeyFormatter;
import nom.tam.fits.header.hierarch.StandardIHierarchKeyFormatter;
import nom.tam.image.compression.hdu.CompressedImageData;
import nom.tam.image.compression.hdu.CompressedImageHDU;
import nom.tam.image.compression.hdu.CompressedTableData;
import nom.tam.image.compression.hdu.CompressedTableHDU;

public final class FitsFactory {
    private static final FitsSettings GLOBAL_SETTINGS = new FitsSettings();
    private static final ThreadLocal<FitsSettings> LOCAL_SETTINGS = new ThreadLocal();
    private static ExecutorService threadPool;
    public static final int FITS_BLOCK_SIZE = 2880;

    public static Data dataFactory(Header hdr) throws FitsException {
        if (ImageHDU.isHeader(hdr)) {
            Data d = ImageHDU.manufactureData(hdr);
            hdr.afterExtend();
            return d;
        }
        if (RandomGroupsHDU.isHeader(hdr)) {
            return RandomGroupsHDU.manufactureData(hdr);
        }
        if (FitsFactory.current().useAsciiTables && AsciiTableHDU.isHeader(hdr)) {
            return AsciiTableHDU.manufactureData(hdr);
        }
        if (CompressedImageHDU.isHeader(hdr)) {
            return CompressedImageHDU.manufactureData(hdr);
        }
        if (CompressedTableHDU.isHeader(hdr)) {
            return CompressedTableHDU.manufactureData(hdr);
        }
        if (BinaryTableHDU.isHeader(hdr)) {
            return BinaryTableHDU.manufactureData(hdr);
        }
        if (UndefinedHDU.isHeader(hdr)) {
            return UndefinedHDU.manufactureData(hdr);
        }
        throw new FitsException("Unrecognizable header in dataFactory");
    }

    public static boolean getAllowTerminalJunk() {
        return FitsFactory.current().allowTerminalJunk;
    }

    public static IHierarchKeyFormatter getHierarchFormater() {
        return FitsFactory.current().hierarchKeyFormatter;
    }

    public static boolean getUseHierarch() {
        return FitsFactory.current().useHierarch;
    }

    public static <DataClass extends Data> BasicHDU<DataClass> hduFactory(Header hdr, DataClass d) throws FitsException {
        if (d instanceof ImageData) {
            return new ImageHDU(hdr, (ImageData)d);
        }
        if (d instanceof CompressedImageData) {
            return new CompressedImageHDU(hdr, (CompressedImageData)d);
        }
        if (d instanceof RandomGroupsData) {
            return new RandomGroupsHDU(hdr, (RandomGroupsData)d);
        }
        if (FitsFactory.current().useAsciiTables && d instanceof AsciiTable) {
            return new AsciiTableHDU(hdr, (AsciiTable)d);
        }
        if (d instanceof CompressedTableData) {
            return new CompressedTableHDU(hdr, (CompressedTableData)d);
        }
        if (d instanceof BinaryTable) {
            return new BinaryTableHDU(hdr, (BinaryTable)d);
        }
        if (d instanceof UndefinedData) {
            return new UndefinedHDU(hdr, (UndefinedData)d);
        }
        return null;
    }

    public static BasicHDU<?> hduFactory(Object o) throws FitsException {
        Data d;
        Header h;
        if (o instanceof Header) {
            h = (Header)o;
            d = FitsFactory.dataFactory(h);
        } else if (ImageHDU.isData(o)) {
            d = ImageHDU.encapsulate(o);
            h = ImageHDU.manufactureHeader(d);
        } else if (RandomGroupsHDU.isData(o)) {
            d = RandomGroupsHDU.encapsulate(o);
            h = RandomGroupsHDU.manufactureHeader(d);
        } else if (FitsFactory.current().useAsciiTables && AsciiTableHDU.isData(o)) {
            d = AsciiTableHDU.encapsulate(o);
            h = AsciiTableHDU.manufactureHeader(d);
        } else if (BinaryTableHDU.isData(o)) {
            d = BinaryTableHDU.encapsulate(o);
            h = BinaryTableHDU.manufactureHeader(d);
        } else if (UndefinedHDU.isData(o)) {
            d = UndefinedHDU.encapsulate(o);
            h = UndefinedHDU.manufactureHeader(d);
        } else {
            throw new FitsException("Invalid data presented to HDUFactory");
        }
        return FitsFactory.hduFactory(h, d);
    }

    @Deprecated
    public static <DataClass extends Data> BasicHDU<DataClass> HDUFactory(Header hdr, DataClass d) throws FitsException {
        return FitsFactory.hduFactory(hdr, d);
    }

    @Deprecated
    public static BasicHDU<?> HDUFactory(Object o) throws FitsException {
        return FitsFactory.hduFactory(o);
    }

    public static boolean isLongStringsEnabled() {
        return FitsFactory.current().longStringsEnabled;
    }

    public static boolean isSkipBlankAfterAssign() {
        return FitsFactory.current().skipBlankAfterAssign;
    }

    public static void setAllowTerminalJunk(boolean allowTerminalJunk) {
        FitsFactory.current().allowTerminalJunk = allowTerminalJunk;
    }

    public static void setCheckAsciiStrings(boolean checkAsciiStrings) {
        FitsFactory.current().checkAsciiStrings = checkAsciiStrings;
    }

    public static void setHierarchFormater(IHierarchKeyFormatter formatter) {
        FitsFactory.current().hierarchKeyFormatter = formatter;
    }

    public static void setLongStringsEnabled(boolean longStringsEnabled) {
        FitsFactory.current().longStringsEnabled = longStringsEnabled;
    }

    public static void setSkipBlankAfterAssign(boolean skipBlankAfterAssign) {
        FitsFactory.current().skipBlankAfterAssign = skipBlankAfterAssign;
    }

    public static void setUseAsciiTables(boolean useAsciiTables) {
        FitsFactory.current().useAsciiTables = useAsciiTables;
    }

    public static void setUseHierarch(boolean useHierarch) {
        FitsFactory.current().useHierarch = useHierarch;
    }

    public static ExecutorService threadPool() {
        if (threadPool == null) {
            FitsFactory.initializeThreadPool();
        }
        return threadPool;
    }

    public static void useThreadLocalSettings(boolean useThreadSettings) {
        if (useThreadSettings) {
            LOCAL_SETTINGS.set(FitsFactory.GLOBAL_SETTINGS.copy());
        } else {
            LOCAL_SETTINGS.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeThreadPool() {
        FitsSettings fitsSettings = GLOBAL_SETTINGS;
        synchronized (fitsSettings) {
            if (threadPool == null) {
                threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2, new ThreadFactory(){
                    private int counter = 1;

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r, "nom-tam-fits worker " + this.counter++);
                        thread.setDaemon(true);
                        return thread;
                    }
                });
            }
        }
    }

    protected static FitsSettings current() {
        FitsSettings settings = LOCAL_SETTINGS.get();
        if (settings == null) {
            return GLOBAL_SETTINGS;
        }
        return settings;
    }

    static boolean getCheckAsciiStrings() {
        return FitsFactory.current().checkAsciiStrings;
    }

    private FitsFactory() {
    }

    protected static final class FitsSettings {
        private boolean useAsciiTables = true;
        private boolean useHierarch = false;
        private boolean checkAsciiStrings = false;
        private boolean allowTerminalJunk = false;
        private boolean longStringsEnabled = false;
        private boolean skipBlankAfterAssign = false;
        private IHierarchKeyFormatter hierarchKeyFormatter = new StandardIHierarchKeyFormatter();

        protected FitsSettings() {
        }

        private FitsSettings copy() {
            FitsSettings settings = new FitsSettings();
            settings.useAsciiTables = this.useAsciiTables;
            settings.useHierarch = this.useHierarch;
            settings.checkAsciiStrings = this.checkAsciiStrings;
            settings.allowTerminalJunk = this.allowTerminalJunk;
            settings.longStringsEnabled = this.longStringsEnabled;
            settings.hierarchKeyFormatter = this.hierarchKeyFormatter;
            settings.skipBlankAfterAssign = this.skipBlankAfterAssign;
            return settings;
        }

        protected IHierarchKeyFormatter getHierarchKeyFormatter() {
            return this.hierarchKeyFormatter;
        }

        protected boolean isAllowTerminalJunk() {
            return this.allowTerminalJunk;
        }

        protected boolean isCheckAsciiStrings() {
            return this.checkAsciiStrings;
        }

        protected boolean isLongStringsEnabled() {
            return this.longStringsEnabled;
        }

        protected boolean isSkipBlankAfterAssign() {
            return this.skipBlankAfterAssign;
        }

        protected boolean isUseAsciiTables() {
            return this.useAsciiTables;
        }

        protected boolean isUseHierarch() {
            return this.useHierarch;
        }
    }
}

