/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.lsst.ccs.localdb.statusdb.model.DataPath;
import org.lsst.ccs.localdb.statusdb.model.MetaDataData;

@XmlRootElement(name="datachannel")
public class Channel
implements Serializable {
    @XmlElement(name="pathelement")
    @XmlElementWrapper
    protected String[] path;
    @XmlElement(name="metadata")
    protected List<MetaData> mds = new ArrayList<MetaData>();

    Channel() {
    }

    public final String[] getPath() {
        return this.path;
    }

    public final String getPathAsString() {
        return DataPath.encodePath(this.getPath());
    }

    public void addMetadata(String key, String value) {
        this.mds.add(new MetaData(key, value));
    }

    public Map<String, String> getMetadata() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.mds != null) {
            for (MetaData md : this.mds) {
                metadata.put(md.getName(), md.getValue());
            }
        }
        return metadata;
    }

    public static class MetaData {
        @XmlAttribute
        private String name;
        @XmlAttribute
        private String value;

        public MetaData(MetaDataData d) {
            this.name = d.getName();
            this.value = d.getValue();
        }

        public MetaData() {
        }

        public MetaData(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

