/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselSocket;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class FiltersViewPanel
extends JPanel {
    private static final long serialVersionUID = 2654131875576434802L;
    private final String panelTitle = "Filters Overview";
    private JTable allFiltersTable;
    private JTable onlineTable;
    private ConfigurationInfo configInfo;

    public FiltersViewPanel() {
        this.initComponents();
    }

    public void initializeGui(ConfigurationInfo configInfo, List<String> filterNames) {
        this.configInfo = configInfo;
        SwingUtilities.invokeLater(new GuiInitialization(filterNames));
    }

    public void updateFromStatusData(KeyValueData kvd) {
        SwingUtilities.invokeLater(new UpdateInstalledFilter(kvd));
    }

    @Override
    public String toString() {
        return "Filters Overview";
    }

    public void resetPanel() {
        Tools.resetTable(this.allFiltersTable);
        Tools.resetTable(this.onlineTable);
    }

    private void initComponents() {
        this.setBorder(Tools.getGeneralPanelTitle("Filters Overview"));
        this.initOnlineFiltersTable();
        JScrollPane scrollPane1 = new JScrollPane(this.onlineTable);
        scrollPane1.setBorder(BorderFactory.createTitledBorder("Filters installed in the camera"));
        scrollPane1.setPreferredSize(new Dimension(600, 165));
        this.initAllFiltersTable();
        JScrollPane scrollPane2 = new JScrollPane(this.allFiltersTable);
        scrollPane2.setBorder(BorderFactory.createTitledBorder("View of all filters"));
        scrollPane2.setPreferredSize(new Dimension(600, 300));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)scrollPane1, "North");
        this.add(panel);
        panel.add((Component)scrollPane2, "South");
    }

    private void initOnlineFiltersTable() {
        this.onlineTable = new JTable();
        this.onlineTable.setModel(new DefaultTableModel(new String[]{"Slot", "Name", "ID", "Obs. name", "Weight (kg)", "DeltaAutochangerStandbyPosition", "Available"}, 6){
            private static final long serialVersionUID = 1L;
            private final Class<?>[] types;
            private final boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Integer.class, String.class, Double.class, Integer.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.onlineTable.setValueAt("Autochanger", 0, 0);
        for (int i = 1; i < 6; ++i) {
            this.onlineTable.setValueAt("Socket " + i, i, 0);
        }
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        this.onlineTable.getColumnModel().getColumn(1).setCellRenderer(rightRenderer);
        this.onlineTable.getColumnModel().getColumn(3).setCellRenderer(rightRenderer);
    }

    private void initAllFiltersTable() {
        this.allFiltersTable = new JTable();
        this.allFiltersTable.setModel(new DefaultTableModel(new String[]{"Filter family", "Name", "ID", "Obs. name", "Weight (kg)", "DeltaAutochangerStandbyPosition"}, 0){
            private static final long serialVersionUID = 1L;
            private final Class<?>[] types;
            private final boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Integer.class, String.class, Double.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        this.allFiltersTable.getColumnModel().getColumn(1).setCellRenderer(rightRenderer);
        this.allFiltersTable.getColumnModel().getColumn(3).setCellRenderer(rightRenderer);
        this.allFiltersTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>((DefaultTableModel)this.allFiltersTable.getModel());
        sorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        this.allFiltersTable.setRowSorter(sorter);
    }

    private class GuiInitialization
    implements Runnable {
        private final List<String> filterNamesList;

        public GuiInitialization(List<String> filterNames) {
            this.filterNamesList = filterNames;
        }

        public void updateAllFilters(DefaultTableModel model) {
            for (String filterName : this.filterNamesList) {
                Map config = FiltersViewPanel.this.configInfo.getCurrentValuesFor("filterManager/" + filterName);
                Object[] filterInformation = new Object[]{FcsEnumerations.FilterFamily.valueOf((String)((String)config.get("family"))).getFamilyName(), filterName, Integer.parseInt((String)config.get("filterID")), filterName + "_" + Integer.parseInt((String)config.get("filterID")), Double.parseDouble((String)config.get("weight")), Integer.parseInt((String)config.get("deltaAutochangerStandbyPosition"))};
                model.addRow(filterInformation);
            }
        }

        @Override
        public void run() {
            DefaultTableModel model = (DefaultTableModel)FiltersViewPanel.this.allFiltersTable.getModel();
            this.updateAllFilters(model);
            TableRowSorter sorter = (TableRowSorter)FiltersViewPanel.this.allFiltersTable.getRowSorter();
            sorter.sort();
        }
    }

    private class UpdateInstalledFilter
    implements Runnable {
        Object data;

        UpdateInstalledFilter(KeyValueData kvd) {
            this.data = kvd.getValue();
        }

        private Double getWeight(String filterName) {
            Map config = FiltersViewPanel.this.configInfo.getCurrentValuesFor("filterManager/" + filterName);
            return Double.parseDouble((String)config.get("weight"));
        }

        private void updateAutochangerInfo(DefaultTableModel model, StatusDataPublishedByAutochangerTwoLatches s) {
            String filterName = s.getFilterName();
            int filterId = s.getFilterId();
            model.setValueAt(filterId > 0 ? filterName : "-", 0, 1);
            model.setValueAt(filterId > 0 ? Integer.valueOf(s.getFilterId()) : "-", 0, 2);
            model.setValueAt(filterId > 0 ? s.getFilterObservatoryName() : "-", 0, 3);
            model.setValueAt(filterId > 0 ? this.getWeight(filterName) : Double.NaN, 0, 4);
            model.setValueAt(filterId > 0 ? Integer.valueOf(s.getFilterDeltaAutochangerStandbyPosition()) : "-", 0, 5);
            model.setValueAt(s.isAvailable(), 0, 6);
        }

        private void updateCarouselInfo(DefaultTableModel model, StatusDataPublishedByCarouselSocket s) {
            int socketId = s.getSocketID();
            int filterId = s.getFilterID();
            String filterName = s.getFilterName();
            String filterObservatoryName = s.getFilterObservatoryName();
            model.setValueAt(filterId > 0 ? filterName : "-", socketId, 1);
            model.setValueAt(filterId > 0 ? Integer.valueOf(filterId) : "-", socketId, 2);
            model.setValueAt(filterId > 0 ? filterObservatoryName : "-", socketId, 3);
            model.setValueAt(filterId > 0 ? this.getWeight(filterName) : Double.NaN, socketId, 4);
            model.setValueAt(filterId > 0 ? Integer.valueOf(s.getFilterDeltaAutochangerStandbyPosition()) : "-", socketId, 5);
            model.setValueAt(s.isAvailable(), socketId, 6);
        }

        @Override
        public void run() {
            DefaultTableModel model = (DefaultTableModel)FiltersViewPanel.this.onlineTable.getModel();
            if (this.data instanceof StatusDataPublishedByAutochangerTwoLatches) {
                this.updateAutochangerInfo(model, (StatusDataPublishedByAutochangerTwoLatches)this.data);
            } else if (this.data instanceof StatusDataPublishedByCarouselSocket) {
                this.updateCarouselInfo(model, (StatusDataPublishedByCarouselSocket)this.data);
            }
        }
    }
}

