/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FcsColors;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AnalogicSensorPanel
extends JPanel {
    private static final long serialVersionUID = -1531790094506697510L;
    String clampName = "clampName";
    String sensorName = "sensorName";
    private final int orientation;
    private JLabel nameLabel;
    private JLabel stateLabel;
    private JLabel valueLabel;
    private JProgressBar progressBar;
    private DigitalSwitch sensorSwitch;
    protected JPanel paramsPanel;
    final JLabel offset1Label = new JLabel("0.0");
    final JLabel minLockedLabel = new JLabel("0.0");
    final JLabel minLimitLabel = new JLabel("0.0");
    final JLabel maxLimitLabel = new JLabel("0.0");

    public AnalogicSensorPanel(String clampName, String sensorName, int orientation) {
        this.clampName = clampName;
        this.sensorName = sensorName;
        this.orientation = orientation;
        this.initComponents();
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        Map config = configInfo.getCurrentValuesFor("carousel");
        if (this.sensorName.contains("Xminus")) {
            this.minLimitLabel.setText((String)config.get("lockSensorMinLimitXminus"));
            this.maxLimitLabel.setText((String)config.get("lockSensorMaxLimitXminus"));
        } else {
            this.minLimitLabel.setText((String)config.get("lockSensorMinLimitXplus"));
            this.maxLimitLabel.setText((String)config.get("lockSensorMaxLimitXplus"));
        }
    }

    protected void updateOffset1(int value) {
        this.offset1Label.setText(Integer.toString(value));
    }

    protected void updateMinLocked(long value) {
        this.minLockedLabel.setText(Long.toString(value));
    }

    protected void update(int value, FcsColors.ColoredObject sensorStatus) {
        this.progressBar.setValue(value);
        this.valueLabel.setText(Integer.toString(value));
        Color lockSensorColor = sensorStatus.getColor();
        this.sensorSwitch.setColor(lockSensorColor);
        this.stateLabel.setText(sensorStatus.toString());
        this.stateLabel.setForeground(lockSensorColor);
    }

    protected void initParamsPanel() {
        this.paramsPanel = new JPanel();
        this.paramsPanel.setBorder(Tools.getConfigurationTitle());
        this.paramsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = Tools.insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.anchor = 21;
        this.paramsPanel.add((Component)new JLabel("minLimit:"), gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)new JLabel("offset1:"), gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)new JLabel("minLocked:"), gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)new JLabel("maxLimit:"), gbcp);
        ++gbcp.gridx;
        gbcp.anchor = 22;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        this.paramsPanel.add((Component)this.minLimitLabel, gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)this.offset1Label, gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)this.minLockedLabel, gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)this.maxLimitLabel, gbcp);
    }

    private void initComponents() {
        this.progressBar = new JProgressBar(this.orientation);
        this.sensorSwitch = new DigitalSwitch();
        this.sensorSwitch.setColor(Color.gray);
        this.stateLabel = new JLabel("UNKNOWN");
        this.nameLabel = new JLabel(this.sensorName);
        this.valueLabel = new JLabel("0.0");
        this.initParamsPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.valueLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.progressBar, gbc);
        ++gbc.gridy;
        this.add((Component)this.sensorSwitch, gbc);
        ++gbc.gridy;
        this.add((Component)this.stateLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.nameLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.paramsPanel, gbc);
    }

    public void resetPanel() {
        this.progressBar.setValue(0);
        this.valueLabel.setText("0.0");
        this.sensorSwitch.setColor(Color.gray);
        this.stateLabel.setText("UNKNOWN STATE");
        this.stateLabel.setForeground(Color.gray);
        this.minLockedLabel.setText("0.0");
        this.maxLimitLabel.setText("0.0");
        this.minLimitLabel.setText("0.0");
        this.offset1Label.setText("0.0");
    }

    public static void main(String[] argv) {
        AnalogicSensorPanel d = new AnalogicSensorPanel("clampToto", "leBoCapteur", 0);
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

